/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.engine.jdbc.internal.BasicFormatterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQuery {
    private static final Logger ourLog = LoggerFactory.getLogger(SqlQuery.class);
    private final String myThreadName = Thread.currentThread().getName();
    private final String mySql;
    private final List<String> myParams;
    private final long myQueryTimestamp;
    private final long myElapsedTime;
    private final StackTraceElement[] myStackTrace;
    private final int mySize;
    private final LanguageEnum myLanguage;
    private final String myNamespace;
    private final RequestPartitionId myRequestPartitionId;

    public SqlQuery(String theSql, List<String> theParams, long theQueryTimestamp, long theElapsedTime, StackTraceElement[] theStackTraceElements, int theSize, RequestPartitionId theRequestPartitionId) {
        this(null, theSql, theParams, theQueryTimestamp, theElapsedTime, theStackTraceElements, theSize, LanguageEnum.SQL, theRequestPartitionId);
    }

    public SqlQuery(String theNamespace, String theSql, List<String> theParams, long theQueryTimestamp, long theElapsedTime, StackTraceElement[] theStackTraceElements, int theSize, LanguageEnum theLanguage, RequestPartitionId theRequestPartitionId) {
        Validate.notNull((Object)((Object)theLanguage), (String)"theLanguage must not be null", (Object[])new Object[0]);
        this.myNamespace = theNamespace;
        this.mySql = theSql;
        this.myParams = Collections.unmodifiableList(theParams);
        this.myQueryTimestamp = theQueryTimestamp;
        this.myElapsedTime = theElapsedTime;
        this.myStackTrace = theStackTraceElements;
        this.mySize = theSize;
        this.myLanguage = theLanguage;
        this.myRequestPartitionId = theRequestPartitionId;
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public long getQueryTimestamp() {
        return this.myQueryTimestamp;
    }

    public long getElapsedTime() {
        return this.myElapsedTime;
    }

    public String getThreadName() {
        return this.myThreadName;
    }

    public String getSql(boolean theInlineParams, boolean theFormat) {
        return this.getSql(theInlineParams, theFormat, false);
    }

    public LanguageEnum getLanguage() {
        return this.myLanguage;
    }

    public String getSql(boolean theInlineParams, boolean theFormat, boolean theSanitizeParams) {
        Object retVal = this.mySql;
        if (theFormat && this.getLanguage() == LanguageEnum.SQL) {
            retVal = new BasicFormatterImpl().format((String)retVal);
            while (((String)retVal).startsWith("\n")) {
                retVal = ((String)retVal).substring(1);
            }
        }
        if (theInlineParams) {
            ArrayList<String> nextParams = new ArrayList<String>(this.myParams);
            int idx = 0;
            while (nextParams.size() > 0 && (idx = ((String)retVal).indexOf("?", idx)) != -1) {
                Object nextSubstitution;
                String nextParamValue = (String)nextParams.remove(0);
                if (nextParamValue != null) {
                    if (theSanitizeParams) {
                        nextParamValue = UrlUtil.sanitizeUrlPart((CharSequence)nextParamValue);
                    }
                    nextSubstitution = "'" + nextParamValue + "'";
                } else {
                    nextSubstitution = "NULL";
                }
                retVal = ((String)retVal).substring(0, idx) + (String)nextSubstitution + ((String)retVal).substring(idx + 1);
                idx += ((String)nextSubstitution).length();
            }
        }
        return StringUtils.trim((String)retVal);
    }

    public StackTraceElement[] getStackTrace() {
        return this.myStackTrace;
    }

    public int getSize() {
        return this.mySize;
    }

    public String toString() {
        return this.getSql(true, true);
    }

    public static enum LanguageEnum {
        SQL,
        JSON;

    }
}

