/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.StringTokenizer;

public class TransactionSemanticsHeader {
    public static final String RETRY_COUNT = "retryCount";
    public static final String MIN_DELAY = "minRetryDelay";
    public static final String MAX_DELAY = "maxRetryDelay";
    public static final String TRY_BATCH_AS_TRANSACTION_FIRST = "tryBatchAsTransactionFirst";
    public static final TransactionSemanticsHeader DEFAULT = TransactionSemanticsHeader.newBuilder().build();
    public static final String HEADER_NAME = "X-Transaction-Semantics";
    private final Integer myRetryCount;
    private final Integer myMinRetryDelay;
    private final Integer myMaxRetryDelay;
    private final boolean myTryBatchAsTransactionFirst;

    private TransactionSemanticsHeader(Integer theRetryCount, Integer theMinRetryDelay, Integer theMaxRetryDelay, boolean theTryAsBatchAsTransactionFirst) {
        this.myRetryCount = theRetryCount;
        this.myMinRetryDelay = theMinRetryDelay;
        this.myMaxRetryDelay = theMaxRetryDelay;
        this.myTryBatchAsTransactionFirst = theTryAsBatchAsTransactionFirst;
    }

    public Integer getRetryCount() {
        return this.myRetryCount;
    }

    public Integer getMinRetryDelay() {
        return this.myMinRetryDelay;
    }

    public Integer getMaxRetryDelay() {
        return this.myMaxRetryDelay;
    }

    public boolean isTryBatchAsTransactionFirst() {
        return this.myTryBatchAsTransactionFirst;
    }

    public String toHeaderValue() {
        StringBuilder b = new StringBuilder();
        if (this.myRetryCount != null) {
            b.append(RETRY_COUNT).append('=').append(this.myRetryCount);
            if (this.myMinRetryDelay != null) {
                b.append("; ");
                b.append(MIN_DELAY).append('=').append(this.myMinRetryDelay);
            }
            if (this.myMaxRetryDelay != null) {
                b.append("; ");
                b.append(MAX_DELAY).append('=').append(this.myMaxRetryDelay);
            }
            if (this.myTryBatchAsTransactionFirst) {
                b.append("; ");
                b.append(TRY_BATCH_AS_TRANSACTION_FIRST).append('=').append("true");
            }
        }
        return b.toString();
    }

    public static TransactionSemanticsHeader parse(@Nonnull String theHeaderValue) {
        Validate.notNull((Object)theHeaderValue, (String)"theHeaderValue must not be null", (Object[])new Object[0]);
        Integer retryCount = null;
        Integer minRetryDelay = null;
        Integer maxRetryDelay = null;
        boolean tryBatchAsTransactionFirst = false;
        StringTokenizer tok = new StringTokenizer(theHeaderValue, ";");
        while (tok.hasNext()) {
            String next = tok.nextToken();
            int equalsIdx = next.indexOf(61);
            if (equalsIdx == -1) continue;
            String name = next.substring(0, equalsIdx).trim();
            String value = next.substring(equalsIdx + 1).trim();
            switch (name) {
                case "retryCount": {
                    retryCount = TransactionSemanticsHeader.parsePositiveInteger(value);
                    break;
                }
                case "minRetryDelay": {
                    minRetryDelay = TransactionSemanticsHeader.parsePositiveInteger(value);
                    break;
                }
                case "maxRetryDelay": {
                    maxRetryDelay = TransactionSemanticsHeader.parsePositiveInteger(value);
                    break;
                }
                case "tryBatchAsTransactionFirst": {
                    tryBatchAsTransactionFirst = TransactionSemanticsHeader.parseBoolean(value);
                }
            }
        }
        return new TransactionSemanticsHeader(retryCount, minRetryDelay, maxRetryDelay, tryBatchAsTransactionFirst);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static Integer parsePositiveInteger(String theValue) {
        try {
            int retVal = Integer.parseInt(theValue);
            if (retVal <= 0) {
                return null;
            }
            return retVal;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean parseBoolean(String theValue) {
        return "true".equalsIgnoreCase(theValue);
    }

    public static final class Builder {
        private Integer myRetryCount;
        private Integer myMinRetryDelay;
        private Integer myMaxRetryDelay;
        private boolean myTryBatchAsTransactionFirst;

        private Builder() {
        }

        public Builder withRetryCount(Integer theRetryCount) {
            Validate.isTrue((theRetryCount == null || theRetryCount >= 0 ? 1 : 0) != 0, (String)"Retry count must be null or a non-negative integer", (Object[])new Object[0]);
            this.myRetryCount = theRetryCount;
            return this;
        }

        public Builder withMinRetryDelay(Integer theMinRetryDelay) {
            Validate.isTrue((theMinRetryDelay == null || theMinRetryDelay >= 0 ? 1 : 0) != 0, (String)"Retry delay must be null or a non-negative integer", (Object[])new Object[0]);
            this.myMinRetryDelay = theMinRetryDelay;
            return this;
        }

        public Builder withMaxRetryDelay(Integer theMaxRetryDelay) {
            Validate.isTrue((theMaxRetryDelay == null || theMaxRetryDelay >= 0 ? 1 : 0) != 0, (String)"Retry delay must be null or a non-negative integer", (Object[])new Object[0]);
            this.myMaxRetryDelay = theMaxRetryDelay;
            return this;
        }

        public Builder withTryBatchAsTransactionFirst(boolean theTryBatchAsTransactionFirst) {
            this.myTryBatchAsTransactionFirst = theTryBatchAsTransactionFirst;
            return this;
        }

        public TransactionSemanticsHeader build() {
            return new TransactionSemanticsHeader(this.myRetryCount, this.myMinRetryDelay, this.myMaxRetryDelay, this.myTryBatchAsTransactionFirst);
        }
    }
}

