/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.merge;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.merge.MergeOperationInputParameterNames;
import ca.uhn.fhir.model.api.IProvenanceAgent;
import ca.uhn.fhir.replacereferences.ReplaceReferencesProvenanceSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.CanonicalIdentifier;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Type;

public class MergeProvenanceSvc
extends ReplaceReferencesProvenanceSvc {
    private static final String ACTIVITY_CODE_MERGE = "merge";
    private final MergeOperationInputParameterNames myInputParamNames = new MergeOperationInputParameterNames();

    public MergeProvenanceSvc(DaoRegistry theDaoRegistry) {
        super(theDaoRegistry);
    }

    @Override
    protected CodeableConcept getActivityCodeableConcept() {
        CodeableConcept retVal = new CodeableConcept();
        retVal.addCoding().setSystem("http://terminology.hl7.org/CodeSystem/iso-21089-lifecycle").setCode(ACTIVITY_CODE_MERGE);
        return retVal;
    }

    @Override
    public void createProvenance(IIdType theTargetId, IIdType theSourceId, List<Bundle> thePatchResultBundles, Date theStartTime, RequestDetails theRequestDetails, List<IProvenanceAgent> theProvenanceAgents, List<IBaseResource> theContainedResources) {
        super.createProvenance(theTargetId, theSourceId, thePatchResultBundles, theStartTime, theRequestDetails, theProvenanceAgents, theContainedResources, true);
    }

    @Nullable
    public Provenance findProvenanceByTargetIdAndSourceIdentifiers(IIdType theTargetId, List<CanonicalIdentifier> theSourceIdentifiers, RequestDetails theRequestDetails) {
        String sourceIdentifierParameterName = this.myInputParamNames.getSourceIdentifiersParameterName();
        List<Provenance> provenances = this.getProvenancesOfTargetsFilteredByActivity(List.of(theTargetId), theRequestDetails);
        for (Provenance provenance : provenances) {
            List originalInputSrcIdentifiers;
            Parameters parameters;
            Object e;
            if (!provenance.hasContained() || !((e = provenance.getContained().get(0)) instanceof Parameters) || !(parameters = (Parameters)e).hasParameter(sourceIdentifierParameterName) || !this.hasIdentifiers(originalInputSrcIdentifiers = parameters.getParameterValues(sourceIdentifierParameterName), theSourceIdentifiers)) continue;
            return provenance;
        }
        return null;
    }

    private boolean hasIdentifiers(List<Type> theIdentifiers, List<CanonicalIdentifier> theIdentifiersToLookFor) {
        for (CanonicalIdentifier identifier : theIdentifiersToLookFor) {
            boolean identifierFound = theIdentifiers.stream().map(i -> (Identifier)i).anyMatch(i -> i.getSystem().equals(identifier.getSystemElement().getValueAsString()) && i.getValue().equals(identifier.getValueElement().getValueAsString()));
            if (identifierFound) continue;
            return false;
        }
        return true;
    }
}

