/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.replacereferences;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Reference;

public class PreviousResourceVersionRestorer {
    private final HapiTransactionService myHapiTransactionService;
    private final DaoRegistry myDaoRegistry;

    public PreviousResourceVersionRestorer(DaoRegistry theDaoRegistry, HapiTransactionService theHapiTransactionService) {
        this.myDaoRegistry = theDaoRegistry;
        this.myHapiTransactionService = theHapiTransactionService;
    }

    public void restoreToPreviousVersionsInTrx(List<Reference> theReferences, Set<Reference> theReferencesToUndelete, RequestDetails theRequestDetails, RequestPartitionId thePartitionId) {
        this.myHapiTransactionService.withRequest(theRequestDetails).withRequestPartitionId(thePartitionId).execute(() -> this.restoreToPreviousVersions(theReferences, theReferencesToUndelete, theRequestDetails));
    }

    private void restoreToPreviousVersions(List<Reference> theReferences, Set<Reference> theReferencesToUndelete, RequestDetails theRequestDetails) {
        for (Reference reference : theReferences) {
            Long currentVersion;
            String msg;
            Object currentResource;
            IFhirResourceDao dao;
            long previousVersion;
            Long referenceVersion;
            IdDt referenceId;
            String referenceStr;
            block6: {
                referenceStr = reference.getReference();
                referenceId = new IdDt(referenceStr);
                if (!referenceId.hasVersionIdPart()) {
                    throw new IllegalArgumentException(Msg.code((int)2730) + "Reference does not have a version: " + referenceStr);
                }
                referenceVersion = referenceId.getVersionIdPartAsLong();
                previousVersion = referenceVersion - 1L;
                if (previousVersion < 1L) {
                    throw new IllegalArgumentException(Msg.code((int)2731) + "Resource cannot be restored to a previous as the provided version is 1: " + referenceStr);
                }
                dao = this.myDaoRegistry.getResourceDao(referenceId.getResourceType());
                currentResource = null;
                try {
                    currentResource = dao.read(referenceId.toUnqualifiedVersionless(), theRequestDetails);
                }
                catch (ResourceGoneException e) {
                    if (theReferencesToUndelete.contains(reference)) break block6;
                    msg = String.format("The resource '%s' cannot be restored because it was deleted. %s", referenceStr, e.getMessage());
                    throw new ResourceGoneException(Msg.code((int)2751) + msg);
                }
            }
            if (currentResource != null && !(currentVersion = currentResource.getIdElement().getVersionIdPartAsLong()).equals(referenceVersion)) {
                msg = String.format("The resource cannot be restored because the current version of resource %s (%s) does not match the expected version (%s)", referenceStr, currentVersion, referenceVersion);
                throw new ResourceVersionConflictException(Msg.code((int)2732) + msg);
            }
            IIdType previousId = referenceId.withVersion(Long.toString(previousVersion));
            Object previousResource = dao.read(previousId, theRequestDetails);
            previousResource.setId(previousResource.getIdElement().toUnqualifiedVersionless());
            dao.update(previousResource, theRequestDetails);
        }
    }
}

