/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.replacereferences;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.replacereferences.ReplaceReferencesRequest;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class ReplaceReferencesPatchBundleSvc {
    private final FhirContext myFhirContext;
    private final DaoRegistry myDaoRegistry;

    public ReplaceReferencesPatchBundleSvc(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
        this.myFhirContext = theDaoRegistry.getFhirContext();
    }

    public Bundle patchReferencingResources(ReplaceReferencesRequest theReplaceReferencesRequest, List<IdDt> theResourceIds, RequestDetails theRequestDetails) {
        Bundle patchBundle = this.buildPatchBundle(theReplaceReferencesRequest, theResourceIds, theRequestDetails);
        IFhirSystemDao systemDao = this.myDaoRegistry.getSystemDao();
        Bundle result = systemDao.transaction(theRequestDetails, patchBundle);
        result.setId(UUID.randomUUID().toString());
        return result;
    }

    private Bundle buildPatchBundle(ReplaceReferencesRequest theReplaceReferencesRequest, List<IdDt> theResourceIds, RequestDetails theRequestDetails) {
        BundleBuilder bundleBuilder = new BundleBuilder(this.myFhirContext);
        theResourceIds.forEach(referencingResourceId -> {
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(referencingResourceId.getResourceType());
            Object resource = dao.read((IIdType)referencingResourceId, theRequestDetails);
            Parameters patchParams = this.buildPatchParams(theReplaceReferencesRequest, (IBaseResource)resource);
            if (patchParams.hasParameter()) {
                IIdType resourceId = resource.getIdElement();
                bundleBuilder.addTransactionFhirPatchEntry(resourceId, (IBaseParameters)patchParams);
            }
        });
        return (Bundle)bundleBuilder.getBundleTyped();
    }

    @Nonnull
    private Parameters buildPatchParams(ReplaceReferencesRequest theReplaceReferencesRequest, IBaseResource referencingResource) {
        Parameters params = new Parameters();
        this.myFhirContext.newTerser().getAllResourceReferences(referencingResource).stream().filter(refInfo -> ReplaceReferencesPatchBundleSvc.matches(refInfo, theReplaceReferencesRequest.sourceId)).map(refInfo -> this.createReplaceReferencePatchOperation(this.getFhirPathForPatch(referencingResource, (ResourceReferenceInfo)refInfo), (Type)new Reference(theReplaceReferencesRequest.targetId.getValueAsString()))).forEach(arg_0 -> ((Parameters)params).addParameter(arg_0));
        return params;
    }

    private static boolean matches(ResourceReferenceInfo refInfo, IIdType theSourceId) {
        Reference ref;
        IBaseReference iBaseRef = refInfo.getResourceReference();
        if (iBaseRef == null || iBaseRef instanceof Reference && !(ref = (Reference)iBaseRef).hasReferenceElement()) {
            return false;
        }
        return iBaseRef.getReferenceElement().toUnqualified().getValueAsString().equals(theSourceId.getValueAsString());
    }

    private String getFhirPathForPatch(IBaseResource theReferencingResource, ResourceReferenceInfo theRefInfo) {
        String path = theReferencingResource.fhirType() + "." + theRefInfo.getName();
        int maxCardinality = this.myFhirContext.newTerser().getDefinition(theReferencingResource.getClass(), path).getMax();
        if (maxCardinality != 1) {
            return String.format("%s.where(reference='%s')", path, theRefInfo.getResourceReference().getReferenceElement().getValueAsString());
        }
        return path;
    }

    @Nonnull
    private Parameters.ParametersParameterComponent createReplaceReferencePatchOperation(String thePath, Type theValue) {
        Parameters.ParametersParameterComponent operation = new Parameters.ParametersParameterComponent();
        operation.setName("operation");
        operation.addPart().setName("type").setValue((Type)new CodeType("replace"));
        operation.addPart().setName("path").setValue((Type)new StringType(thePath));
        operation.addPart().setName("value").setValue(theValue);
        return operation;
    }
}

