/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.replacereferences;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IProvenanceAgent;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.StorageResponseCodeEnum;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.util.FhirTerser;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceReferencesProvenanceSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(ReplaceReferencesProvenanceSvc.class);
    private static final String ACT_REASON_CODE_SYSTEM = "http://terminology.hl7.org/CodeSystem/v3-ActReason";
    private static final String ACT_REASON_PATIENT_ADMINISTRATION_CODE = "PATADMIN";
    protected static final String ACTIVITY_CODE_SYSTEM = "http://terminology.hl7.org/CodeSystem/iso-21089-lifecycle";
    private static final String ACTIVITY_CODE_LINK = "link";
    private final IFhirResourceDao<IBaseResource> myProvenanceDao;
    private final FhirContext myFhirContext;

    public ReplaceReferencesProvenanceSvc(DaoRegistry theDaoRegistry) {
        this.myProvenanceDao = theDaoRegistry.getResourceDao("Provenance");
        this.myFhirContext = theDaoRegistry.getFhirContext();
    }

    protected CodeableConcept getActivityCodeableConcept() {
        CodeableConcept retVal = new CodeableConcept();
        retVal.addCoding().setSystem(ACTIVITY_CODE_SYSTEM).setCode(ACTIVITY_CODE_LINK);
        return retVal;
    }

    protected Provenance createProvenanceObject(Reference theTargetReference, @Nullable Reference theSourceReference, List<Reference> theUpdatedReferencingResources, Date theStartTime, List<IProvenanceAgent> theProvenanceAgents, List<IBaseResource> theContainedResources) {
        Provenance provenance = new Provenance();
        Date now = new Date();
        provenance.setOccurred((Type)new Period().setStart(theStartTime, TemporalPrecisionEnum.MILLI).setEnd(now, TemporalPrecisionEnum.MILLI));
        provenance.setRecorded(now);
        this.addAgents(theProvenanceAgents, provenance);
        CodeableConcept activityCodeableConcept = this.getActivityCodeableConcept();
        if (activityCodeableConcept != null) {
            provenance.setActivity(activityCodeableConcept);
        }
        CodeableConcept activityReasonCodeableConcept = new CodeableConcept();
        activityReasonCodeableConcept.addCoding().setSystem(ACT_REASON_CODE_SYSTEM).setCode(ACT_REASON_PATIENT_ADMINISTRATION_CODE);
        provenance.addReason(activityReasonCodeableConcept);
        provenance.addTarget(theTargetReference);
        provenance.addTarget(theSourceReference);
        theUpdatedReferencingResources.forEach(arg_0 -> ((Provenance)provenance).addTarget(arg_0));
        theContainedResources.forEach(c -> provenance.addContained((Resource)c));
        return provenance;
    }

    public void createProvenance(IIdType theTargetId, IIdType theSourceId, List<Bundle> thePatchResultBundles, Date theStartTime, RequestDetails theRequestDetails, List<IProvenanceAgent> theProvenanceAgents, List<IBaseResource> theContainedResources) {
        this.createProvenance(theTargetId, theSourceId, thePatchResultBundles, theStartTime, theRequestDetails, theProvenanceAgents, theContainedResources, false);
    }

    protected void createProvenance(IIdType theTargetId, IIdType theSourceId, List<Bundle> thePatchResultBundles, Date theStartTime, RequestDetails theRequestDetails, List<IProvenanceAgent> theProvenanceAgents, List<IBaseResource> theContainedResources, boolean theCreateEvenWhenNoReferencesWereUpdated) {
        Reference targetReference = new Reference(theTargetId);
        Reference sourceReference = new Reference(theSourceId);
        List<Reference> patchedReferences = this.extractUpdatedResourceReferences(thePatchResultBundles);
        if (!patchedReferences.isEmpty() || theCreateEvenWhenNoReferencesWereUpdated) {
            Provenance provenance = this.createProvenanceObject(targetReference, sourceReference, patchedReferences, theStartTime, theProvenanceAgents, theContainedResources);
            this.myProvenanceDao.create((IBaseResource)provenance, theRequestDetails);
        }
    }

    @Nullable
    public Provenance findProvenance(IIdType theTargetId, IIdType theSourceId, RequestDetails theRequestDetails, String theOperationName) {
        Provenance provenance;
        List<Provenance> provenances = this.getProvenancesOfTargetsFilteredByActivity(List.of(theTargetId, theSourceId), theRequestDetails);
        if (provenances.isEmpty()) {
            return null;
        }
        if (provenances.size() > 1) {
            ourLog.warn("There are multiple Provenance resources with the given source {} and target {} suitable for {} operation, will use the most recent one. Provenance count: {}", new Object[]{theSourceId, theTargetId, theOperationName, provenances.size()});
        }
        if (this.isTargetAndSourceInCorrectOrder(provenance = provenances.get(0), theTargetId, theSourceId)) {
            return provenance;
        }
        return null;
    }

    protected List<Provenance> getProvenancesOfTargetsFilteredByActivity(List<IIdType> theTargetIds, RequestDetails theRequestDetails) {
        SearchParameterMap map = new SearchParameterMap();
        theTargetIds.forEach(tId -> map.add("target", (IQueryParameterType)new ReferenceParam(tId)));
        map.setSort(new SortSpec("recorded", SortOrderEnum.DESC));
        IBundleProvider searchBundle = this.myProvenanceDao.search(map, theRequestDetails);
        return this.filterByActivity(searchBundle.getAllResources());
    }

    private List<Provenance> filterByActivity(List<IBaseResource> theResources) {
        ArrayList<Provenance> filteredProvenances = new ArrayList<Provenance>();
        for (IBaseResource resource : theResources) {
            Provenance provenance = (Provenance)resource;
            if (!provenance.hasActivity() || !provenance.getActivity().equalsDeep((Base)this.getActivityCodeableConcept())) continue;
            filteredProvenances.add(provenance);
        }
        return filteredProvenances;
    }

    public boolean isTargetAndSourceInCorrectOrder(Provenance provenance, IIdType theTargetId, IIdType theSourceId) {
        boolean result;
        if (provenance.getTarget().size() < 2) {
            ourLog.error("Provenance resource {} does not have enough targets. Expected at least 2, found {}.", (Object)provenance.getIdElement().getValue(), (Object)provenance.getTarget().size());
            return false;
        }
        Reference firstTargetRefInProv = (Reference)provenance.getTarget().get(0);
        Reference secondTargetRefInProv = (Reference)provenance.getTarget().get(1);
        boolean firstMatches = this.isEqualVersionlessId(theTargetId, firstTargetRefInProv);
        boolean secondMatches = this.isEqualVersionlessId(theSourceId, secondTargetRefInProv);
        boolean bl = result = firstMatches && secondMatches;
        if (!result) {
            ourLog.error("Provenance resource {} doesn't have the expected target and source references or they are in the wrong order. Expected target: {}, source: {}, but found target: {}, source: {}", new Object[]{provenance.getIdElement().getValue(), theTargetId.getValue(), theSourceId.getValue(), firstTargetRefInProv.getReference(), secondTargetRefInProv.getReference()});
        }
        return result;
    }

    private boolean isEqualVersionlessId(IIdType theId, Reference theReference) {
        if (!theReference.hasReference()) {
            return false;
        }
        return theId.toUnqualifiedVersionless().getValue().equals(new IdDt(theReference.getReference()).toUnqualifiedVersionless().getValue());
    }

    protected List<Reference> extractUpdatedResourceReferences(List<Bundle> thePatchBundles) {
        ArrayList<Reference> patchedResourceReferences = new ArrayList<Reference>();
        thePatchBundles.forEach(outputBundle -> outputBundle.getEntry().forEach(entry -> {
            if (entry.getResponse() != null && entry.getResponse().hasLocation()) {
                if (this.isNoopPatch(entry.getResponse())) {
                    ourLog.warn("Not adding reference {} to Provenance, because the patch resulted in a no-op change", (Object)entry.getResponse().getLocation());
                    return;
                }
                Reference reference = new Reference(entry.getResponse().getLocation());
                patchedResourceReferences.add(reference);
            }
        }));
        return patchedResourceReferences;
    }

    private boolean isNoopPatch(Bundle.BundleEntryResponseComponent theResponse) {
        if (!theResponse.hasOutcome()) {
            return false;
        }
        OperationOutcome outcome = (OperationOutcome)theResponse.getOutcome();
        if (!outcome.hasIssue()) {
            return false;
        }
        List issues = outcome.getIssue();
        return issues.stream().filter(issue -> issue.hasDetails() && issue.getDetails().hasCoding()).map(issue -> issue.getDetails().getCoding()).flatMap(Collection::stream).anyMatch(coding -> "https://hapifhir.io/fhir/CodeSystem/hapi-fhir-storage-response-code".equals(coding.getSystem()) && StorageResponseCodeEnum.SUCCESSFUL_PATCH_NO_CHANGE.getCode().equals(coding.getCode()));
    }

    private Provenance.ProvenanceAgentComponent createR4ProvenanceAgent(IProvenanceAgent theProvenanceAgent) {
        Provenance.ProvenanceAgentComponent agent = new Provenance.ProvenanceAgentComponent();
        Reference whoRef = this.convertToR4Reference(theProvenanceAgent.getWho());
        agent.setWho(whoRef);
        Reference onBehalfOfRef = this.convertToR4Reference(theProvenanceAgent.getOnBehalfOf());
        agent.setOnBehalfOf(onBehalfOfRef);
        return agent;
    }

    private void addAgents(List<IProvenanceAgent> theProvenanceAgents, Provenance theProvenance) {
        if (theProvenanceAgents != null) {
            for (IProvenanceAgent agent : theProvenanceAgents) {
                Provenance.ProvenanceAgentComponent r4Agent = this.createR4ProvenanceAgent(agent);
                theProvenance.addAgent(r4Agent);
            }
        }
    }

    private Reference convertToR4Reference(IBaseReference sourceRef) {
        if (sourceRef == null) {
            return null;
        }
        FhirTerser terser = this.myFhirContext.newTerser();
        Reference targetRef = new Reference();
        terser.cloneInto((IBase)sourceRef, (IBase)targetRef, false);
        return targetRef;
    }
}

