/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.replacereferences;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.model.api.IProvenanceAgent;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;

public class ReplaceReferencesRequest {
    @Nonnull
    public final IIdType sourceId;
    @Nonnull
    public final IIdType targetId;
    public final int resourceLimit;
    public final RequestPartitionId partitionId;
    public final boolean createProvenance;
    public final List<IProvenanceAgent> provenanceAgents;

    public ReplaceReferencesRequest(@Nonnull IIdType theSourceId, @Nonnull IIdType theTargetId, int theResourceLimit, RequestPartitionId thePartitionId, boolean theCreateProvenance, List<IProvenanceAgent> theProvenanceAgents) {
        this.sourceId = theSourceId.toUnqualifiedVersionless();
        this.targetId = theTargetId.toUnqualifiedVersionless();
        this.resourceLimit = theResourceLimit;
        this.partitionId = thePartitionId;
        this.createProvenance = theCreateProvenance;
        this.provenanceAgents = theProvenanceAgents;
    }

    public void validateOrThrowInvalidParameterException() {
        if (StringUtils.isBlank((CharSequence)this.sourceId.getResourceType())) {
            throw new InvalidRequestException(Msg.code((int)2585) + "'source-reference-id' must be a resource type qualified id");
        }
        if (StringUtils.isBlank((CharSequence)this.targetId.getResourceType())) {
            throw new InvalidRequestException(Msg.code((int)2586) + "'target-reference-id' must be a resource type qualified id");
        }
        if (!this.targetId.getResourceType().equals(this.sourceId.getResourceType())) {
            throw new InvalidRequestException(Msg.code((int)2587) + "Source and target id parameters must be for the same resource type");
        }
    }
}

