/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.replacereferences;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.replacereferences.PreviousResourceVersionRestorer;
import ca.uhn.fhir.replacereferences.ReplaceReferencesProvenanceSvc;
import ca.uhn.fhir.replacereferences.UndoReplaceReferencesRequest;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoReplaceReferencesSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(UndoReplaceReferencesSvc.class);
    private final ReplaceReferencesProvenanceSvc myReplaceReferencesProvenanceSvc;
    private final PreviousResourceVersionRestorer myResourceVersionRestorer;
    private final FhirContext myFhirContext;
    private final DaoRegistry myDaoRegistry;

    public UndoReplaceReferencesSvc(DaoRegistry theDaoRegistry, ReplaceReferencesProvenanceSvc theReplaceReferencesProvenanceSvc, PreviousResourceVersionRestorer theResourceVersionRestorer) {
        this.myDaoRegistry = theDaoRegistry;
        this.myReplaceReferencesProvenanceSvc = theReplaceReferencesProvenanceSvc;
        this.myResourceVersionRestorer = theResourceVersionRestorer;
        this.myFhirContext = theDaoRegistry.getFhirContext();
    }

    public IBaseParameters undoReplaceReferences(UndoReplaceReferencesRequest theUndoReplaceReferencesRequest, RequestDetails theRequestDetails) {
        this.readResource(theUndoReplaceReferencesRequest.sourceId, theRequestDetails);
        this.readResource(theUndoReplaceReferencesRequest.targetId, theRequestDetails);
        Provenance provenance = this.myReplaceReferencesProvenanceSvc.findProvenance(theUndoReplaceReferencesRequest.targetId, theUndoReplaceReferencesRequest.sourceId, theRequestDetails, "$hapi.fhir.undo-replace-references");
        if (provenance == null) {
            String msg = "Unable to find a Provenance created by a $hapi.fhir.replace-references for the provided source and target IDs. Ensure that IDs are correct and were previously used as parameters in a successful $hapi.fhir.replace-references operation";
            throw new ResourceNotFoundException(Msg.code((int)2728) + msg);
        }
        ourLog.info("Found Provenance resource with id: {} to be used for $undo-replace-references operation", (Object)provenance.getIdElement().getValue());
        List references = provenance.getTarget();
        List<Reference> toRestore = references.subList(2, references.size());
        if (toRestore.size() > theUndoReplaceReferencesRequest.resourceLimit) {
            String msg = String.format("Number of references to update (%d) exceeds the limit (%d)", toRestore.size(), theUndoReplaceReferencesRequest.resourceLimit);
            throw new InvalidRequestException(Msg.code((int)2729) + msg);
        }
        this.myResourceVersionRestorer.restoreToPreviousVersionsInTrx(toRestore, Collections.emptySet(), theRequestDetails, theUndoReplaceReferencesRequest.partitionId);
        IBaseOperationOutcome opOutcome = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
        String msg = String.format("Successfully restored %d resources to their previous versions based on the Provenance resource: %s", toRestore.size(), provenance.getIdElement().getValue());
        OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)opOutcome, (String)"information", (String)msg, null, null);
        IBaseParameters outputParameters = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParameters((FhirContext)this.myFhirContext, (IBaseParameters)outputParameters, (String)"outcome", (Object)opOutcome);
        return outputParameters;
    }

    private IBaseResource readResource(IIdType theId, RequestDetails theRequestDetails) {
        String resourceType = theId.getResourceType();
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(resourceType);
        return resourceDao.read(theId, theRequestDetails);
    }
}

