/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.storage.interceptor.AutoCreatePlaceholderReferenceTargetRequest;
import ca.uhn.fhir.storage.interceptor.AutoCreatePlaceholderReferenceTargetResponse;
import java.util.Set;

@Interceptor
public class AutoCreatePlaceholderReferenceEnabledByTypeInterceptor {
    private final Set<String> myResourceTypesToAllow;

    public AutoCreatePlaceholderReferenceEnabledByTypeInterceptor(String ... theResourceTypesToAllow) {
        this.myResourceTypesToAllow = Set.of(theResourceTypesToAllow);
    }

    @Hook(value=Pointcut.STORAGE_PRE_AUTO_CREATE_PLACEHOLDER_REFERENCE)
    public AutoCreatePlaceholderReferenceTargetResponse autoCreatePlaceholderReferenceTarget(AutoCreatePlaceholderReferenceTargetRequest theRequest) {
        String resourceType = theRequest.getTargetResourceToCreate().getIdElement().getResourceType();
        if (!this.myResourceTypesToAllow.contains(resourceType)) {
            return AutoCreatePlaceholderReferenceTargetResponse.doNotCreateTarget();
        }
        return AutoCreatePlaceholderReferenceTargetResponse.proceed();
    }
}

