/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.interceptor.balp;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.storage.interceptor.balp.FhirClientBalpSink;
import ca.uhn.fhir.storage.interceptor.balp.IBalpAuditEventSink;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.ThreadPoolUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class AsyncMemoryQueueBackedFhirClientBalpSink
extends FhirClientBalpSink
implements IBalpAuditEventSink {
    public static final IBaseResource[] EMPTY_RESOURCE_ARRAY = new IBaseResource[0];
    private static final AtomicLong ourNextThreadId = new AtomicLong(0L);
    private static final Logger ourLog = LoggerFactory.getLogger(AsyncMemoryQueueBackedFhirClientBalpSink.class);
    private final List<IBaseResource> myQueue = new ArrayList<IBaseResource>(100);
    private final ThreadPoolTaskExecutor myThreadPool;
    private final Runnable myTransmitterTask = new TransmitterTask();

    public AsyncMemoryQueueBackedFhirClientBalpSink(@Nonnull FhirContext theFhirContext, @Nonnull String theTargetBaseUrl) {
        this(theFhirContext, theTargetBaseUrl, null);
    }

    public AsyncMemoryQueueBackedFhirClientBalpSink(@Nonnull FhirContext theFhirContext, @Nonnull String theTargetBaseUrl, @Nullable List<Object> theClientInterceptors) {
        this(AsyncMemoryQueueBackedFhirClientBalpSink.createClient(theFhirContext, theTargetBaseUrl, theClientInterceptors));
    }

    public AsyncMemoryQueueBackedFhirClientBalpSink(IGenericClient theClient) {
        super(theClient);
        this.myThreadPool = ThreadPoolUtil.newThreadPool(1, 1, "BalpClientSink-" + ourNextThreadId.getAndIncrement() + "-", Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recordAuditEvent(IBaseResource theAuditEvent) {
        List<IBaseResource> list = this.myQueue;
        synchronized (list) {
            this.myQueue.add(theAuditEvent);
        }
        this.myThreadPool.submit(this.myTransmitterTask);
    }

    @PreDestroy
    public void stop() {
        this.myThreadPool.shutdown();
    }

    private class TransmitterTask
    implements Runnable {
        private TransmitterTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IBaseResource[] queue;
            List<IBaseResource> list = AsyncMemoryQueueBackedFhirClientBalpSink.this.myQueue;
            synchronized (list) {
                if (AsyncMemoryQueueBackedFhirClientBalpSink.this.myQueue.isEmpty()) {
                    queue = EMPTY_RESOURCE_ARRAY;
                } else {
                    queue = AsyncMemoryQueueBackedFhirClientBalpSink.this.myQueue.toArray(EMPTY_RESOURCE_ARRAY);
                    AsyncMemoryQueueBackedFhirClientBalpSink.this.myQueue.clear();
                }
            }
            if (queue.length == 0) {
                return;
            }
            BundleBuilder bundleBuilder = new BundleBuilder(AsyncMemoryQueueBackedFhirClientBalpSink.this.myClient.getFhirContext());
            for (IBaseResource next : queue) {
                bundleBuilder.addTransactionCreateEntry(next);
            }
            IBaseBundle transactionBundle = bundleBuilder.getBundle();
            try {
                AsyncMemoryQueueBackedFhirClientBalpSink.this.myClient.transaction().withBundle(transactionBundle).execute();
                return;
            }
            catch (BaseServerResponseException e) {
                ourLog.error("Failed to transmit AuditEvent items to target. Will re-attempt {} failed events once. Error: {}", (Object)queue.length, (Object)e.toString());
                for (IBaseResource next : queue) {
                    try {
                        AsyncMemoryQueueBackedFhirClientBalpSink.this.myClient.create().resource(next).execute();
                    }
                    catch (BaseServerResponseException e2) {
                        ourLog.error("Second failure uploading AuditEvent. Error: {}", (Object)e2.toString());
                    }
                }
                return;
            }
        }
    }
}

