/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.interceptor.balp;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.storage.interceptor.balp.IBalpAuditEventSink;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.AuditEvent;

public class FhirClientBalpSink
implements IBalpAuditEventSink {
    protected final IGenericClient myClient;
    private final VersionCanonicalizer myVersionCanonicalizer;

    public FhirClientBalpSink(@Nonnull FhirContext theFhirContext, @Nonnull String theTargetBaseUrl) {
        this(theFhirContext, theTargetBaseUrl, null);
    }

    public FhirClientBalpSink(@Nonnull FhirContext theFhirContext, @Nonnull String theTargetBaseUrl, @Nullable List<Object> theClientInterceptors) {
        this(FhirClientBalpSink.createClient(theFhirContext, theTargetBaseUrl, theClientInterceptors));
    }

    public FhirClientBalpSink(IGenericClient theClient) {
        this.myClient = theClient;
        this.myVersionCanonicalizer = new VersionCanonicalizer(this.myClient.getFhirContext());
    }

    @Override
    public void recordAuditEvent(AuditEvent theAuditEvent) {
        IBaseResource auditEvent = this.myVersionCanonicalizer.auditEventFromCanonical(theAuditEvent);
        this.recordAuditEvent(auditEvent);
    }

    protected void recordAuditEvent(IBaseResource auditEvent) {
        this.transmitEventToClient(auditEvent);
    }

    protected void transmitEventToClient(IBaseResource auditEvent) {
        this.myClient.create().resource(auditEvent).execute();
    }

    static IGenericClient createClient(@Nonnull FhirContext theFhirContext, @Nonnull String theTargetBaseUrl, @Nullable List<Object> theClientInterceptors) {
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theTargetBaseUrl, (String)"theTargetBaseUrl must not be null or blank", (Object[])new Object[0]);
        IGenericClient client = theFhirContext.newRestfulGenericClient(theTargetBaseUrl);
        if (theClientInterceptors != null) {
            theClientInterceptors.forEach(arg_0 -> ((IGenericClient)client).registerInterceptor(arg_0));
        }
        return client;
    }
}

