/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.interceptor.balp;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.storage.interceptor.balp.BalpConstants;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.Reference;

public interface IBalpAuditContextServices {
    @Nonnull
    public Reference getAgentClientWho(RequestDetails var1);

    @Nonnull
    public Reference getAgentUserWho(RequestDetails var1);

    default public String getNetworkAddress(RequestDetails theRequestDetails) {
        String remoteAddr = null;
        if (theRequestDetails instanceof ServletRequestDetails) {
            remoteAddr = ((ServletRequestDetails)theRequestDetails).getServletRequest().getRemoteAddr();
        }
        return remoteAddr;
    }

    default public AuditEvent.AuditEventAgentNetworkType getNetworkAddressType(RequestDetails theRequestDetails) {
        return BalpConstants.AUDIT_EVENT_AGENT_NETWORK_TYPE_IP_ADDRESS;
    }

    @Nonnull
    default public String massageResourceIdForStorage(@Nonnull RequestDetails theRequestDetails, @Nonnull IBaseResource theResource, @Nonnull IIdType theResourceId) {
        String serverBaseUrl = theRequestDetails.getFhirServerBase();
        String resourceName = theResourceId.getResourceType();
        return theResourceId.withServerBase(serverBaseUrl, resourceName).getValue();
    }
}

