/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.rest.api.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.ParserType;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2016may.utils.INarrativeGenerator;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.utilities.i18n.I18nBase;

public final class HapiWorkerContext
extends I18nBase
implements IWorkerContext {
    private final FhirContext myCtx;
    private Map<String, Resource> myFetchedResourceCache = new HashMap<String, Resource>();
    private IValidationSupport myValidationSupport;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        this.setValidationMessageLanguage(this.getLocale());
    }

    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.fetchAllStructureDefinitions();
    }

    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (CodeSystem)this.myValidationSupport.fetchCodeSystem(theSystem);
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null) {
            return null;
        }
        Resource retVal = this.myFetchedResourceCache.get(theUri);
        if (retVal == null && (retVal = (Resource)this.myValidationSupport.fetchResource(theClass, theUri)) != null) {
            this.myFetchedResourceCache.put(theUri, retVal);
        }
        return (T)retVal;
    }

    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException();
    }

    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(String theType) {
        throw new UnsupportedOperationException();
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException();
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException();
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException();
    }

    public INarrativeGenerator getNarrativeGenerator(String theS, String theS1) {
        throw new UnsupportedOperationException();
    }

    public String oid2Uri(String theCode) {
        throw new UnsupportedOperationException();
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(this.myValidationSupport, theSystem);
    }

    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(null, null);
    }

    public IWorkerContext.ValidationResult validateCode(Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(system, code, display, theVs);
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(this.myValidationSupport, new ConceptValidationOptions(), theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        OperationOutcome.IssueSeverity severity = null;
        if (result.getSeverity() != null) {
            severity = OperationOutcome.IssueSeverity.fromCode((String)result.getSeverityCode());
        }
        CodeSystem.ConceptDefinitionComponent definition = result.getCode() != null ? new CodeSystem.ConceptDefinitionComponent().setCode(result.getCode()) : null;
        return new IWorkerContext.ValidationResult(severity, result.getMessage(), definition);
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet.ConceptSetComponent theVsi) {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        if (theVs != null && StringUtils.isNotBlank((CharSequence)theCode)) {
            for (ValueSet.ConceptSetComponent next : theVs.getCompose().getInclude()) {
                if (!StringUtils.isBlank((CharSequence)theSystem) && !theSystem.equals(next.getSystem())) continue;
                for (ValueSet.ConceptReferenceComponent nextCode : next.getConcept()) {
                    if (!theCode.equals(nextCode.getCode())) continue;
                    CodeType code = new CodeType(theCode);
                    return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent(code));
                }
            }
        }
        boolean caseSensitive = true;
        if (StringUtils.isNotBlank((CharSequence)theSystem)) {
            CodeSystem system = this.fetchCodeSystem(theSystem);
            if (system == null) {
                return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.INFORMATION, "Code " + Constants.codeSystemWithDefaultDescription((String)theSystem) + "/" + theCode + " was not validated because the code system is not present");
            }
            if (system.hasCaseSensitive()) {
                caseSensitive = system.getCaseSensitive();
            }
        }
        String wantCode = theCode;
        if (!caseSensitive) {
            wantCode = wantCode.toUpperCase();
        }
        ValueSetExpander.ValueSetExpansionOutcome expandedValueSet = null;
        if (theVs != null && "http://hl7.org/fhir/ValueSet/languages".equals(theVs.getUrl())) {
            ValueSet expansion = new ValueSet();
            for (ValueSet.ConceptSetComponent nextInclude : theVs.getCompose().getInclude()) {
                for (ValueSet.ConceptReferenceComponent nextConcept : nextInclude.getConcept()) {
                    expansion.getExpansion().addContains().setCode(nextConcept.getCode()).setDisplay(nextConcept.getDisplay());
                }
            }
            expandedValueSet = new ValueSetExpander.ValueSetExpansionOutcome(expansion);
        }
        if (expandedValueSet == null) {
            expandedValueSet = this.expandVS(theVs, true);
        }
        for (ValueSet.ValueSetExpansionContainsComponent next : expandedValueSet.getValueset().getExpansion().getContains()) {
            String nextCode = next.getCode();
            if (!caseSensitive) {
                nextCode = nextCode.toUpperCase();
            }
            if (!nextCode.equals(wantCode) || theSystem != null && !next.getSystem().equals(theSystem)) continue;
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(next.getCode());
            definition.setDisplay(next.getDisplay());
            return new IWorkerContext.ValidationResult(definition);
        }
        return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "]");
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk) {
        throw new UnsupportedOperationException();
    }

    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent theInc) {
        throw new UnsupportedOperationException();
    }
}

