/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.hapi.validation;

import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.validation.ValidationMessage;

abstract class BaseValidatorBridge
implements IValidatorModule {
    private void doValidate(IValidationContext<?> theCtx) {
        List<ValidationMessage> messages = this.validate(theCtx);
        for (ValidationMessage riMessage : messages) {
            SingleValidationMessage hapiMessage = new SingleValidationMessage();
            if (riMessage.getCol() != -1) {
                hapiMessage.setLocationCol(Integer.valueOf(riMessage.getCol()));
            }
            if (riMessage.getLine() != -1) {
                hapiMessage.setLocationLine(Integer.valueOf(riMessage.getLine()));
            }
            hapiMessage.setLocationString(riMessage.getLocation());
            hapiMessage.setMessage(riMessage.getMessage());
            if (riMessage.getLevel() != null) {
                hapiMessage.setSeverity(ResultSeverityEnum.fromCode((String)riMessage.getLevel().toCode()));
            }
            theCtx.addValidationMessage(hapiMessage);
        }
    }

    protected abstract List<ValidationMessage> validate(IValidationContext<?> var1);

    public void validateResource(IValidationContext<IBaseResource> theCtx) {
        this.doValidate(theCtx);
    }
}

