/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.StructureDefinition;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.model.dstu2.valueset.ConceptMapEquivalenceEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ConceptMap", profile="http://hl7.org/fhir/profiles/ConceptMap", id="conceptmap")
public class ConceptMap
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="url", path="ConceptMap.url", description="The URL of the concept map", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="identifier", path="ConceptMap.identifier", description="Additional identifier for the concept map", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="ConceptMap.version", description="The version identifier of the concept map", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="ConceptMap.name", description="Name of the concept map", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ConceptMap.publisher", description="Name of the publisher of the concept map", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="ConceptMap.description", description="Text search in the description of the concept map", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="ConceptMap.status", description="Status of the concept map", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="ConceptMap.date", description="The concept map publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="source", path="ConceptMap.sourceReference", description="", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    @SearchParamDefinition(name="sourceuri", path="ConceptMap.sourceUri", description="", type="reference")
    public static final String SP_SOURCEURI = "sourceuri";
    public static final ReferenceClientParam SOURCEURI = new ReferenceClientParam("sourceuri");
    @SearchParamDefinition(name="target", path="ConceptMap.target[x]", description="", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    @SearchParamDefinition(name="sourcesystem", path="ConceptMap.element.codeSystem", description="", type="uri")
    public static final String SP_SOURCESYSTEM = "sourcesystem";
    public static final UriClientParam SOURCESYSTEM = new UriClientParam("sourcesystem");
    @SearchParamDefinition(name="targetsystem", path="ConceptMap.element.target.codeSystem", description="", type="uri")
    public static final String SP_TARGETSYSTEM = "targetsystem";
    public static final UriClientParam TARGETSYSTEM = new UriClientParam("targetsystem");
    @SearchParamDefinition(name="sourcecode", path="ConceptMap.element.code", description="", type="token")
    public static final String SP_SOURCECODE = "sourcecode";
    public static final TokenClientParam SOURCECODE = new TokenClientParam("sourcecode");
    @SearchParamDefinition(name="targetcode", path="ConceptMap.element.target.code", description="", type="token")
    public static final String SP_TARGETCODE = "targetcode";
    public static final TokenClientParam TARGETCODE = new TokenClientParam("targetcode");
    @SearchParamDefinition(name="dependson", path="ConceptMap.element.target.dependsOn.element", description="", type="uri")
    public static final String SP_DEPENDSON = "dependson";
    public static final UriClientParam DEPENDSON = new UriClientParam("dependson");
    @SearchParamDefinition(name="product", path="ConceptMap.element.target.product.element", description="", type="uri")
    public static final String SP_PRODUCT = "product";
    public static final UriClientParam PRODUCT = new UriClientParam("product");
    @SearchParamDefinition(name="context", path="ConceptMap.useContext", description="A use context assigned to the concept map", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    public static final Include INCLUDE_SOURCE = new Include("ConceptMap:source");
    public static final Include INCLUDE_SOURCEURI = new Include("ConceptMap:sourceuri");
    public static final Include INCLUDE_TARGET = new Include("ConceptMap:target");
    @Child(name="url", type={UriDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An absolute URL that is used to identify this concept map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this concept map is (or will be) published")
    private UriDt myUrl;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    private IdentifierDt myIdentifier;
    @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name describing the concept map")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The status of the concept map")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This ConceptMap was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of the individual or organization that published the concept map")
    private StringDt myPublisher;
    @Child(name="contact", order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date this version of the concept map was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes")
    private DateTimeDt myDate;
    @Child(name="description", type={StringDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language description of the use of the concept map - reason for definition, conditions of use, etc.")
    private StringDt myDescription;
    @Child(name="useContext", type={CodeableConceptDt.class}, order=10, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of concept map instances.")
    private List<CodeableConceptDt> myUseContext;
    @Child(name="requirements", type={StringDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Explains why this concept map is needed and why it has been constrained as it has")
    private StringDt myRequirements;
    @Child(name="copyright", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A copyright statement relating to the concept map and/or its contents")
    private StringDt myCopyright;
    @Child(name="source", order=13, min=1, max=1, summary=true, modifier=false, type={UriDt.class, ValueSet.class, StructureDefinition.class})
    @Description(shortDefinition="", formalDefinition="The source value set that specifies the concepts that are being mapped")
    private IDatatype mySource;
    @Child(name="target", order=14, min=1, max=1, summary=true, modifier=false, type={UriDt.class, ValueSet.class, StructureDefinition.class})
    @Description(shortDefinition="", formalDefinition="The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made")
    private IDatatype myTarget;
    @Child(name="element", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Mappings for an individual concept in the source to one or more concepts in the target")
    private List<Element> myElement;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myRequirements, this.myCopyright, this.mySource, this.myTarget, this.myElement});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myRequirements, this.myCopyright, this.mySource, this.myTarget, this.myElement});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public ConceptMap setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public ConceptMap setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public ConceptMap setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public ConceptMap setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public ConceptMap setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public ConceptMap setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public ConceptMap setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public ConceptMap setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ConceptMap setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public ConceptMap setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public ConceptMap setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public ConceptMap setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public ConceptMap setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public ConceptMap setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public ConceptMap addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public ConceptMap setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ConceptMap setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ConceptMap setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public ConceptMap setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ConceptMap setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getUseContext() {
        if (this.myUseContext == null) {
            this.myUseContext = new ArrayList<CodeableConceptDt>();
        }
        return this.myUseContext;
    }

    public ConceptMap setUseContext(List<CodeableConceptDt> theValue) {
        this.myUseContext = theValue;
        return this;
    }

    public CodeableConceptDt addUseContext() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getUseContext().add(newType);
        return newType;
    }

    public ConceptMap addUseContext(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUseContext().add(theValue);
        return this;
    }

    public CodeableConceptDt getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            return this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public ConceptMap setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public ConceptMap setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public String getCopyright() {
        return (String)this.getCopyrightElement().getValue();
    }

    public ConceptMap setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public ConceptMap setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public IDatatype getSource() {
        return this.mySource;
    }

    public ConceptMap setSource(IDatatype theValue) {
        this.mySource = theValue;
        return this;
    }

    public IDatatype getTarget() {
        return this.myTarget;
    }

    public ConceptMap setTarget(IDatatype theValue) {
        this.myTarget = theValue;
        return this;
    }

    public List<Element> getElement() {
        if (this.myElement == null) {
            this.myElement = new ArrayList<Element>();
        }
        return this.myElement;
    }

    public ConceptMap setElement(List<Element> theValue) {
        this.myElement = theValue;
        return this;
    }

    public Element addElement() {
        Element newType = new Element();
        this.getElement().add(newType);
        return newType;
    }

    public ConceptMap addElement(Element theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getElement().add(theValue);
        return this;
    }

    public Element getElementFirstRep() {
        if (this.getElement().isEmpty()) {
            return this.addElement();
        }
        return this.getElement().get(0);
    }

    public String getResourceName() {
        return "ConceptMap";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class ElementTargetDependsOn
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="element", type={UriDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A reference to a specific concept that holds a coded value. This can be an element in a FHIR resource, or a specific reference to a data element in a different specification (e.g. HL7 v2) or a general reference to a kind of data field, or a reference to a value set with an appropriately narrow definition")
        private UriDt myElement;
        @Child(name="codeSystem", type={UriDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems)")
        private UriDt myCodeSystem;
        @Child(name="code", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identity (code or path) or the element/item/ValueSet that the map depends on / refers to")
        private StringDt myCode;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myElement, this.myCodeSystem, this.myCode});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myElement, this.myCodeSystem, this.myCode});
        }

        public UriDt getElementElement() {
            if (this.myElement == null) {
                this.myElement = new UriDt();
            }
            return this.myElement;
        }

        public String getElement() {
            return (String)this.getElementElement().getValue();
        }

        public ElementTargetDependsOn setElement(UriDt theValue) {
            this.myElement = theValue;
            return this;
        }

        public ElementTargetDependsOn setElement(String theUri) {
            this.myElement = new UriDt(theUri);
            return this;
        }

        public UriDt getCodeSystemElement() {
            if (this.myCodeSystem == null) {
                this.myCodeSystem = new UriDt();
            }
            return this.myCodeSystem;
        }

        public String getCodeSystem() {
            return (String)this.getCodeSystemElement().getValue();
        }

        public ElementTargetDependsOn setCodeSystem(UriDt theValue) {
            this.myCodeSystem = theValue;
            return this;
        }

        public ElementTargetDependsOn setCodeSystem(String theUri) {
            this.myCodeSystem = new UriDt(theUri);
            return this;
        }

        public StringDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new StringDt();
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public ElementTargetDependsOn setCode(StringDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ElementTargetDependsOn setCode(String theString) {
            this.myCode = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class ElementTarget
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="codeSystem", type={UriDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI that identifies the code system of the target code (if the target is a value set that cross code systems)")
        private UriDt myCodeSystem;
        @Child(name="code", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identity (code or path) or the element/item that the map refers to")
        private CodeDt myCode;
        @Child(name="equivalence", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source)")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/concept-map-equivalence")
        private BoundCodeDt<ConceptMapEquivalenceEnum> myEquivalence;
        @Child(name="comments", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A description of status/issues in mapping that conveys additional information not represented in  the structured data")
        private StringDt myComments;
        @Child(name="dependsOn", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value")
        private List<ElementTargetDependsOn> myDependsOn;
        @Child(name="product", type={ElementTargetDependsOn.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on")
        private List<ElementTargetDependsOn> myProduct;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCodeSystem, this.myCode, this.myEquivalence, this.myComments, this.myDependsOn, this.myProduct});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCodeSystem, this.myCode, this.myEquivalence, this.myComments, this.myDependsOn, this.myProduct});
        }

        public UriDt getCodeSystemElement() {
            if (this.myCodeSystem == null) {
                this.myCodeSystem = new UriDt();
            }
            return this.myCodeSystem;
        }

        public String getCodeSystem() {
            return (String)this.getCodeSystemElement().getValue();
        }

        public ElementTarget setCodeSystem(UriDt theValue) {
            this.myCodeSystem = theValue;
            return this;
        }

        public ElementTarget setCodeSystem(String theUri) {
            this.myCodeSystem = new UriDt(theUri);
            return this;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public ElementTarget setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ElementTarget setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public BoundCodeDt<ConceptMapEquivalenceEnum> getEquivalenceElement() {
            if (this.myEquivalence == null) {
                this.myEquivalence = new BoundCodeDt(ConceptMapEquivalenceEnum.VALUESET_BINDER);
            }
            return this.myEquivalence;
        }

        public String getEquivalence() {
            return (String)this.getEquivalenceElement().getValue();
        }

        public ElementTarget setEquivalence(BoundCodeDt<ConceptMapEquivalenceEnum> theValue) {
            this.myEquivalence = theValue;
            return this;
        }

        public ElementTarget setEquivalence(ConceptMapEquivalenceEnum theValue) {
            this.setEquivalence((BoundCodeDt<ConceptMapEquivalenceEnum>)new BoundCodeDt(ConceptMapEquivalenceEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public StringDt getCommentsElement() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public String getComments() {
            return (String)this.getCommentsElement().getValue();
        }

        public ElementTarget setComments(StringDt theValue) {
            this.myComments = theValue;
            return this;
        }

        public ElementTarget setComments(String theString) {
            this.myComments = new StringDt(theString);
            return this;
        }

        public List<ElementTargetDependsOn> getDependsOn() {
            if (this.myDependsOn == null) {
                this.myDependsOn = new ArrayList<ElementTargetDependsOn>();
            }
            return this.myDependsOn;
        }

        public ElementTarget setDependsOn(List<ElementTargetDependsOn> theValue) {
            this.myDependsOn = theValue;
            return this;
        }

        public ElementTargetDependsOn addDependsOn() {
            ElementTargetDependsOn newType = new ElementTargetDependsOn();
            this.getDependsOn().add(newType);
            return newType;
        }

        public ElementTarget addDependsOn(ElementTargetDependsOn theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDependsOn().add(theValue);
            return this;
        }

        public ElementTargetDependsOn getDependsOnFirstRep() {
            if (this.getDependsOn().isEmpty()) {
                return this.addDependsOn();
            }
            return this.getDependsOn().get(0);
        }

        public List<ElementTargetDependsOn> getProduct() {
            if (this.myProduct == null) {
                this.myProduct = new ArrayList<ElementTargetDependsOn>();
            }
            return this.myProduct;
        }

        public ElementTarget setProduct(List<ElementTargetDependsOn> theValue) {
            this.myProduct = theValue;
            return this;
        }

        public ElementTargetDependsOn addProduct() {
            ElementTargetDependsOn newType = new ElementTargetDependsOn();
            this.getProduct().add(newType);
            return newType;
        }

        public ElementTarget addProduct(ElementTargetDependsOn theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getProduct().add(theValue);
            return this;
        }

        public ElementTargetDependsOn getProductFirstRep() {
            if (this.getProduct().isEmpty()) {
                return this.addProduct();
            }
            return this.getProduct().get(0);
        }
    }

    @Block
    public static class Element
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="codeSystem", type={UriDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI that identifies the Code System (if the source is a value set that crosses more than one code system)")
        private UriDt myCodeSystem;
        @Child(name="code", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identity (code or path) or the element/item being mapped")
        private CodeDt myCode;
        @Child(name="target", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A concept from the target value set that this concept maps to")
        private List<ElementTarget> myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCodeSystem, this.myCode, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCodeSystem, this.myCode, this.myTarget});
        }

        public UriDt getCodeSystemElement() {
            if (this.myCodeSystem == null) {
                this.myCodeSystem = new UriDt();
            }
            return this.myCodeSystem;
        }

        public String getCodeSystem() {
            return (String)this.getCodeSystemElement().getValue();
        }

        public Element setCodeSystem(UriDt theValue) {
            this.myCodeSystem = theValue;
            return this;
        }

        public Element setCodeSystem(String theUri) {
            this.myCodeSystem = new UriDt(theUri);
            return this;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public Element setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public Element setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public List<ElementTarget> getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<ElementTarget>();
            }
            return this.myTarget;
        }

        public Element setTarget(List<ElementTarget> theValue) {
            this.myTarget = theValue;
            return this;
        }

        public ElementTarget addTarget() {
            ElementTarget newType = new ElementTarget();
            this.getTarget().add(newType);
            return newType;
        }

        public Element addTarget(ElementTarget theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTarget().add(theValue);
            return this;
        }

        public ElementTarget getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                return this.addTarget();
            }
            return this.getTarget().get(0);
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the concept map")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }
}

