/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum UseEnum {
    COMPLETE("complete", "http://hl7.org/fhir/claim-use-link"),
    PROPOSED("proposed", "http://hl7.org/fhir/claim-use-link"),
    EXPLORATORY("exploratory", "http://hl7.org/fhir/claim-use-link"),
    OTHER("other", "http://hl7.org/fhir/claim-use-link");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Use";
    private static Map<String, UseEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, UseEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<UseEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static UseEnum forCode(String theCode) {
        UseEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private UseEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, UseEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, UseEnum>>();
        for (UseEnum next : UseEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<UseEnum>(){

            public String toCodeString(UseEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(UseEnum theEnum) {
                return theEnum.getSystem();
            }

            public UseEnum fromCodeString(String theCodeString) {
                return (UseEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public UseEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (UseEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

