/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.DocumentReferenceStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DocumentManifest", profile="http://hl7.org/fhir/profiles/DocumentManifest", id="documentmanifest")
public class DocumentManifest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="DocumentManifest.masterIdentifier | DocumentManifest.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="DocumentManifest.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="type", path="DocumentManifest.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="recipient", path="DocumentManifest.recipient", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    @SearchParamDefinition(name="author", path="DocumentManifest.author", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Encounter"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner")})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="created", path="DocumentManifest.created", description="", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="status", path="DocumentManifest.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="DocumentManifest.description", description="", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="content-ref", path="DocumentManifest.content.pReference", description="", type="reference")
    public static final String SP_CONTENT_REF = "content-ref";
    public static final ReferenceClientParam CONTENT_REF = new ReferenceClientParam("content-ref");
    @SearchParamDefinition(name="patient", path="DocumentManifest.subject", description="", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="source", path="DocumentManifest.source", description="", type="uri")
    public static final String SP_SOURCE = "source";
    public static final UriClientParam SOURCE = new UriClientParam("source");
    @SearchParamDefinition(name="related-id", path="DocumentManifest.related.identifier", description="", type="token")
    public static final String SP_RELATED_ID = "related-id";
    public static final TokenClientParam RELATED_ID = new TokenClientParam("related-id");
    @SearchParamDefinition(name="related-ref", path="DocumentManifest.related.ref", description="", type="reference")
    public static final String SP_RELATED_REF = "related-ref";
    public static final ReferenceClientParam RELATED_REF = new ReferenceClientParam("related-ref");
    public static final Include INCLUDE_AUTHOR = new Include("DocumentManifest:author");
    public static final Include INCLUDE_CONTENT_REF = new Include("DocumentManifest:content-ref");
    public static final Include INCLUDE_PATIENT = new Include("DocumentManifest:patient");
    public static final Include INCLUDE_RECIPIENT = new Include("DocumentManifest:recipient");
    public static final Include INCLUDE_RELATED_REF = new Include("DocumentManifest:related-ref");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentManifest:subject");
    @Child(name="masterIdentifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="A single identifier that uniquely identifies this manifest. Principally used to refer to the manifest in non-FHIR contexts")
    private IdentifierDt myMasterIdentifier;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Other identifiers associated with the document manifest, including version independent  identifiers")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class, Practitioner.class, Group.class, Device.class})
    @Description(shortDefinition="who.focus", formalDefinition="Who or what the set of documents is about. The documents can be about a person, (patient or healthcare practitioner), a device (i.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure). If the documents cross more than one subject, then more than one subject is allowed here (unusual use case)")
    private ResourceReferenceDt mySubject;
    @Child(name="recipient", order=3, min=0, max=-1, summary=false, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class, Organization.class})
    @Description(shortDefinition="who.cause", formalDefinition="A patient, practitioner, or organization for which this set of documents is intended")
    private List<ResourceReferenceDt> myRecipient;
    @Child(name="type", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Specifies the kind of this set of documents (e.g. Patient Summary, Discharge Summary, Prescription, etc.). The type of a set of documents may be the same as one of the documents in it - especially if there is only one - but it may be wider")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-doc-typecodes")
    private CodeableConceptDt myType;
    @Child(name="author", order=5, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class, Organization.class, Device.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="who.author", formalDefinition="Identifies who is responsible for creating the manifest, and adding  documents to it")
    private List<ResourceReferenceDt> myAuthor;
    @Child(name="created", type={DateTimeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="When the document manifest was created for submission to the server (not necessarily the same thing as the actual resource last modified time, since it may be modified, replicated, etc.)")
    private DateTimeDt myCreated;
    @Child(name="source", type={UriDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the source system, application, or software that produced the document manifest")
    private UriDt mySource;
    @Child(name="status", type={CodeDt.class}, order=8, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of this document manifest")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-reference-status")
    private BoundCodeDt<DocumentReferenceStatusEnum> myStatus;
    @Child(name="description", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Human-readable description of the source document. This is sometimes known as the \"title\"")
    private StringDt myDescription;
    @Child(name="content", order=10, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The list of Documents included in the manifest.")
    private List<Content> myContent;
    @Child(name="related", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Related identifiers or resources associated with the DocumentManifest.")
    private List<Related> myRelated;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myRecipient, this.myType, this.myAuthor, this.myCreated, this.mySource, this.myStatus, this.myDescription, this.myContent, this.myRelated});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myRecipient, this.myType, this.myAuthor, this.myCreated, this.mySource, this.myStatus, this.myDescription, this.myContent, this.myRelated});
    }

    public IdentifierDt getMasterIdentifier() {
        if (this.myMasterIdentifier == null) {
            this.myMasterIdentifier = new IdentifierDt();
        }
        return this.myMasterIdentifier;
    }

    public DocumentManifest setMasterIdentifier(IdentifierDt theValue) {
        this.myMasterIdentifier = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DocumentManifest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public DocumentManifest addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DocumentManifest setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getRecipient() {
        if (this.myRecipient == null) {
            this.myRecipient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRecipient;
    }

    public DocumentManifest setRecipient(List<ResourceReferenceDt> theValue) {
        this.myRecipient = theValue;
        return this;
    }

    public ResourceReferenceDt addRecipient() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getRecipient().add(newType);
        return newType;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public DocumentManifest setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public DocumentManifest setAuthor(List<ResourceReferenceDt> theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthor() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthor().add(newType);
        return newType;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public DocumentManifest setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public DocumentManifest setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DocumentManifest setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public UriDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new UriDt();
        }
        return this.mySource;
    }

    public String getSource() {
        return (String)this.getSourceElement().getValue();
    }

    public DocumentManifest setSource(UriDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public DocumentManifest setSource(String theUri) {
        this.mySource = new UriDt(theUri);
        return this;
    }

    public BoundCodeDt<DocumentReferenceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public DocumentManifest setStatus(BoundCodeDt<DocumentReferenceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DocumentManifest setStatus(DocumentReferenceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<DocumentReferenceStatusEnum>)new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public DocumentManifest setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public DocumentManifest setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<Content> getContent() {
        if (this.myContent == null) {
            this.myContent = new ArrayList<Content>();
        }
        return this.myContent;
    }

    public DocumentManifest setContent(List<Content> theValue) {
        this.myContent = theValue;
        return this;
    }

    public Content addContent() {
        Content newType = new Content();
        this.getContent().add(newType);
        return newType;
    }

    public DocumentManifest addContent(Content theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContent().add(theValue);
        return this;
    }

    public Content getContentFirstRep() {
        if (this.getContent().isEmpty()) {
            return this.addContent();
        }
        return this.getContent().get(0);
    }

    public List<Related> getRelated() {
        if (this.myRelated == null) {
            this.myRelated = new ArrayList<Related>();
        }
        return this.myRelated;
    }

    public DocumentManifest setRelated(List<Related> theValue) {
        this.myRelated = theValue;
        return this;
    }

    public Related addRelated() {
        Related newType = new Related();
        this.getRelated().add(newType);
        return newType;
    }

    public DocumentManifest addRelated(Related theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getRelated().add(theValue);
        return this;
    }

    public Related getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            return this.addRelated();
        }
        return this.getRelated().get(0);
    }

    public String getResourceName() {
        return "DocumentManifest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Related
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Related identifier to this DocumentManifest.  For example, Order numbers, accession numbers, XDW workflow numbers.")
        private IdentifierDt myIdentifier;
        @Child(name="ref", order=1, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="Related Resource to this DocumentManifest. For example, Order, DiagnosticOrder,  Procedure, EligibilityRequest, etc.")
        private ResourceReferenceDt myRef;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myRef});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRef});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Related setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public ResourceReferenceDt getRef() {
            if (this.myRef == null) {
                this.myRef = new ResourceReferenceDt();
            }
            return this.myRef;
        }

        public Related setRef(ResourceReferenceDt theValue) {
            this.myRef = theValue;
            return this;
        }
    }

    @Block
    public static class Content
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="p", order=0, min=1, max=1, summary=false, modifier=false, type={AttachmentDt.class, IResource.class})
        @Description(shortDefinition="", formalDefinition="The list of references to document content, or Attachment that consist of the parts of this document manifest. Usually, these would be document references, but direct references to Media or Attachments are also allowed")
        private IDatatype myP;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myP});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myP});
        }

        public IDatatype getP() {
            return this.myP;
        }

        public Content setP(IDatatype theValue) {
            this.myP = theValue;
            return this;
        }
    }
}

