/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum DigitalMediaTypeEnum {
    PHOTO("photo", "http://hl7.org/fhir/digital-media-type"),
    VIDEO("video", "http://hl7.org/fhir/digital-media-type"),
    AUDIO("audio", "http://hl7.org/fhir/digital-media-type");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "DigitalMediaType";
    private static Map<String, DigitalMediaTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, DigitalMediaTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<DigitalMediaTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static DigitalMediaTypeEnum forCode(String theCode) {
        DigitalMediaTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private DigitalMediaTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, DigitalMediaTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, DigitalMediaTypeEnum>>();
        for (DigitalMediaTypeEnum next : DigitalMediaTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<DigitalMediaTypeEnum>(){

            public String toCodeString(DigitalMediaTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(DigitalMediaTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public DigitalMediaTypeEnum fromCodeString(String theCodeString) {
                return (DigitalMediaTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public DigitalMediaTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (DigitalMediaTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

