/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ReferralMethodEnum {
    FAX("fax", "http://hl7.org/fhir/service-referral-method"),
    PHONE("phone", "http://hl7.org/fhir/service-referral-method"),
    SECURE_MESSAGING("elec", "http://hl7.org/fhir/service-referral-method"),
    SECURE_EMAIL("semail", "http://hl7.org/fhir/service-referral-method"),
    MAIL("mail", "http://hl7.org/fhir/service-referral-method");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "ReferralMethod";
    private static Map<String, ReferralMethodEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ReferralMethodEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ReferralMethodEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ReferralMethodEnum forCode(String theCode) {
        ReferralMethodEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ReferralMethodEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ReferralMethodEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ReferralMethodEnum>>();
        for (ReferralMethodEnum next : ReferralMethodEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ReferralMethodEnum>(){

            public String toCodeString(ReferralMethodEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ReferralMethodEnum theEnum) {
                return theEnum.getSystem();
            }

            public ReferralMethodEnum fromCodeString(String theCodeString) {
                return (ReferralMethodEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ReferralMethodEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ReferralMethodEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

