/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum XPathUsageTypeEnum {
    NORMAL("normal", "http://hl7.org/fhir/search-xpath-usage"),
    PHONETIC("phonetic", "http://hl7.org/fhir/search-xpath-usage"),
    NEARBY("nearby", "http://hl7.org/fhir/search-xpath-usage"),
    DISTANCE("distance", "http://hl7.org/fhir/search-xpath-usage"),
    OTHER("other", "http://hl7.org/fhir/search-xpath-usage");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "XPathUsageType";
    private static Map<String, XPathUsageTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, XPathUsageTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<XPathUsageTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static XPathUsageTypeEnum forCode(String theCode) {
        XPathUsageTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private XPathUsageTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, XPathUsageTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, XPathUsageTypeEnum>>();
        for (XPathUsageTypeEnum next : XPathUsageTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<XPathUsageTypeEnum>(){

            public String toCodeString(XPathUsageTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(XPathUsageTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public XPathUsageTypeEnum fromCodeString(String theCodeString) {
                return (XPathUsageTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public XPathUsageTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (XPathUsageTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

