/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AgeDt;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.valueset.AdministrativeGenderEnum;
import ca.uhn.fhir.model.dstu2.valueset.FamilyHistoryStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="FamilyMemberHistory", profile="http://hl7.org/fhir/profiles/FamilyMemberHistory", id="familymemberhistory")
public class FamilyMemberHistory
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="date", path="FamilyMemberHistory.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="patient", path="FamilyMemberHistory.patient", description="The identity of a subject to list family member history items for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="code", path="FamilyMemberHistory.condition.code", description="A search by a condition code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="FamilyMemberHistory.identifier", description="A search by a record identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="relationship", path="FamilyMemberHistory.relationship", description="A search by a relationship type", type="token")
    public static final String SP_RELATIONSHIP = "relationship";
    public static final TokenClientParam RELATIONSHIP = new TokenClientParam("relationship");
    @SearchParamDefinition(name="gender", path="FamilyMemberHistory.gender", description="A search by a gender code of a family member", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    public static final Include INCLUDE_PATIENT = new Include("FamilyMemberHistory:patient");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="This records identifiers associated with this family member history record that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="patient", order=1, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The person who this history concerns")
    private ResourceReferenceDt myPatient;
    @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date (and possibly time) when the family member history was taken")
    private DateTimeDt myDate;
    @Child(name="status", type={CodeDt.class}, order=3, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="A code specifying a state of a Family Member History record.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/history-status")
    private BoundCodeDt<FamilyHistoryStatusEnum> myStatus;
    @Child(name="name", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\"")
    private StringDt myName;
    @Child(name="relationship", type={CodeableConceptDt.class}, order=5, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of relationship this person has to the patient (father, mother, brother etc.)")
    private CodeableConceptDt myRelationship;
    @Child(name="gender", type={CodeDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Administrative Gender - the gender that the relative is considered to have for administration and record keeping purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    private BoundCodeDt<AdministrativeGenderEnum> myGender;
    @Child(name="born", order=7, min=0, max=1, summary=false, modifier=false, type={PeriodDt.class, DateDt.class, StringDt.class})
    @Description(shortDefinition="", formalDefinition="The actual or approximate date of birth of the relative")
    private IDatatype myBorn;
    @Child(name="age", order=8, min=0, max=1, summary=false, modifier=false, type={AgeDt.class, RangeDt.class, StringDt.class})
    @Description(shortDefinition="", formalDefinition="The actual or approximate age of the relative at the time the family member history is recorded")
    private IDatatype myAge;
    @Child(name="deceased", order=9, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, AgeDt.class, RangeDt.class, DateDt.class, StringDt.class})
    @Description(shortDefinition="", formalDefinition="Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record")
    private IDatatype myDeceased;
    @Child(name="note", type={AnnotationDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.")
    private AnnotationDt myNote;
    @Child(name="condition", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.")
    private List<Condition> myCondition;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPatient, this.myDate, this.myStatus, this.myName, this.myRelationship, this.myGender, this.myBorn, this.myAge, this.myDeceased, this.myNote, this.myCondition});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPatient, this.myDate, this.myStatus, this.myName, this.myRelationship, this.myGender, this.myBorn, this.myAge, this.myDeceased, this.myNote, this.myCondition});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public FamilyMemberHistory setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public FamilyMemberHistory addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public FamilyMemberHistory setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public FamilyMemberHistory setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public FamilyMemberHistory setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public FamilyMemberHistory setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public BoundCodeDt<FamilyHistoryStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(FamilyHistoryStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public FamilyMemberHistory setStatus(BoundCodeDt<FamilyHistoryStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public FamilyMemberHistory setStatus(FamilyHistoryStatusEnum theValue) {
        this.setStatus((BoundCodeDt<FamilyHistoryStatusEnum>)new BoundCodeDt(FamilyHistoryStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public FamilyMemberHistory setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public FamilyMemberHistory setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public CodeableConceptDt getRelationship() {
        if (this.myRelationship == null) {
            this.myRelationship = new CodeableConceptDt();
        }
        return this.myRelationship;
    }

    public FamilyMemberHistory setRelationship(CodeableConceptDt theValue) {
        this.myRelationship = theValue;
        return this;
    }

    public BoundCodeDt<AdministrativeGenderEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public String getGender() {
        return (String)this.getGenderElement().getValue();
    }

    public FamilyMemberHistory setGender(BoundCodeDt<AdministrativeGenderEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public FamilyMemberHistory setGender(AdministrativeGenderEnum theValue) {
        this.setGender((BoundCodeDt<AdministrativeGenderEnum>)new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public IDatatype getBorn() {
        return this.myBorn;
    }

    public FamilyMemberHistory setBorn(IDatatype theValue) {
        this.myBorn = theValue;
        return this;
    }

    public IDatatype getAge() {
        return this.myAge;
    }

    public FamilyMemberHistory setAge(IDatatype theValue) {
        this.myAge = theValue;
        return this;
    }

    public IDatatype getDeceased() {
        return this.myDeceased;
    }

    public FamilyMemberHistory setDeceased(IDatatype theValue) {
        this.myDeceased = theValue;
        return this;
    }

    public AnnotationDt getNote() {
        if (this.myNote == null) {
            this.myNote = new AnnotationDt();
        }
        return this.myNote;
    }

    public FamilyMemberHistory setNote(AnnotationDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public List<Condition> getCondition() {
        if (this.myCondition == null) {
            this.myCondition = new ArrayList<Condition>();
        }
        return this.myCondition;
    }

    public FamilyMemberHistory setCondition(List<Condition> theValue) {
        this.myCondition = theValue;
        return this;
    }

    public Condition addCondition() {
        Condition newType = new Condition();
        this.getCondition().add(newType);
        return newType;
    }

    public FamilyMemberHistory addCondition(Condition theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCondition().add(theValue);
        return this;
    }

    public Condition getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            return this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public String getResourceName() {
        return "FamilyMemberHistory";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Condition
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system")
        private CodeableConceptDt myCode;
        @Child(name="outcome", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates what happened as a result of this condition.  If the condition resulted in death, deceased date is captured on the relation.")
        private CodeableConceptDt myOutcome;
        @Child(name="onset", order=2, min=0, max=1, summary=false, modifier=false, type={AgeDt.class, RangeDt.class, PeriodDt.class, StringDt.class})
        @Description(shortDefinition="", formalDefinition="Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.")
        private IDatatype myOnset;
        @Child(name="note", type={AnnotationDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An area where general notes can be placed about this specific condition.")
        private AnnotationDt myNote;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myOutcome, this.myOnset, this.myNote});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myOutcome, this.myOnset, this.myNote});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Condition setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public CodeableConceptDt getOutcome() {
            if (this.myOutcome == null) {
                this.myOutcome = new CodeableConceptDt();
            }
            return this.myOutcome;
        }

        public Condition setOutcome(CodeableConceptDt theValue) {
            this.myOutcome = theValue;
            return this;
        }

        public IDatatype getOnset() {
            return this.myOnset;
        }

        public Condition setOnset(IDatatype theValue) {
            this.myOnset = theValue;
            return this;
        }

        public AnnotationDt getNote() {
            if (this.myNote == null) {
                this.myNote = new AnnotationDt();
            }
            return this.myNote;
        }

        public Condition setNote(AnnotationDt theValue) {
            this.myNote = theValue;
            return this;
        }
    }
}

