/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.DurationDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.MedicationStatement;
import ca.uhn.fhir.model.dstu2.resource.NutritionOrder;
import ca.uhn.fhir.model.dstu2.resource.Observation;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.ProcedureRequest;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.resource.RiskAssessment;
import ca.uhn.fhir.model.dstu2.valueset.GoalPriorityEnum;
import ca.uhn.fhir.model.dstu2.valueset.GoalStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Goal", profile="http://hl7.org/fhir/profiles/Goal", id="goal")
public class Goal
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="Goal.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="subject", path="Goal.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="category", path="Goal.category", description="", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="targetdate", path="Goal.targetDate", description="", type="date")
    public static final String SP_TARGETDATE = "targetdate";
    public static final DateClientParam TARGETDATE = new DateClientParam("targetdate");
    @SearchParamDefinition(name="identifier", path="Goal.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="Goal.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    public static final Include INCLUDE_PATIENT = new Include("Goal:patient");
    public static final Include INCLUDE_SUBJECT = new Include("Goal:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=0, max=1, summary=true, modifier=false, type={Patient.class, Group.class, Organization.class})
    @Description(shortDefinition="who.focus", formalDefinition="Identifies the patient, group or organization for whom the goal is being established.")
    private ResourceReferenceDt mySubject;
    @Child(name="start", order=2, min=0, max=1, summary=true, modifier=false, type={DateDt.class, CodeableConceptDt.class})
    @Description(shortDefinition="", formalDefinition="The date or event after which the goal should begin being pursued")
    private IDatatype myStart;
    @Child(name="target", order=3, min=0, max=1, summary=true, modifier=false, type={DateDt.class, DurationDt.class})
    @Description(shortDefinition="", formalDefinition="Indicates either the date or the duration after start by which the goal should be met")
    private IDatatype myTarget;
    @Child(name="category", type={CodeableConceptDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates a category the goal falls within")
    private List<CodeableConceptDt> myCategory;
    @Child(name="description", type={StringDt.class}, order=5, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Human-readable description of a specific desired objective of care.")
    private StringDt myDescription;
    @Child(name="status", type={CodeDt.class}, order=6, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Indicates whether the goal has been reached and is still considered relevant")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-status")
    private BoundCodeDt<GoalStatusEnum> myStatus;
    @Child(name="statusDate", type={DateDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="Identifies when the current status.  I.e. When initially created, when achieved, when cancelled, etc.")
    private DateDt myStatusDate;
    @Child(name="statusReason", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Captures the reason for the current status.")
    private CodeableConceptDt myStatusReason;
    @Child(name="author", order=9, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class})
    @Description(shortDefinition="who.actor", formalDefinition="Indicates whose goal this is - patient goal, practitioner goal, etc.")
    private ResourceReferenceDt myAuthor;
    @Child(name="priority", type={CodeableConceptDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the mutually agreed level of importance associated with reaching/sustaining the goal")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-goal-priority")
    private BoundCodeableConceptDt<GoalPriorityEnum> myPriority;
    @Child(name="addresses", order=11, min=0, max=-1, summary=false, modifier=false, type={Condition.class, Observation.class, MedicationStatement.class, NutritionOrder.class, ProcedureRequest.class, RiskAssessment.class})
    @Description(shortDefinition="", formalDefinition="The identified conditions and other health record elements that are intended to be addressed by the goal")
    private List<ResourceReferenceDt> myAddresses;
    @Child(name="note", type={AnnotationDt.class}, order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Any comments related to the goal")
    private List<AnnotationDt> myNote;
    @Child(name="outcome", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the change (or lack of change) at the point where the goal was deepmed to be cancelled or achieved.")
    private List<Outcome> myOutcome;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myStart, this.myTarget, this.myCategory, this.myDescription, this.myStatus, this.myStatusDate, this.myStatusReason, this.myAuthor, this.myPriority, this.myAddresses, this.myNote, this.myOutcome});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myStart, this.myTarget, this.myCategory, this.myDescription, this.myStatus, this.myStatusDate, this.myStatusReason, this.myAuthor, this.myPriority, this.myAddresses, this.myNote, this.myOutcome});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Goal setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Goal addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Goal setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public IDatatype getStart() {
        return this.myStart;
    }

    public Goal setStart(IDatatype theValue) {
        this.myStart = theValue;
        return this;
    }

    public IDatatype getTarget() {
        return this.myTarget;
    }

    public Goal setTarget(IDatatype theValue) {
        this.myTarget = theValue;
        return this;
    }

    public List<CodeableConceptDt> getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new ArrayList<CodeableConceptDt>();
        }
        return this.myCategory;
    }

    public Goal setCategory(List<CodeableConceptDt> theValue) {
        this.myCategory = theValue;
        return this;
    }

    public CodeableConceptDt addCategory() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCategory().add(newType);
        return newType;
    }

    public Goal addCategory(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCategory().add(theValue);
        return this;
    }

    public CodeableConceptDt getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            return this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public Goal setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Goal setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<GoalStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(GoalStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Goal setStatus(BoundCodeDt<GoalStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Goal setStatus(GoalStatusEnum theValue) {
        this.setStatus((BoundCodeDt<GoalStatusEnum>)new BoundCodeDt(GoalStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public DateDt getStatusDateElement() {
        if (this.myStatusDate == null) {
            this.myStatusDate = new DateDt();
        }
        return this.myStatusDate;
    }

    public Date getStatusDate() {
        return (Date)this.getStatusDateElement().getValue();
    }

    public Goal setStatusDate(DateDt theValue) {
        this.myStatusDate = theValue;
        return this;
    }

    public Goal setStatusDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStatusDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Goal setStatusDateWithDayPrecision(Date theDate) {
        this.myStatusDate = new DateDt(theDate);
        return this;
    }

    public CodeableConceptDt getStatusReason() {
        if (this.myStatusReason == null) {
            this.myStatusReason = new CodeableConceptDt();
        }
        return this.myStatusReason;
    }

    public Goal setStatusReason(CodeableConceptDt theValue) {
        this.myStatusReason = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Goal setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public BoundCodeableConceptDt<GoalPriorityEnum> getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new BoundCodeableConceptDt<GoalPriorityEnum>(GoalPriorityEnum.VALUESET_BINDER);
        }
        return this.myPriority;
    }

    public Goal setPriority(BoundCodeableConceptDt<GoalPriorityEnum> theValue) {
        this.myPriority = theValue;
        return this;
    }

    public Goal setPriority(GoalPriorityEnum theValue) {
        this.setPriority(new BoundCodeableConceptDt<GoalPriorityEnum>(GoalPriorityEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public List<ResourceReferenceDt> getAddresses() {
        if (this.myAddresses == null) {
            this.myAddresses = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAddresses;
    }

    public Goal setAddresses(List<ResourceReferenceDt> theValue) {
        this.myAddresses = theValue;
        return this;
    }

    public ResourceReferenceDt addAddresses() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAddresses().add(newType);
        return newType;
    }

    public List<AnnotationDt> getNote() {
        if (this.myNote == null) {
            this.myNote = new ArrayList<AnnotationDt>();
        }
        return this.myNote;
    }

    public Goal setNote(List<AnnotationDt> theValue) {
        this.myNote = theValue;
        return this;
    }

    public AnnotationDt addNote() {
        AnnotationDt newType = new AnnotationDt();
        this.getNote().add(newType);
        return newType;
    }

    public Goal addNote(AnnotationDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNote().add(theValue);
        return this;
    }

    public AnnotationDt getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            return this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Outcome> getOutcome() {
        if (this.myOutcome == null) {
            this.myOutcome = new ArrayList<Outcome>();
        }
        return this.myOutcome;
    }

    public Goal setOutcome(List<Outcome> theValue) {
        this.myOutcome = theValue;
        return this;
    }

    public Outcome addOutcome() {
        Outcome newType = new Outcome();
        this.getOutcome().add(newType);
        return newType;
    }

    public Goal addOutcome(Outcome theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getOutcome().add(theValue);
        return this;
    }

    public Outcome getOutcomeFirstRep() {
        if (this.getOutcome().isEmpty()) {
            return this.addOutcome();
        }
        return this.getOutcome().get(0);
    }

    public String getResourceName() {
        return "Goal";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Outcome
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="result", order=0, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Observation.class})
        @Description(shortDefinition="", formalDefinition="Details of what's changed (or not changed)")
        private IDatatype myResult;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myResult});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myResult});
        }

        public IDatatype getResult() {
            return this.myResult;
        }

        public Outcome setResult(IDatatype theValue) {
            this.myResult = theValue;
            return this;
        }
    }
}

