/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.ListModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.ListOrderCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.ListStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="List", profile="http://hl7.org/fhir/profiles/List", id="list")
public class ListResource
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="source", path="List.source", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Encounter"), @Compartment(name="RelatedPerson")})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    @SearchParamDefinition(name="item", path="List.entry.item", description="", type="reference")
    public static final String SP_ITEM = "item";
    public static final ReferenceClientParam ITEM = new ReferenceClientParam("item");
    @SearchParamDefinition(name="empty-reason", path="List.emptyReason", description="", type="token")
    public static final String SP_EMPTY_REASON = "empty-reason";
    public static final TokenClientParam EMPTY_REASON = new TokenClientParam("empty-reason");
    @SearchParamDefinition(name="date", path="List.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="code", path="List.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="subject", path="List.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="List.subject", description="", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="status", path="List.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="List.title", description="", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="notes", path="List.note", description="", type="string")
    public static final String SP_NOTES = "notes";
    public static final StringClientParam NOTES = new StringClientParam("notes");
    @SearchParamDefinition(name="encounter", path="List.encounter", description="", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("List:encounter");
    public static final Include INCLUDE_ITEM = new Include("List:item");
    public static final Include INCLUDE_PATIENT = new Include("List:patient");
    public static final Include INCLUDE_SOURCE = new Include("List:source");
    public static final Include INCLUDE_SUBJECT = new Include("List:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifier for the List assigned for business purposes outside the context of FHIR.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="title", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A label for the list assigned by the author")
    private StringDt myTitle;
    @Child(name="code", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="what", formalDefinition="This code defines the purpose of the list - why it was created")
    private CodeableConceptDt myCode;
    @Child(name="subject", order=3, min=0, max=1, summary=true, modifier=false, type={Patient.class, Group.class, Device.class, Location.class})
    @Description(shortDefinition="who.focus", formalDefinition="The common subject (or patient) of the resources that are in the list, if there is one")
    private ResourceReferenceDt mySubject;
    @Child(name="source", order=4, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Patient.class, Device.class})
    @Description(shortDefinition="who.author", formalDefinition="The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list")
    private ResourceReferenceDt mySource;
    @Child(name="encounter", order=5, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The encounter that is the context in which this list was created")
    private ResourceReferenceDt myEncounter;
    @Child(name="status", type={CodeDt.class}, order=6, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Indicates the current state of this list")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-status")
    private BoundCodeDt<ListStatusEnum> myStatus;
    @Child(name="date", type={DateTimeDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date that the list was prepared")
    private DateTimeDt myDate;
    @Child(name="orderedBy", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="What order applies to the items in the list")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-list-order")
    private BoundCodeableConceptDt<ListOrderCodesEnum> myOrderedBy;
    @Child(name="mode", type={CodeDt.class}, order=9, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="class", formalDefinition="How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-mode")
    private BoundCodeDt<ListModeEnum> myMode;
    @Child(name="note", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Comments that apply to the overall list")
    private StringDt myNote;
    @Child(name="entry", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Entries in this list")
    private List<Entry> myEntry;
    @Child(name="emptyReason", type={CodeableConceptDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="If the list is empty, why the list is empty")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-list-empty-reason")
    private CodeableConceptDt myEmptyReason;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myTitle, this.myCode, this.mySubject, this.mySource, this.myEncounter, this.myStatus, this.myDate, this.myOrderedBy, this.myMode, this.myNote, this.myEntry, this.myEmptyReason});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myTitle, this.myCode, this.mySubject, this.mySource, this.myEncounter, this.myStatus, this.myDate, this.myOrderedBy, this.myMode, this.myNote, this.myEntry, this.myEmptyReason});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ListResource setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public ListResource addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringDt getTitleElement() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public String getTitle() {
        return (String)this.getTitleElement().getValue();
    }

    public ListResource setTitle(StringDt theValue) {
        this.myTitle = theValue;
        return this;
    }

    public ListResource setTitle(String theString) {
        this.myTitle = new StringDt(theString);
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public ListResource setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ListResource setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ListResource setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ListResource setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public BoundCodeDt<ListStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ListStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public ListResource setStatus(BoundCodeDt<ListStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ListResource setStatus(ListStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ListStatusEnum>)new BoundCodeDt(ListStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public ListResource setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ListResource setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ListResource setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public BoundCodeableConceptDt<ListOrderCodesEnum> getOrderedBy() {
        if (this.myOrderedBy == null) {
            this.myOrderedBy = new BoundCodeableConceptDt<ListOrderCodesEnum>(ListOrderCodesEnum.VALUESET_BINDER);
        }
        return this.myOrderedBy;
    }

    public ListResource setOrderedBy(BoundCodeableConceptDt<ListOrderCodesEnum> theValue) {
        this.myOrderedBy = theValue;
        return this;
    }

    public ListResource setOrderedBy(ListOrderCodesEnum theValue) {
        this.setOrderedBy(new BoundCodeableConceptDt<ListOrderCodesEnum>(ListOrderCodesEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public BoundCodeDt<ListModeEnum> getModeElement() {
        if (this.myMode == null) {
            this.myMode = new BoundCodeDt(ListModeEnum.VALUESET_BINDER);
        }
        return this.myMode;
    }

    public String getMode() {
        return (String)this.getModeElement().getValue();
    }

    public ListResource setMode(BoundCodeDt<ListModeEnum> theValue) {
        this.myMode = theValue;
        return this;
    }

    public ListResource setMode(ListModeEnum theValue) {
        this.setMode((BoundCodeDt<ListModeEnum>)new BoundCodeDt(ListModeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getNoteElement() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public String getNote() {
        return (String)this.getNoteElement().getValue();
    }

    public ListResource setNote(StringDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public ListResource setNote(String theString) {
        this.myNote = new StringDt(theString);
        return this;
    }

    public List<Entry> getEntry() {
        if (this.myEntry == null) {
            this.myEntry = new ArrayList<Entry>();
        }
        return this.myEntry;
    }

    public ListResource setEntry(List<Entry> theValue) {
        this.myEntry = theValue;
        return this;
    }

    public Entry addEntry() {
        Entry newType = new Entry();
        this.getEntry().add(newType);
        return newType;
    }

    public ListResource addEntry(Entry theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getEntry().add(theValue);
        return this;
    }

    public Entry getEntryFirstRep() {
        if (this.getEntry().isEmpty()) {
            return this.addEntry();
        }
        return this.getEntry().get(0);
    }

    public CodeableConceptDt getEmptyReason() {
        if (this.myEmptyReason == null) {
            this.myEmptyReason = new CodeableConceptDt();
        }
        return this.myEmptyReason;
    }

    public ListResource setEmptyReason(CodeableConceptDt theValue) {
        this.myEmptyReason = theValue;
        return this;
    }

    public String getResourceName() {
        return "List";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Entry
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="flag", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The flag allows the system constructing the list to indicate the role and significance of the item in the list")
        private CodeableConceptDt myFlag;
        @Child(name="deleted", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
        @Description(shortDefinition="", formalDefinition="True if this item is marked as deleted in the list.")
        private BooleanDt myDeleted;
        @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="When this item was added to the list")
        private DateTimeDt myDate;
        @Child(name="item", order=3, min=1, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="A reference to the actual resource from which data was derived")
        private ResourceReferenceDt myItem;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myFlag, this.myDeleted, this.myDate, this.myItem});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myFlag, this.myDeleted, this.myDate, this.myItem});
        }

        public CodeableConceptDt getFlag() {
            if (this.myFlag == null) {
                this.myFlag = new CodeableConceptDt();
            }
            return this.myFlag;
        }

        public Entry setFlag(CodeableConceptDt theValue) {
            this.myFlag = theValue;
            return this;
        }

        public BooleanDt getDeletedElement() {
            if (this.myDeleted == null) {
                this.myDeleted = new BooleanDt();
            }
            return this.myDeleted;
        }

        public Boolean getDeleted() {
            return (Boolean)this.getDeletedElement().getValue();
        }

        public Entry setDeleted(BooleanDt theValue) {
            this.myDeleted = theValue;
            return this;
        }

        public Entry setDeleted(boolean theBoolean) {
            this.myDeleted = new BooleanDt(theBoolean);
            return this;
        }

        public DateTimeDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public Date getDate() {
            return (Date)this.getDateElement().getValue();
        }

        public Entry setDate(DateTimeDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Entry setDateWithSecondsPrecision(Date theDate) {
            this.myDate = new DateTimeDt(theDate);
            return this;
        }

        public Entry setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public ResourceReferenceDt getItem() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public Entry setItem(ResourceReferenceDt theValue) {
            this.myItem = theValue;
            return this;
        }
    }
}

