/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.dstu2.valueset.SpecimenStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Specimen", profile="http://hl7.org/fhir/profiles/Specimen", id="specimen")
public class Specimen
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="Specimen.subject", description="The subject of the specimen", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="Specimen.subject", description="The patient the specimen comes from", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="identifier", path="Specimen.identifier", description="The unique identifier associated with the specimen", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="type", path="Specimen.type", description="The specimen type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="parent", path="Specimen.parent", description="The parent of the specimen", type="reference")
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    @SearchParamDefinition(name="accession", path="Specimen.accessionIdentifier", description="The accession number associated with the specimen", type="token")
    public static final String SP_ACCESSION = "accession";
    public static final TokenClientParam ACCESSION = new TokenClientParam("accession");
    @SearchParamDefinition(name="collected", path="Specimen.collection.collected[x]", description="The date the specimen was collected", type="date")
    public static final String SP_COLLECTED = "collected";
    public static final DateClientParam COLLECTED = new DateClientParam("collected");
    @SearchParamDefinition(name="collector", path="Specimen.collection.collector", description="Who collected the specimen", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_COLLECTOR = "collector";
    public static final ReferenceClientParam COLLECTOR = new ReferenceClientParam("collector");
    @SearchParamDefinition(name="bodysite", path="Specimen.collection.bodySite", description="The code for the body site from where the specimen originated", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="container-id", path="Specimen.container.identifier", description="The unique identifier associated with the specimen container", type="token")
    public static final String SP_CONTAINER_ID = "container-id";
    public static final TokenClientParam CONTAINER_ID = new TokenClientParam("container-id");
    @SearchParamDefinition(name="container", path="Specimen.container.type", description="The kind of specimen container", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    public static final Include INCLUDE_COLLECTOR = new Include("Specimen:collector");
    public static final Include INCLUDE_PARENT = new Include("Specimen:parent");
    public static final Include INCLUDE_PATIENT = new Include("Specimen:patient");
    public static final Include INCLUDE_SUBJECT = new Include("Specimen:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Id for specimen")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The availability of the specimen")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-status")
    private BoundCodeDt<SpecimenStatusEnum> myStatus;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="The kind of material that forms the specimen")
    private CodeableConceptDt myType;
    @Child(name="parent", order=3, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
    @Description(shortDefinition="", formalDefinition="Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.")
    private List<ResourceReferenceDt> myParent;
    @Child(name="subject", order=4, min=1, max=1, summary=true, modifier=false, type={Patient.class, Group.class, Device.class, Substance.class})
    @Description(shortDefinition="who.focus", formalDefinition="")
    private ResourceReferenceDt mySubject;
    @Child(name="accessionIdentifier", type={IdentifierDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.")
    private IdentifierDt myAccessionIdentifier;
    @Child(name="receivedTime", type={DateTimeDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="Time when specimen was received for processing or testing")
    private DateTimeDt myReceivedTime;
    @Child(name="collection", order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Details concerning the specimen collection")
    private Collection myCollection;
    @Child(name="treatment", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Details concerning treatment and processing steps for the specimen")
    private List<Treatment> myTreatment;
    @Child(name="container", order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.")
    private List<Container> myContainer;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myParent, this.mySubject, this.myAccessionIdentifier, this.myReceivedTime, this.myCollection, this.myTreatment, this.myContainer});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myParent, this.mySubject, this.myAccessionIdentifier, this.myReceivedTime, this.myCollection, this.myTreatment, this.myContainer});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Specimen setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Specimen addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<SpecimenStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SpecimenStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Specimen setStatus(BoundCodeDt<SpecimenStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Specimen setStatus(SpecimenStatusEnum theValue) {
        this.setStatus((BoundCodeDt<SpecimenStatusEnum>)new BoundCodeDt(SpecimenStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Specimen setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getParent() {
        if (this.myParent == null) {
            this.myParent = new ArrayList<ResourceReferenceDt>();
        }
        return this.myParent;
    }

    public Specimen setParent(List<ResourceReferenceDt> theValue) {
        this.myParent = theValue;
        return this;
    }

    public ResourceReferenceDt addParent() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getParent().add(newType);
        return newType;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Specimen setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public IdentifierDt getAccessionIdentifier() {
        if (this.myAccessionIdentifier == null) {
            this.myAccessionIdentifier = new IdentifierDt();
        }
        return this.myAccessionIdentifier;
    }

    public Specimen setAccessionIdentifier(IdentifierDt theValue) {
        this.myAccessionIdentifier = theValue;
        return this;
    }

    public DateTimeDt getReceivedTimeElement() {
        if (this.myReceivedTime == null) {
            this.myReceivedTime = new DateTimeDt();
        }
        return this.myReceivedTime;
    }

    public Date getReceivedTime() {
        return (Date)this.getReceivedTimeElement().getValue();
    }

    public Specimen setReceivedTime(DateTimeDt theValue) {
        this.myReceivedTime = theValue;
        return this;
    }

    public Specimen setReceivedTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myReceivedTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Specimen setReceivedTimeWithSecondsPrecision(Date theDate) {
        this.myReceivedTime = new DateTimeDt(theDate);
        return this;
    }

    public Collection getCollection() {
        if (this.myCollection == null) {
            this.myCollection = new Collection();
        }
        return this.myCollection;
    }

    public Specimen setCollection(Collection theValue) {
        this.myCollection = theValue;
        return this;
    }

    public List<Treatment> getTreatment() {
        if (this.myTreatment == null) {
            this.myTreatment = new ArrayList<Treatment>();
        }
        return this.myTreatment;
    }

    public Specimen setTreatment(List<Treatment> theValue) {
        this.myTreatment = theValue;
        return this;
    }

    public Treatment addTreatment() {
        Treatment newType = new Treatment();
        this.getTreatment().add(newType);
        return newType;
    }

    public Specimen addTreatment(Treatment theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTreatment().add(theValue);
        return this;
    }

    public Treatment getTreatmentFirstRep() {
        if (this.getTreatment().isEmpty()) {
            return this.addTreatment();
        }
        return this.getTreatment().get(0);
    }

    public List<Container> getContainer() {
        if (this.myContainer == null) {
            this.myContainer = new ArrayList<Container>();
        }
        return this.myContainer;
    }

    public Specimen setContainer(List<Container> theValue) {
        this.myContainer = theValue;
        return this;
    }

    public Container addContainer() {
        Container newType = new Container();
        this.getContainer().add(newType);
        return newType;
    }

    public Specimen addContainer(Container theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContainer().add(theValue);
        return this;
    }

    public Container getContainerFirstRep() {
        if (this.getContainer().isEmpty()) {
            return this.addContainer();
        }
        return this.getContainer().get(0);
    }

    public String getResourceName() {
        return "Specimen";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Collection
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="collector", order=0, min=0, max=1, summary=true, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="", formalDefinition="Person who collected the specimen")
        private ResourceReferenceDt myCollector;
        @Child(name="comment", type={StringDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="To communicate any details or issues encountered during the specimen collection procedure.")
        private List<StringDt> myComment;
        @Child(name="collected", order=2, min=0, max=1, summary=true, modifier=false, type={DateTimeDt.class, PeriodDt.class})
        @Description(shortDefinition="when.init", formalDefinition="Time when specimen was collected from subject - the physiologically relevant time")
        private IDatatype myCollected;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.")
        private SimpleQuantityDt myQuantity;
        @Child(name="method", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded value specifying the technique that is used to perform the procedure")
        private CodeableConceptDt myMethod;
        @Child(name="bodySite", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.")
        private CodeableConceptDt myBodySite;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCollector, this.myComment, this.myCollected, this.myQuantity, this.myMethod, this.myBodySite});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCollector, this.myComment, this.myCollected, this.myQuantity, this.myMethod, this.myBodySite});
        }

        public ResourceReferenceDt getCollector() {
            if (this.myCollector == null) {
                this.myCollector = new ResourceReferenceDt();
            }
            return this.myCollector;
        }

        public Collection setCollector(ResourceReferenceDt theValue) {
            this.myCollector = theValue;
            return this;
        }

        public List<StringDt> getComment() {
            if (this.myComment == null) {
                this.myComment = new ArrayList<StringDt>();
            }
            return this.myComment;
        }

        public Collection setComment(List<StringDt> theValue) {
            this.myComment = theValue;
            return this;
        }

        public StringDt addComment() {
            StringDt newType = new StringDt();
            this.getComment().add(newType);
            return newType;
        }

        public Collection addComment(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getComment().add(theValue);
            return this;
        }

        public StringDt getCommentFirstRep() {
            if (this.getComment().isEmpty()) {
                return this.addComment();
            }
            return this.getComment().get(0);
        }

        public Collection addComment(String theString) {
            if (this.myComment == null) {
                this.myComment = new ArrayList<StringDt>();
            }
            this.myComment.add(new StringDt(theString));
            return this;
        }

        public IDatatype getCollected() {
            return this.myCollected;
        }

        public Collection setCollected(IDatatype theValue) {
            this.myCollected = theValue;
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public Collection setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public Collection setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public CodeableConceptDt getBodySite() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodeableConceptDt();
            }
            return this.myBodySite;
        }

        public Collection setBodySite(CodeableConceptDt theValue) {
            this.myBodySite = theValue;
            return this;
        }
    }

    @Block
    public static class Treatment
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="description", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private StringDt myDescription;
        @Child(name="procedure", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded value specifying the procedure used to process the specimen")
        private CodeableConceptDt myProcedure;
        @Child(name="additive", order=2, min=0, max=-1, summary=false, modifier=false, type={Substance.class})
        @Description(shortDefinition="", formalDefinition="")
        private List<ResourceReferenceDt> myAdditive;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDescription, this.myProcedure, this.myAdditive});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDescription, this.myProcedure, this.myAdditive});
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Treatment setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Treatment setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getProcedure() {
            if (this.myProcedure == null) {
                this.myProcedure = new CodeableConceptDt();
            }
            return this.myProcedure;
        }

        public Treatment setProcedure(CodeableConceptDt theValue) {
            this.myProcedure = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getAdditive() {
            if (this.myAdditive == null) {
                this.myAdditive = new ArrayList<ResourceReferenceDt>();
            }
            return this.myAdditive;
        }

        public Treatment setAdditive(List<ResourceReferenceDt> theValue) {
            this.myAdditive = theValue;
            return this;
        }

        public ResourceReferenceDt addAdditive() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getAdditive().add(newType);
            return newType;
        }
    }

    @Block
    public static class Container
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances.")
        private List<IdentifierDt> myIdentifier;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private StringDt myDescription;
        @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of container associated with the specimen (e.g. slide, aliquot, etc.)")
        private CodeableConceptDt myType;
        @Child(name="capacity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The capacity (volume or other measure) the container may contain.")
        private SimpleQuantityDt myCapacity;
        @Child(name="specimenQuantity", type={SimpleQuantityDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.")
        private SimpleQuantityDt mySpecimenQuantity;
        @Child(name="additive", order=5, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Substance.class})
        @Description(shortDefinition="", formalDefinition="Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA")
        private IDatatype myAdditive;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDescription, this.myType, this.myCapacity, this.mySpecimenQuantity, this.myAdditive});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDescription, this.myType, this.myCapacity, this.mySpecimenQuantity, this.myAdditive});
        }

        public List<IdentifierDt> getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new ArrayList<IdentifierDt>();
            }
            return this.myIdentifier;
        }

        public Container setIdentifier(List<IdentifierDt> theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public IdentifierDt addIdentifier() {
            IdentifierDt newType = new IdentifierDt();
            this.getIdentifier().add(newType);
            return newType;
        }

        public Container addIdentifier(IdentifierDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getIdentifier().add(theValue);
            return this;
        }

        public IdentifierDt getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                return this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Container setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Container setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Container setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public SimpleQuantityDt getCapacity() {
            if (this.myCapacity == null) {
                this.myCapacity = new SimpleQuantityDt();
            }
            return this.myCapacity;
        }

        public Container setCapacity(SimpleQuantityDt theValue) {
            this.myCapacity = theValue;
            return this;
        }

        public SimpleQuantityDt getSpecimenQuantity() {
            if (this.mySpecimenQuantity == null) {
                this.mySpecimenQuantity = new SimpleQuantityDt();
            }
            return this.mySpecimenQuantity;
        }

        public Container setSpecimenQuantity(SimpleQuantityDt theValue) {
            this.mySpecimenQuantity = theValue;
            return this;
        }

        public IDatatype getAdditive() {
            return this.myAdditive;
        }

        public Container setAdditive(IDatatype theValue) {
            this.myAdditive = theValue;
            return this;
        }
    }
}

