/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ClaimTypeEnum {
    INSTITUTIONAL("institutional", "http://hl7.org/fhir/claim-type-link"),
    ORAL_HEALTH("oral", "http://hl7.org/fhir/claim-type-link"),
    PHARMACY("pharmacy", "http://hl7.org/fhir/claim-type-link"),
    PROFESSIONAL("professional", "http://hl7.org/fhir/claim-type-link"),
    VISION("vision", "http://hl7.org/fhir/claim-type-link");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "ClaimType";
    private static Map<String, ClaimTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ClaimTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ClaimTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ClaimTypeEnum forCode(String theCode) {
        ClaimTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ClaimTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ClaimTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ClaimTypeEnum>>();
        for (ClaimTypeEnum next : ClaimTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ClaimTypeEnum>(){

            public String toCodeString(ClaimTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ClaimTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public ClaimTypeEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public ClaimTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, ClaimTypeEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

