/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.CommunicationRequest;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.CommunicationStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Communication", profile="http://hl7.org/fhir/profiles/Communication", id="communication")
public class Communication
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Communication.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="category", path="Communication.category", description="", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="sender", path="Communication.sender", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner"), @Compartment(name="Device")})
    public static final String SP_SENDER = "sender";
    public static final ReferenceClientParam SENDER = new ReferenceClientParam("sender");
    @SearchParamDefinition(name="recipient", path="Communication.recipient", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner"), @Compartment(name="Device")})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    @SearchParamDefinition(name="medium", path="Communication.medium", description="", type="token")
    public static final String SP_MEDIUM = "medium";
    public static final TokenClientParam MEDIUM = new TokenClientParam("medium");
    @SearchParamDefinition(name="status", path="Communication.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="encounter", path="Communication.encounter", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="sent", path="Communication.sent", description="", type="date")
    public static final String SP_SENT = "sent";
    public static final DateClientParam SENT = new DateClientParam("sent");
    @SearchParamDefinition(name="received", path="Communication.received", description="", type="date")
    public static final String SP_RECEIVED = "received";
    public static final DateClientParam RECEIVED = new DateClientParam("received");
    @SearchParamDefinition(name="subject", path="Communication.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="Communication.subject", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="request", path="Communication.requestDetail", description="", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_ENCOUNTER = new Include("Communication:encounter");
    public static final Include INCLUDE_PATIENT = new Include("Communication:patient");
    public static final Include INCLUDE_RECIPIENT = new Include("Communication:recipient");
    public static final Include INCLUDE_REQUEST = new Include("Communication:request");
    public static final Include INCLUDE_SENDER = new Include("Communication:sender");
    public static final Include INCLUDE_SUBJECT = new Include("Communication:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifiers associated with this Communication that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    private List<IdentifierDt> myIdentifier;
    @Child(name="category", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of message conveyed such as alert, notification, reminder, instruction, etc.")
    private CodeableConceptDt myCategory;
    @Child(name="sender", order=2, min=0, max=1, summary=false, modifier=false, type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    @Description(shortDefinition="", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which was the source of the communication.")
    private ResourceReferenceDt mySender;
    @Child(name="recipient", order=3, min=0, max=-1, summary=false, modifier=false, type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Group.class})
    @Description(shortDefinition="", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which was the target of the communication. If receipts need to be tracked by individual, a separate resource instance will need to be created for each recipient. \u00a0Multiple recipient communications are intended where either a receipt(s) is not tracked (e.g. a mass mail-out) or is captured in aggregate (all emails confirmed received by a particular time).")
    private List<ResourceReferenceDt> myRecipient;
    @Child(name="payload", order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Text, attachment(s), or resource(s) that was communicated to the recipient.")
    private List<Payload> myPayload;
    @Child(name="medium", type={CodeableConceptDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A channel that was used for this communication (e.g. email, fax).")
    private List<CodeableConceptDt> myMedium;
    @Child(name="status", type={CodeDt.class}, order=6, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="The status of the transmission.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/communication-status")
    private BoundCodeDt<CommunicationStatusEnum> myStatus;
    @Child(name="encounter", order=7, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="", formalDefinition="The encounter within which the communication was sent.")
    private ResourceReferenceDt myEncounter;
    @Child(name="sent", type={DateTimeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The time when this communication was sent.")
    private DateTimeDt mySent;
    @Child(name="received", type={DateTimeDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The time when this communication arrived at the destination.")
    private DateTimeDt myReceived;
    @Child(name="reason", type={CodeableConceptDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The reason or justification for the communication.")
    private List<CodeableConceptDt> myReason;
    @Child(name="subject", order=11, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The patient who was the focus of this communication.")
    private ResourceReferenceDt mySubject;
    @Child(name="requestDetail", order=12, min=0, max=1, summary=false, modifier=false, type={CommunicationRequest.class})
    @Description(shortDefinition="", formalDefinition="The communication request that was responsible for producing this communication.")
    private ResourceReferenceDt myRequestDetail;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCategory, this.mySender, this.myRecipient, this.myPayload, this.myMedium, this.myStatus, this.myEncounter, this.mySent, this.myReceived, this.myReason, this.mySubject, this.myRequestDetail});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCategory, this.mySender, this.myRecipient, this.myPayload, this.myMedium, this.myStatus, this.myEncounter, this.mySent, this.myReceived, this.myReason, this.mySubject, this.myRequestDetail});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Communication setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Communication addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public Communication setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public ResourceReferenceDt getSender() {
        if (this.mySender == null) {
            this.mySender = new ResourceReferenceDt();
        }
        return this.mySender;
    }

    public Communication setSender(ResourceReferenceDt theValue) {
        this.mySender = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getRecipient() {
        if (this.myRecipient == null) {
            this.myRecipient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRecipient;
    }

    public Communication setRecipient(List<ResourceReferenceDt> theValue) {
        this.myRecipient = theValue;
        return this;
    }

    public ResourceReferenceDt addRecipient() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getRecipient().add(newType);
        return newType;
    }

    public List<Payload> getPayload() {
        if (this.myPayload == null) {
            this.myPayload = new ArrayList<Payload>();
        }
        return this.myPayload;
    }

    public Communication setPayload(List<Payload> theValue) {
        this.myPayload = theValue;
        return this;
    }

    public Payload addPayload() {
        Payload newType = new Payload();
        this.getPayload().add(newType);
        return newType;
    }

    public Communication addPayload(Payload theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPayload().add(theValue);
        return this;
    }

    public Payload getPayloadFirstRep() {
        if (this.getPayload().isEmpty()) {
            return this.addPayload();
        }
        return this.getPayload().get(0);
    }

    public List<CodeableConceptDt> getMedium() {
        if (this.myMedium == null) {
            this.myMedium = new ArrayList<CodeableConceptDt>();
        }
        return this.myMedium;
    }

    public Communication setMedium(List<CodeableConceptDt> theValue) {
        this.myMedium = theValue;
        return this;
    }

    public CodeableConceptDt addMedium() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getMedium().add(newType);
        return newType;
    }

    public Communication addMedium(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMedium().add(theValue);
        return this;
    }

    public CodeableConceptDt getMediumFirstRep() {
        if (this.getMedium().isEmpty()) {
            return this.addMedium();
        }
        return this.getMedium().get(0);
    }

    public BoundCodeDt<CommunicationStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CommunicationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Communication setStatus(BoundCodeDt<CommunicationStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Communication setStatus(CommunicationStatusEnum theValue) {
        this.setStatus((BoundCodeDt<CommunicationStatusEnum>)new BoundCodeDt(CommunicationStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Communication setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public DateTimeDt getSentElement() {
        if (this.mySent == null) {
            this.mySent = new DateTimeDt();
        }
        return this.mySent;
    }

    public Date getSent() {
        return (Date)this.getSentElement().getValue();
    }

    public Communication setSent(DateTimeDt theValue) {
        this.mySent = theValue;
        return this;
    }

    public Communication setSentWithSecondsPrecision(Date theDate) {
        this.mySent = new DateTimeDt(theDate);
        return this;
    }

    public Communication setSent(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.mySent = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DateTimeDt getReceivedElement() {
        if (this.myReceived == null) {
            this.myReceived = new DateTimeDt();
        }
        return this.myReceived;
    }

    public Date getReceived() {
        return (Date)this.getReceivedElement().getValue();
    }

    public Communication setReceived(DateTimeDt theValue) {
        this.myReceived = theValue;
        return this;
    }

    public Communication setReceivedWithSecondsPrecision(Date theDate) {
        this.myReceived = new DateTimeDt(theDate);
        return this;
    }

    public Communication setReceived(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myReceived = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public List<CodeableConceptDt> getReason() {
        if (this.myReason == null) {
            this.myReason = new ArrayList<CodeableConceptDt>();
        }
        return this.myReason;
    }

    public Communication setReason(List<CodeableConceptDt> theValue) {
        this.myReason = theValue;
        return this;
    }

    public CodeableConceptDt addReason() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReason().add(newType);
        return newType;
    }

    public Communication addReason(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReason().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            return this.addReason();
        }
        return this.getReason().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Communication setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestDetail() {
        if (this.myRequestDetail == null) {
            this.myRequestDetail = new ResourceReferenceDt();
        }
        return this.myRequestDetail;
    }

    public Communication setRequestDetail(ResourceReferenceDt theValue) {
        this.myRequestDetail = theValue;
        return this;
    }

    public String getResourceName() {
        return "Communication";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Payload
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="content", order=0, min=1, max=1, summary=false, modifier=false, type={StringDt.class, AttachmentDt.class, IResource.class})
        @Description(shortDefinition="", formalDefinition="A communicated content (or for multi-part communications, one portion of the communication)")
        private IDatatype myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContent});
        }

        public IDatatype getContent() {
            return this.myContent;
        }

        public Payload setContent(IDatatype theValue) {
            this.myContent = theValue;
            return this;
        }
    }
}

