/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ConditionCategoryCodesEnum {
    COMPLAINT("complaint", "http://hl7.org/fhir/condition-category"),
    SYMPTOM("symptom", "http://hl7.org/fhir/condition-category"),
    FINDING("finding", "http://hl7.org/fhir/condition-category"),
    DIAGNOSIS("diagnosis", "http://hl7.org/fhir/condition-category");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Condition Category Codes";
    private static Map<String, ConditionCategoryCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ConditionCategoryCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ConditionCategoryCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ConditionCategoryCodesEnum forCode(String theCode) {
        ConditionCategoryCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ConditionCategoryCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ConditionCategoryCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ConditionCategoryCodesEnum>>();
        for (ConditionCategoryCodesEnum next : ConditionCategoryCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ConditionCategoryCodesEnum>(){

            public String toCodeString(ConditionCategoryCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ConditionCategoryCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ConditionCategoryCodesEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public ConditionCategoryCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, ConditionCategoryCodesEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

