/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ActionListEnum {
    CANCEL__REVERSE_OR_NULLIFY("cancel", "http://hl7.org/fhir/actionlist"),
    POLL("poll", "http://hl7.org/fhir/actionlist"),
    RE_PROCESS("reprocess", "http://hl7.org/fhir/actionlist"),
    STATUS_CHECK("status", "http://hl7.org/fhir/actionlist");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "ActionList";
    private static Map<String, ActionListEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ActionListEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ActionListEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ActionListEnum forCode(String theCode) {
        ActionListEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ActionListEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ActionListEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ActionListEnum>>();
        for (ActionListEnum next : ActionListEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ActionListEnum>(){

            public String toCodeString(ActionListEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ActionListEnum theEnum) {
                return theEnum.getSystem();
            }

            public ActionListEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public ActionListEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, ActionListEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

