/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="PaymentNotice", profile="http://hl7.org/fhir/profiles/PaymentNotice", id="paymentnotice")
public class PaymentNotice
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="PaymentNotice.identifier", description="The business identifier of the Eligibility", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Response business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="ruleset", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when this resource was created.")
    private DateTimeDt myCreated;
    @Child(name="target", order=4, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The Insurer who is target  of the request.")
    private ResourceReferenceDt myTarget;
    @Child(name="provider", order=5, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myProvider;
    @Child(name="organization", order=6, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myOrganization;
    @Child(name="request", order=7, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Reference of resource to reverse")
    private ResourceReferenceDt myRequest;
    @Child(name="response", order=8, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Reference of response to resource to reverse")
    private ResourceReferenceDt myResponse;
    @Child(name="paymentStatus", type={CodingDt.class}, order=9, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The payment status, typically paid: payment sent, cleared: payment received.")
    private CodingDt myPaymentStatus;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.myRequest, this.myResponse, this.myPaymentStatus});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.myRequest, this.myResponse, this.myPaymentStatus});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public PaymentNotice setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public PaymentNotice addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public PaymentNotice setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public PaymentNotice setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public PaymentNotice setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public PaymentNotice setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public PaymentNotice setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public PaymentNotice setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public ResourceReferenceDt getProvider() {
        if (this.myProvider == null) {
            this.myProvider = new ResourceReferenceDt();
        }
        return this.myProvider;
    }

    public PaymentNotice setProvider(ResourceReferenceDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public PaymentNotice setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public PaymentNotice setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public ResourceReferenceDt getResponse() {
        if (this.myResponse == null) {
            this.myResponse = new ResourceReferenceDt();
        }
        return this.myResponse;
    }

    public PaymentNotice setResponse(ResourceReferenceDt theValue) {
        this.myResponse = theValue;
        return this;
    }

    public CodingDt getPaymentStatus() {
        if (this.myPaymentStatus == null) {
            this.myPaymentStatus = new CodingDt();
        }
        return this.myPaymentStatus;
    }

    public PaymentNotice setPaymentStatus(CodingDt theValue) {
        this.myPaymentStatus = theValue;
        return this;
    }

    public String getResourceName() {
        return "PaymentNotice";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

