package org.hl7.fhir.dstu3.model.valuesets;

import org.hl7.fhir.dstu3.exceptions.FHIRException;

public enum V3EntityNamePartType {

        /**
         * A delimiter has no meaning other than being literally printed in this name representation.  A delimiter has no implicit leading and trailing white space.
         */
        DEL, 
        /**
         * Family name, this is the name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.
         */
        FAM, 
        /**
         * Given name (don't call it "first name" since this given names do not always come first)
         */
        GIV, 
        /**
         * A prefix has a strong association to the immediately following name part. A prefix has no implicit trailing white space (it has implicit leading white space though). Note that prefixes can be inverted.
         */
        PFX, 
        /**
         * Description:A suffix has a strong association to the immediately preceding name part. A suffix has no implicit leading white space (it has implicit trailing white space though). Suffices cannot be inverted.
         */
        SFX, 
        /**
         * added to help the parsers
         */
        NULL;
        public static V3EntityNamePartType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("DEL".equals(codeString))
          return DEL;
        if ("FAM".equals(codeString))
          return FAM;
        if ("GIV".equals(codeString))
          return GIV;
        if ("PFX".equals(codeString))
          return PFX;
        if ("SFX".equals(codeString))
          return SFX;
        throw new FHIRException("Unknown V3EntityNamePartType code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case DEL: return "DEL";
            case FAM: return "FAM";
            case GIV: return "GIV";
            case PFX: return "PFX";
            case SFX: return "SFX";
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://hl7.org/fhir/v3/EntityNamePartType";
        }
        public String getDefinition() {
          switch (this) {
            case DEL: return "A delimiter has no meaning other than being literally printed in this name representation.  A delimiter has no implicit leading and trailing white space.";
            case FAM: return "Family name, this is the name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.";
            case GIV: return "Given name (don't call it \"first name\" since this given names do not always come first)";
            case PFX: return "A prefix has a strong association to the immediately following name part. A prefix has no implicit trailing white space (it has implicit leading white space though). Note that prefixes can be inverted.";
            case SFX: return "Description:A suffix has a strong association to the immediately preceding name part. A suffix has no implicit leading white space (it has implicit trailing white space though). Suffices cannot be inverted.";
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case DEL: return "delimiter";
            case FAM: return "family";
            case GIV: return "given";
            case PFX: return "prefix";
            case SFX: return "suffix";
            default: return "?";
          }
    }


}

