package org.hl7.fhir.dstu3.model.valuesets;

import org.hl7.fhir.dstu3.exceptions.FHIRException;

public enum V3SetOperator {

        /**
         * Operations that can be used to associate concepts in a terminology.
         */
        _VALUESETOPERATOR, 
        /**
         * Form the set-difference with this value, i.e., exclude this element or set from the resulting set.
         */
        E, 
        /**
         * Form the union with this value, i.e., include this element or set in the resulting set.
         */
        I, 
        /**
         * Form the intersection with the value.
         */
        A, 
        /**
         * Form the convex hull with the value. The convex hull is defined over ordered domains and is the smallest contiguous superset (interval) that of all the operand sets.
         */
        H, 
        /**
         * Form the periodic hull with the value. The periodic hull is defined over ordered domains and is the periodic set that contains all contiguous supersets of pairs of intervals generated by the operand periodic intervals.
         */
        P, 
        /**
         * added to help the parsers
         */
        NULL;
        public static V3SetOperator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("_ValueSetOperator".equals(codeString))
          return _VALUESETOPERATOR;
        if ("E".equals(codeString))
          return E;
        if ("I".equals(codeString))
          return I;
        if ("A".equals(codeString))
          return A;
        if ("H".equals(codeString))
          return H;
        if ("P".equals(codeString))
          return P;
        throw new FHIRException("Unknown V3SetOperator code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case _VALUESETOPERATOR: return "_ValueSetOperator";
            case E: return "E";
            case I: return "I";
            case A: return "A";
            case H: return "H";
            case P: return "P";
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://hl7.org/fhir/v3/SetOperator";
        }
        public String getDefinition() {
          switch (this) {
            case _VALUESETOPERATOR: return "Operations that can be used to associate concepts in a terminology.";
            case E: return "Form the set-difference with this value, i.e., exclude this element or set from the resulting set.";
            case I: return "Form the union with this value, i.e., include this element or set in the resulting set.";
            case A: return "Form the intersection with the value.";
            case H: return "Form the convex hull with the value. The convex hull is defined over ordered domains and is the smallest contiguous superset (interval) that of all the operand sets.";
            case P: return "Form the periodic hull with the value. The periodic hull is defined over ordered domains and is the periodic set that contains all contiguous supersets of pairs of intervals generated by the operand periodic intervals.";
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case _VALUESETOPERATOR: return "ValueSetOperator";
            case E: return "exclude";
            case I: return "include";
            case A: return "intersect";
            case H: return "convex hull";
            case P: return "periodic hull";
            default: return "?";
          }
    }


}

