package org.hl7.fhir.dstu3.model.valuesets;

import org.hl7.fhir.dstu3.exceptions.FHIRException;

public enum V3TargetAwareness {

        /**
         * Target person has been informed about the issue but currently denies it.
         */
        D, 
        /**
         * Target person is fully aware of the issue.
         */
        F, 
        /**
         * Target person is not capable of comprehending the issue.
         */
        I, 
        /**
         * Target person is marginally aware of the issue.
         */
        M, 
        /**
         * Target person is partially aware of the issue.
         */
        P, 
        /**
         * Target person has not yet been informed of the issue.
         */
        U, 
        /**
         * added to help the parsers
         */
        NULL;
        public static V3TargetAwareness fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("D".equals(codeString))
          return D;
        if ("F".equals(codeString))
          return F;
        if ("I".equals(codeString))
          return I;
        if ("M".equals(codeString))
          return M;
        if ("P".equals(codeString))
          return P;
        if ("U".equals(codeString))
          return U;
        throw new FHIRException("Unknown V3TargetAwareness code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case D: return "D";
            case F: return "F";
            case I: return "I";
            case M: return "M";
            case P: return "P";
            case U: return "U";
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://hl7.org/fhir/v3/TargetAwareness";
        }
        public String getDefinition() {
          switch (this) {
            case D: return "Target person has been informed about the issue but currently denies it.";
            case F: return "Target person is fully aware of the issue.";
            case I: return "Target person is not capable of comprehending the issue.";
            case M: return "Target person is marginally aware of the issue.";
            case P: return "Target person is partially aware of the issue.";
            case U: return "Target person has not yet been informed of the issue.";
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case D: return "denying";
            case F: return "full awareness";
            case I: return "incapable";
            case M: return "marginal";
            case P: return "partial";
            case U: return "uninformed";
            default: return "?";
          }
    }


}

