package org.hl7.fhir.dstu3.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Mon, Apr 17, 2017 17:38-0400 for FHIR v3.0.1


import org.hl7.fhir.exceptions.FHIRException;

public enum V3SpecimenType {

        /**
         * SpecimenEntityType
         */
        _SPECIMENENTITYTYPE, 
        /**
         * Abcess
         */
        ABS, 
        /**
         * Amniotic fluid
         */
        AMN, 
        /**
         * Aspirate
         */
        ASP, 
        /**
         * Blood bag
         */
        BBL, 
        /**
         * Whole body
         */
        BDY, 
        /**
         * Bile fluid
         */
        BIFL, 
        /**
         * Whole blood
         */
        BLD, 
        /**
         * Blood arterial
         */
        BLDA, 
        /**
         * Blood capillary
         */
        BLDC, 
        /**
         * Blood - cord
         */
        BLDCO, 
        /**
         * Blood venous
         */
        BLDV, 
        /**
         * Bone
         */
        BON, 
        /**
         * Basophils
         */
        BPH, 
        /**
         * Blood product unit
         */
        BPU, 
        /**
         * Burn
         */
        BRN, 
        /**
         * Bronchial
         */
        BRO, 
        /**
         * Exhaled gas (=breath)
         */
        BRTH, 
        /**
         * Calculus (=Stone)
         */
        CALC, 
        /**
         * Cardiac muscle
         */
        CDM, 
        /**
         * Conjunctiva
         */
        CNJT, 
        /**
         * Cannula
         */
        CNL, 
        /**
         * Colostrum
         */
        COL, 
        /**
         * Cornea
         */
        CRN, 
        /**
         * Cerebral spinal fluid
         */
        CSF, 
        /**
         * Catheter tip
         */
        CTP, 
        /**
         * Curettage
         */
        CUR, 
        /**
         * Cervical mucus
         */
        CVM, 
        /**
         * Cervix
         */
        CVX, 
        /**
         * Cyst
         */
        CYST, 
        /**
         * Dialysis fluid
         */
        DIAF, 
        /**
         * Dose med or substance
         */
        DOSE, 
        /**
         * Drain
         */
        DRN, 
        /**
         * Duodenal fluid
         */
        DUFL, 
        /**
         * Ear
         */
        EAR, 
        /**
         * Ear wax (cerumen)
         */
        EARW, 
        /**
         * Electrode
         */
        ELT, 
        /**
         * Endocardium
         */
        ENDC, 
        /**
         * Endometrium
         */
        ENDM, 
        /**
         * Eosinophils
         */
        EOS, 
        /**
         * Eye
         */
        EYE, 
        /**
         * Fibroblasts
         */
        FIB, 
        /**
         * Fistula
         */
        FIST, 
        /**
         * Filter
         */
        FLT, 
        /**
         * Body fluid, unsp
         */
        FLU, 
        /**
         * Food sample
         */
        FOOD, 
        /**
         * Gas
         */
        GAS, 
        /**
         * Gastric fluid/contents
         */
        GAST, 
        /**
         * Genital
         */
        GEN, 
        /**
         * Genital cervix
         */
        GENC, 
        /**
         * Genital fluid
         */
        GENF, 
        /**
         * Genital lochia
         */
        GENL, 
        /**
         * Genital vaginal
         */
        GENV, 
        /**
         * Hair
         */
        HAR, 
        /**
         * Inhaled Gas
         */
        IHG, 
        /**
         * Isolate
         */
        ISLT, 
        /**
         * Intubation tube
         */
        IT, 
        /**
         * Lamella
         */
        LAM, 
        /**
         * Liquid NOS
         */
        LIQ, 
        /**
         * Line
         */
        LN, 
        /**
         * Line arterial
         */
        LNA, 
        /**
         * Line venous
         */
        LNV, 
        /**
         * Lymphocytes
         */
        LYM, 
        /**
         * Macrophages
         */
        MAC, 
        /**
         * Marrow (bone)
         */
        MAR, 
        /**
         * Menstrual blood
         */
        MBLD, 
        /**
         * Meconium
         */
        MEC, 
        /**
         * Breast milk
         */
        MILK, 
        /**
         * Milk
         */
        MLK, 
        /**
         * Nail
         */
        NAIL, 
        /**
         * Nose (nasal passage)
         */
        NOS, 
        /**
         * Pancreatic fluid
         */
        PAFL, 
        /**
         * Patient
         */
        PAT, 
        /**
         * Plasma
         */
        PLAS, 
        /**
         * Plasma bag
         */
        PLB, 
        /**
         * Placenta
         */
        PLC, 
        /**
         * Pleural fluid (thoracentesis fld)
         */
        PLR, 
        /**
         * Polymorphonuclear neutrophils
         */
        PMN, 
        /**
         * Platelet poor plasma
         */
        PPP, 
        /**
         * Platelet rich plasma
         */
        PRP, 
        /**
         * Peritoneal fluid /ascites
         */
        PRT, 
        /**
         * Pus
         */
        PUS, 
        /**
         * Erythrocytes
         */
        RBC, 
        /**
         * Saliva
         */
        SAL, 
        /**
         * Serum
         */
        SER, 
        /**
         * Skeletal muscle
         */
        SKM, 
        /**
         * Skin
         */
        SKN, 
        /**
         * Seminal fluid
         */
        SMN, 
        /**
         * Seminal plasma
         */
        SMPLS, 
        /**
         * Synovial fluid (Joint fluid)
         */
        SNV, 
        /**
         * Spermatozoa
         */
        SPRM, 
        /**
         * Sputum
         */
        SPT, 
        /**
         * Sputum - coughed
         */
        SPTC, 
        /**
         * Sputum - tracheal aspirate
         */
        SPTT, 
        /**
         * Stool = Fecal
         */
        STL, 
        /**
         * Sweat
         */
        SWT, 
        /**
         * Tears
         */
        TEAR, 
        /**
         * Thrombocyte (platelet)
         */
        THRB, 
        /**
         * Throat
         */
        THRT, 
        /**
         * Tissue gall bladder
         */
        TISG, 
        /**
         * Tissue placenta
         */
        TISPL, 
        /**
         * Tissue, unspecified
         */
        TISS, 
        /**
         * Tissue ulcer
         */
        TISU, 
        /**
         * Tissue large intestine
         */
        TLGI, 
        /**
         * Tissue lung
         */
        TLNG, 
        /**
         * Tissue small intestine Tissue ulcer
         */
        TSMI, 
        /**
         * Tube, unspecified
         */
        TUB, 
        /**
         * Ulcer
         */
        ULC, 
        /**
         * Umbilical blood
         */
        UMB, 
        /**
         * Unknown medicine
         */
        UMED, 
        /**
         * Urine
         */
        UR, 
        /**
         * Urine clean catch
         */
        URC, 
        /**
         * Urine sediment
         */
        URNS, 
        /**
         * Urine catheter
         */
        URT, 
        /**
         * Urethra
         */
        URTH, 
        /**
         * Unknown substance
         */
        USUB, 
        /**
         * Vomitus
         */
        VOM, 
        /**
         * Water
         */
        WAT, 
        /**
         * Leukocytes
         */
        WBC, 
        /**
         * Wick
         */
        WICK, 
        /**
         * Wound
         */
        WND, 
        /**
         * Wound abscess
         */
        WNDA, 
        /**
         * Wound drainage
         */
        WNDD, 
        /**
         * Wound exudate
         */
        WNDE, 
        /**
         * added to help the parsers
         */
        NULL;
        public static V3SpecimenType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("_SpecimenEntityType".equals(codeString))
          return _SPECIMENENTITYTYPE;
        if ("ABS".equals(codeString))
          return ABS;
        if ("AMN".equals(codeString))
          return AMN;
        if ("ASP".equals(codeString))
          return ASP;
        if ("BBL".equals(codeString))
          return BBL;
        if ("BDY".equals(codeString))
          return BDY;
        if ("BIFL".equals(codeString))
          return BIFL;
        if ("BLD".equals(codeString))
          return BLD;
        if ("BLDA".equals(codeString))
          return BLDA;
        if ("BLDC".equals(codeString))
          return BLDC;
        if ("BLDCO".equals(codeString))
          return BLDCO;
        if ("BLDV".equals(codeString))
          return BLDV;
        if ("BON".equals(codeString))
          return BON;
        if ("BPH".equals(codeString))
          return BPH;
        if ("BPU".equals(codeString))
          return BPU;
        if ("BRN".equals(codeString))
          return BRN;
        if ("BRO".equals(codeString))
          return BRO;
        if ("BRTH".equals(codeString))
          return BRTH;
        if ("CALC".equals(codeString))
          return CALC;
        if ("CDM".equals(codeString))
          return CDM;
        if ("CNJT".equals(codeString))
          return CNJT;
        if ("CNL".equals(codeString))
          return CNL;
        if ("COL".equals(codeString))
          return COL;
        if ("CRN".equals(codeString))
          return CRN;
        if ("CSF".equals(codeString))
          return CSF;
        if ("CTP".equals(codeString))
          return CTP;
        if ("CUR".equals(codeString))
          return CUR;
        if ("CVM".equals(codeString))
          return CVM;
        if ("CVX".equals(codeString))
          return CVX;
        if ("CYST".equals(codeString))
          return CYST;
        if ("DIAF".equals(codeString))
          return DIAF;
        if ("DOSE".equals(codeString))
          return DOSE;
        if ("DRN".equals(codeString))
          return DRN;
        if ("DUFL".equals(codeString))
          return DUFL;
        if ("EAR".equals(codeString))
          return EAR;
        if ("EARW".equals(codeString))
          return EARW;
        if ("ELT".equals(codeString))
          return ELT;
        if ("ENDC".equals(codeString))
          return ENDC;
        if ("ENDM".equals(codeString))
          return ENDM;
        if ("EOS".equals(codeString))
          return EOS;
        if ("EYE".equals(codeString))
          return EYE;
        if ("FIB".equals(codeString))
          return FIB;
        if ("FIST".equals(codeString))
          return FIST;
        if ("FLT".equals(codeString))
          return FLT;
        if ("FLU".equals(codeString))
          return FLU;
        if ("FOOD".equals(codeString))
          return FOOD;
        if ("GAS".equals(codeString))
          return GAS;
        if ("GAST".equals(codeString))
          return GAST;
        if ("GEN".equals(codeString))
          return GEN;
        if ("GENC".equals(codeString))
          return GENC;
        if ("GENF".equals(codeString))
          return GENF;
        if ("GENL".equals(codeString))
          return GENL;
        if ("GENV".equals(codeString))
          return GENV;
        if ("HAR".equals(codeString))
          return HAR;
        if ("IHG".equals(codeString))
          return IHG;
        if ("ISLT".equals(codeString))
          return ISLT;
        if ("IT".equals(codeString))
          return IT;
        if ("LAM".equals(codeString))
          return LAM;
        if ("LIQ".equals(codeString))
          return LIQ;
        if ("LN".equals(codeString))
          return LN;
        if ("LNA".equals(codeString))
          return LNA;
        if ("LNV".equals(codeString))
          return LNV;
        if ("LYM".equals(codeString))
          return LYM;
        if ("MAC".equals(codeString))
          return MAC;
        if ("MAR".equals(codeString))
          return MAR;
        if ("MBLD".equals(codeString))
          return MBLD;
        if ("MEC".equals(codeString))
          return MEC;
        if ("MILK".equals(codeString))
          return MILK;
        if ("MLK".equals(codeString))
          return MLK;
        if ("NAIL".equals(codeString))
          return NAIL;
        if ("NOS".equals(codeString))
          return NOS;
        if ("PAFL".equals(codeString))
          return PAFL;
        if ("PAT".equals(codeString))
          return PAT;
        if ("PLAS".equals(codeString))
          return PLAS;
        if ("PLB".equals(codeString))
          return PLB;
        if ("PLC".equals(codeString))
          return PLC;
        if ("PLR".equals(codeString))
          return PLR;
        if ("PMN".equals(codeString))
          return PMN;
        if ("PPP".equals(codeString))
          return PPP;
        if ("PRP".equals(codeString))
          return PRP;
        if ("PRT".equals(codeString))
          return PRT;
        if ("PUS".equals(codeString))
          return PUS;
        if ("RBC".equals(codeString))
          return RBC;
        if ("SAL".equals(codeString))
          return SAL;
        if ("SER".equals(codeString))
          return SER;
        if ("SKM".equals(codeString))
          return SKM;
        if ("SKN".equals(codeString))
          return SKN;
        if ("SMN".equals(codeString))
          return SMN;
        if ("SMPLS".equals(codeString))
          return SMPLS;
        if ("SNV".equals(codeString))
          return SNV;
        if ("SPRM".equals(codeString))
          return SPRM;
        if ("SPT".equals(codeString))
          return SPT;
        if ("SPTC".equals(codeString))
          return SPTC;
        if ("SPTT".equals(codeString))
          return SPTT;
        if ("STL".equals(codeString))
          return STL;
        if ("SWT".equals(codeString))
          return SWT;
        if ("TEAR".equals(codeString))
          return TEAR;
        if ("THRB".equals(codeString))
          return THRB;
        if ("THRT".equals(codeString))
          return THRT;
        if ("TISG".equals(codeString))
          return TISG;
        if ("TISPL".equals(codeString))
          return TISPL;
        if ("TISS".equals(codeString))
          return TISS;
        if ("TISU".equals(codeString))
          return TISU;
        if ("TLGI".equals(codeString))
          return TLGI;
        if ("TLNG".equals(codeString))
          return TLNG;
        if ("TSMI".equals(codeString))
          return TSMI;
        if ("TUB".equals(codeString))
          return TUB;
        if ("ULC".equals(codeString))
          return ULC;
        if ("UMB".equals(codeString))
          return UMB;
        if ("UMED".equals(codeString))
          return UMED;
        if ("UR".equals(codeString))
          return UR;
        if ("URC".equals(codeString))
          return URC;
        if ("URNS".equals(codeString))
          return URNS;
        if ("URT".equals(codeString))
          return URT;
        if ("URTH".equals(codeString))
          return URTH;
        if ("USUB".equals(codeString))
          return USUB;
        if ("VOM".equals(codeString))
          return VOM;
        if ("WAT".equals(codeString))
          return WAT;
        if ("WBC".equals(codeString))
          return WBC;
        if ("WICK".equals(codeString))
          return WICK;
        if ("WND".equals(codeString))
          return WND;
        if ("WNDA".equals(codeString))
          return WNDA;
        if ("WNDD".equals(codeString))
          return WNDD;
        if ("WNDE".equals(codeString))
          return WNDE;
        throw new FHIRException("Unknown V3SpecimenType code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case _SPECIMENENTITYTYPE: return "_SpecimenEntityType";
            case ABS: return "ABS";
            case AMN: return "AMN";
            case ASP: return "ASP";
            case BBL: return "BBL";
            case BDY: return "BDY";
            case BIFL: return "BIFL";
            case BLD: return "BLD";
            case BLDA: return "BLDA";
            case BLDC: return "BLDC";
            case BLDCO: return "BLDCO";
            case BLDV: return "BLDV";
            case BON: return "BON";
            case BPH: return "BPH";
            case BPU: return "BPU";
            case BRN: return "BRN";
            case BRO: return "BRO";
            case BRTH: return "BRTH";
            case CALC: return "CALC";
            case CDM: return "CDM";
            case CNJT: return "CNJT";
            case CNL: return "CNL";
            case COL: return "COL";
            case CRN: return "CRN";
            case CSF: return "CSF";
            case CTP: return "CTP";
            case CUR: return "CUR";
            case CVM: return "CVM";
            case CVX: return "CVX";
            case CYST: return "CYST";
            case DIAF: return "DIAF";
            case DOSE: return "DOSE";
            case DRN: return "DRN";
            case DUFL: return "DUFL";
            case EAR: return "EAR";
            case EARW: return "EARW";
            case ELT: return "ELT";
            case ENDC: return "ENDC";
            case ENDM: return "ENDM";
            case EOS: return "EOS";
            case EYE: return "EYE";
            case FIB: return "FIB";
            case FIST: return "FIST";
            case FLT: return "FLT";
            case FLU: return "FLU";
            case FOOD: return "FOOD";
            case GAS: return "GAS";
            case GAST: return "GAST";
            case GEN: return "GEN";
            case GENC: return "GENC";
            case GENF: return "GENF";
            case GENL: return "GENL";
            case GENV: return "GENV";
            case HAR: return "HAR";
            case IHG: return "IHG";
            case ISLT: return "ISLT";
            case IT: return "IT";
            case LAM: return "LAM";
            case LIQ: return "LIQ";
            case LN: return "LN";
            case LNA: return "LNA";
            case LNV: return "LNV";
            case LYM: return "LYM";
            case MAC: return "MAC";
            case MAR: return "MAR";
            case MBLD: return "MBLD";
            case MEC: return "MEC";
            case MILK: return "MILK";
            case MLK: return "MLK";
            case NAIL: return "NAIL";
            case NOS: return "NOS";
            case PAFL: return "PAFL";
            case PAT: return "PAT";
            case PLAS: return "PLAS";
            case PLB: return "PLB";
            case PLC: return "PLC";
            case PLR: return "PLR";
            case PMN: return "PMN";
            case PPP: return "PPP";
            case PRP: return "PRP";
            case PRT: return "PRT";
            case PUS: return "PUS";
            case RBC: return "RBC";
            case SAL: return "SAL";
            case SER: return "SER";
            case SKM: return "SKM";
            case SKN: return "SKN";
            case SMN: return "SMN";
            case SMPLS: return "SMPLS";
            case SNV: return "SNV";
            case SPRM: return "SPRM";
            case SPT: return "SPT";
            case SPTC: return "SPTC";
            case SPTT: return "SPTT";
            case STL: return "STL";
            case SWT: return "SWT";
            case TEAR: return "TEAR";
            case THRB: return "THRB";
            case THRT: return "THRT";
            case TISG: return "TISG";
            case TISPL: return "TISPL";
            case TISS: return "TISS";
            case TISU: return "TISU";
            case TLGI: return "TLGI";
            case TLNG: return "TLNG";
            case TSMI: return "TSMI";
            case TUB: return "TUB";
            case ULC: return "ULC";
            case UMB: return "UMB";
            case UMED: return "UMED";
            case UR: return "UR";
            case URC: return "URC";
            case URNS: return "URNS";
            case URT: return "URT";
            case URTH: return "URTH";
            case USUB: return "USUB";
            case VOM: return "VOM";
            case WAT: return "WAT";
            case WBC: return "WBC";
            case WICK: return "WICK";
            case WND: return "WND";
            case WNDA: return "WNDA";
            case WNDD: return "WNDD";
            case WNDE: return "WNDE";
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://hl7.org/fhir/v3/SpecimenType";
        }
        public String getDefinition() {
          switch (this) {
            case _SPECIMENENTITYTYPE: return "SpecimenEntityType";
            case ABS: return "Abcess";
            case AMN: return "Amniotic fluid";
            case ASP: return "Aspirate";
            case BBL: return "Blood bag";
            case BDY: return "Whole body";
            case BIFL: return "Bile fluid";
            case BLD: return "Whole blood";
            case BLDA: return "Blood arterial";
            case BLDC: return "Blood capillary";
            case BLDCO: return "Blood - cord";
            case BLDV: return "Blood venous";
            case BON: return "Bone";
            case BPH: return "Basophils";
            case BPU: return "Blood product unit";
            case BRN: return "Burn";
            case BRO: return "Bronchial";
            case BRTH: return "Exhaled gas (=breath)";
            case CALC: return "Calculus (=Stone)";
            case CDM: return "Cardiac muscle";
            case CNJT: return "Conjunctiva";
            case CNL: return "Cannula";
            case COL: return "Colostrum";
            case CRN: return "Cornea";
            case CSF: return "Cerebral spinal fluid";
            case CTP: return "Catheter tip";
            case CUR: return "Curettage";
            case CVM: return "Cervical mucus";
            case CVX: return "Cervix";
            case CYST: return "Cyst";
            case DIAF: return "Dialysis fluid";
            case DOSE: return "Dose med or substance";
            case DRN: return "Drain";
            case DUFL: return "Duodenal fluid";
            case EAR: return "Ear";
            case EARW: return "Ear wax (cerumen)";
            case ELT: return "Electrode";
            case ENDC: return "Endocardium";
            case ENDM: return "Endometrium";
            case EOS: return "Eosinophils";
            case EYE: return "Eye";
            case FIB: return "Fibroblasts";
            case FIST: return "Fistula";
            case FLT: return "Filter";
            case FLU: return "Body fluid, unsp";
            case FOOD: return "Food sample";
            case GAS: return "Gas";
            case GAST: return "Gastric fluid/contents";
            case GEN: return "Genital";
            case GENC: return "Genital cervix";
            case GENF: return "Genital fluid";
            case GENL: return "Genital lochia";
            case GENV: return "Genital vaginal";
            case HAR: return "Hair";
            case IHG: return "Inhaled Gas";
            case ISLT: return "Isolate";
            case IT: return "Intubation tube";
            case LAM: return "Lamella";
            case LIQ: return "Liquid NOS";
            case LN: return "Line";
            case LNA: return "Line arterial";
            case LNV: return "Line venous";
            case LYM: return "Lymphocytes";
            case MAC: return "Macrophages";
            case MAR: return "Marrow (bone)";
            case MBLD: return "Menstrual blood";
            case MEC: return "Meconium";
            case MILK: return "Breast milk";
            case MLK: return "Milk";
            case NAIL: return "Nail";
            case NOS: return "Nose (nasal passage)";
            case PAFL: return "Pancreatic fluid";
            case PAT: return "Patient";
            case PLAS: return "Plasma";
            case PLB: return "Plasma bag";
            case PLC: return "Placenta";
            case PLR: return "Pleural fluid (thoracentesis fld)";
            case PMN: return "Polymorphonuclear neutrophils";
            case PPP: return "Platelet poor plasma";
            case PRP: return "Platelet rich plasma";
            case PRT: return "Peritoneal fluid /ascites";
            case PUS: return "Pus";
            case RBC: return "Erythrocytes";
            case SAL: return "Saliva";
            case SER: return "Serum";
            case SKM: return "Skeletal muscle";
            case SKN: return "Skin";
            case SMN: return "Seminal fluid";
            case SMPLS: return "Seminal plasma";
            case SNV: return "Synovial fluid (Joint fluid)";
            case SPRM: return "Spermatozoa";
            case SPT: return "Sputum";
            case SPTC: return "Sputum - coughed";
            case SPTT: return "Sputum - tracheal aspirate";
            case STL: return "Stool = Fecal";
            case SWT: return "Sweat";
            case TEAR: return "Tears";
            case THRB: return "Thrombocyte (platelet)";
            case THRT: return "Throat";
            case TISG: return "Tissue gall bladder";
            case TISPL: return "Tissue placenta";
            case TISS: return "Tissue, unspecified";
            case TISU: return "Tissue ulcer";
            case TLGI: return "Tissue large intestine";
            case TLNG: return "Tissue lung";
            case TSMI: return "Tissue small intestine Tissue ulcer";
            case TUB: return "Tube, unspecified";
            case ULC: return "Ulcer";
            case UMB: return "Umbilical blood";
            case UMED: return "Unknown medicine";
            case UR: return "Urine";
            case URC: return "Urine clean catch";
            case URNS: return "Urine sediment";
            case URT: return "Urine catheter";
            case URTH: return "Urethra";
            case USUB: return "Unknown substance";
            case VOM: return "Vomitus";
            case WAT: return "Water";
            case WBC: return "Leukocytes";
            case WICK: return "Wick";
            case WND: return "Wound";
            case WNDA: return "Wound abscess";
            case WNDD: return "Wound drainage";
            case WNDE: return "Wound exudate";
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case _SPECIMENENTITYTYPE: return "SpecimenEntityType";
            case ABS: return "Abcess";
            case AMN: return "Amniotic fluid";
            case ASP: return "Aspirate";
            case BBL: return "Blood bag";
            case BDY: return "Whole body";
            case BIFL: return "Bile fluid";
            case BLD: return "Whole blood";
            case BLDA: return "Blood arterial";
            case BLDC: return "Blood capillary";
            case BLDCO: return "Blood - cord";
            case BLDV: return "Blood venous";
            case BON: return "Bone";
            case BPH: return "Basophils";
            case BPU: return "Blood product unit";
            case BRN: return "Burn";
            case BRO: return "Bronchial";
            case BRTH: return "Exhaled gas (=breath)";
            case CALC: return "Calculus (=Stone)";
            case CDM: return "Cardiac muscle";
            case CNJT: return "Conjunctiva";
            case CNL: return "Cannula";
            case COL: return "Colostrum";
            case CRN: return "Cornea";
            case CSF: return "Cerebral spinal fluid";
            case CTP: return "Catheter tip";
            case CUR: return "Curettage";
            case CVM: return "Cervical mucus";
            case CVX: return "Cervix";
            case CYST: return "Cyst";
            case DIAF: return "Dialysis fluid";
            case DOSE: return "Dose med or substance";
            case DRN: return "Drain";
            case DUFL: return "Duodenal fluid";
            case EAR: return "Ear";
            case EARW: return "Ear wax (cerumen)";
            case ELT: return "Electrode";
            case ENDC: return "Endocardium";
            case ENDM: return "Endometrium";
            case EOS: return "Eosinophils";
            case EYE: return "Eye";
            case FIB: return "Fibroblasts";
            case FIST: return "Fistula";
            case FLT: return "Filter";
            case FLU: return "Body fluid, unsp";
            case FOOD: return "Food sample";
            case GAS: return "Gas";
            case GAST: return "Gastric fluid/contents";
            case GEN: return "Genital";
            case GENC: return "Genital cervix";
            case GENF: return "Genital fluid";
            case GENL: return "Genital lochia";
            case GENV: return "Genital vaginal";
            case HAR: return "Hair";
            case IHG: return "Inhaled Gas";
            case ISLT: return "Isolate";
            case IT: return "Intubation tube";
            case LAM: return "Lamella";
            case LIQ: return "Liquid NOS";
            case LN: return "Line";
            case LNA: return "Line arterial";
            case LNV: return "Line venous";
            case LYM: return "Lymphocytes";
            case MAC: return "Macrophages";
            case MAR: return "Marrow (bone)";
            case MBLD: return "Menstrual blood";
            case MEC: return "Meconium";
            case MILK: return "Breast milk";
            case MLK: return "Milk";
            case NAIL: return "Nail";
            case NOS: return "Nose (nasal passage)";
            case PAFL: return "Pancreatic fluid";
            case PAT: return "Patient";
            case PLAS: return "Plasma";
            case PLB: return "Plasma bag";
            case PLC: return "Placenta";
            case PLR: return "Pleural fluid (thoracentesis fld)";
            case PMN: return "Polymorphonuclear neutrophils";
            case PPP: return "Platelet poor plasma";
            case PRP: return "Platelet rich plasma";
            case PRT: return "Peritoneal fluid /ascites";
            case PUS: return "Pus";
            case RBC: return "Erythrocytes";
            case SAL: return "Saliva";
            case SER: return "Serum";
            case SKM: return "Skeletal muscle";
            case SKN: return "Skin";
            case SMN: return "Seminal fluid";
            case SMPLS: return "Seminal plasma";
            case SNV: return "Synovial fluid (Joint fluid)";
            case SPRM: return "Spermatozoa";
            case SPT: return "Sputum";
            case SPTC: return "Sputum - coughed";
            case SPTT: return "Sputum - tracheal aspirate";
            case STL: return "Stool = Fecal";
            case SWT: return "Sweat";
            case TEAR: return "Tears";
            case THRB: return "Thrombocyte (platelet)";
            case THRT: return "Throat";
            case TISG: return "Tissue gall bladder";
            case TISPL: return "Tissue placenta";
            case TISS: return "Tissue, unspecified";
            case TISU: return "Tissue ulcer";
            case TLGI: return "Tissue large intestine";
            case TLNG: return "Tissue lung";
            case TSMI: return "Tissue small intestine Tissue ulcer";
            case TUB: return "Tube, unspecified";
            case ULC: return "Ulcer";
            case UMB: return "Umbilical blood";
            case UMED: return "Unknown medicine";
            case UR: return "Urine";
            case URC: return "Urine clean catch";
            case URNS: return "Urine sediment";
            case URT: return "Urine catheter";
            case URTH: return "Urethra";
            case USUB: return "Unknown substance";
            case VOM: return "Vomitus";
            case WAT: return "Water";
            case WBC: return "Leukocytes";
            case WICK: return "Wick";
            case WND: return "Wound";
            case WNDA: return "Wound abscess";
            case WNDD: return "Wound drainage";
            case WNDE: return "Wound exudate";
            default: return "?";
          }
    }


}

