/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.elementmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.elementmodel.Element;
import org.hl7.fhir.dstu3.elementmodel.ParserBase;
import org.hl7.fhir.dstu3.elementmodel.Property;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonCreator;
import org.hl7.fhir.dstu3.formats.JsonCreatorCanonical;
import org.hl7.fhir.dstu3.formats.JsonCreatorGson;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.utils.formats.JsonTrackingParser;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class JsonParser
extends ParserBase {
    private JsonCreator json;
    private Map<JsonElement, JsonTrackingParser.LocationData> map;

    public JsonParser(IWorkerContext context) {
        super(context);
    }

    public Element parse(String source, String type) throws Exception {
        JsonObject obj = (JsonObject)new com.google.gson.JsonParser().parse(source);
        String path = "/" + type;
        StructureDefinition sd = this.getDefinition(-1, -1, type);
        if (sd == null) {
            return null;
        }
        Element result = new Element(type, new Property(this.context, sd.getSnapshot().getElement().get(0), sd));
        this.checkObject(obj, path);
        result.setType(type);
        this.parseChildren(path, obj, result, true);
        result.numberChildren();
        return result;
    }

    @Override
    public Element parse(InputStream stream) throws IOException, FHIRFormatError, DefinitionException {
        this.map = new HashMap<JsonElement, JsonTrackingParser.LocationData>();
        String source = TextFile.streamToString((InputStream)stream);
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            JsonObject obj = null;
            try {
                obj = JsonTrackingParser.parse(source, this.map);
            }
            catch (Exception e) {
                this.logError(-1, -1, "(document)", ValidationMessage.IssueType.INVALID, "Error parsing JSON: " + e.getMessage(), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            assert (this.map.containsKey(obj));
            return this.parse(obj);
        }
        JsonObject obj = (JsonObject)new com.google.gson.JsonParser().parse(source);
        return this.parse(obj);
    }

    public Element parse(JsonObject object, Map<JsonElement, JsonTrackingParser.LocationData> map) throws FHIRFormatError, DefinitionException {
        this.map = map;
        return this.parse(object);
    }

    public Element parse(JsonObject object) throws FHIRFormatError, DefinitionException {
        JsonElement rt = object.get("resourceType");
        if (rt == null) {
            this.logError(this.line((JsonElement)object), this.col((JsonElement)object), "$", ValidationMessage.IssueType.INVALID, "Unable to find resourceType property", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        String name = rt.getAsString();
        String path = "/" + name;
        StructureDefinition sd = this.getDefinition(this.line((JsonElement)object), this.col((JsonElement)object), name);
        if (sd == null) {
            return null;
        }
        Element result = new Element(name, new Property(this.context, sd.getSnapshot().getElement().get(0), sd));
        this.checkObject(object, path);
        result.markLocation(this.line((JsonElement)object), this.col((JsonElement)object));
        result.setType(name);
        this.parseChildren(path, object, result, true);
        result.numberChildren();
        return result;
    }

    private void checkObject(JsonObject object, String path) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            boolean found = false;
            Iterator iterator = object.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry e = (Map.Entry)iterator.next();
                found = true;
            }
            if (!found) {
                this.logError(this.line((JsonElement)object), this.col((JsonElement)object), path, ValidationMessage.IssueType.INVALID, "Object must have some content", ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private void parseChildren(String path, JsonObject object, Element context, boolean hasResourceType) throws DefinitionException, FHIRFormatError {
        this.reapComments(object, context);
        List<Property> properties = context.getProperty().getChildProperties(context.getName(), null);
        HashSet<String> processed = new HashSet<String>();
        if (hasResourceType) {
            processed.add("resourceType");
        }
        processed.add("fhir_comments");
        block0: for (Property property : properties) {
            if (property.isChoice()) {
                for (ElementDefinition.TypeRefComponent type : property.getDefinition().getType()) {
                    String eName = property.getName().substring(0, property.getName().length() - 3) + Utilities.capitalize((String)type.getCode());
                    if (!this.isPrimitive(type.getCode()) && object.has(eName)) {
                        this.parseChildComplex(path, object, context, processed, property, eName);
                        continue block0;
                    }
                    if (!this.isPrimitive(type.getCode()) || !object.has(eName) && !object.has("_" + eName)) continue;
                    this.parseChildPrimitive(object, context, processed, property, path, eName);
                    continue block0;
                }
                continue;
            }
            if (property.isPrimitive(property.getType(null))) {
                this.parseChildPrimitive(object, context, processed, property, path, property.getName());
                continue;
            }
            if (!object.has(property.getName())) continue;
            this.parseChildComplex(path, object, context, processed, property, property.getName());
        }
        if (this.policy != ParserBase.ValidationPolicy.NONE) {
            for (Map.Entry e : object.entrySet()) {
                if (processed.contains(e.getKey())) continue;
                this.logError(this.line((JsonElement)e.getValue()), this.col((JsonElement)e.getValue()), path, ValidationMessage.IssueType.STRUCTURE, "Unrecognised property '@" + (String)e.getKey() + "'", ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private void parseChildComplex(String path, JsonObject object, Element context, Set<String> processed, Property property, String name) throws FHIRFormatError, DefinitionException {
        processed.add(name);
        String npath = path + "/" + property.getName();
        JsonElement e = object.get(name);
        if (property.isList() && e instanceof JsonArray) {
            JsonArray arr = (JsonArray)e;
            for (JsonElement am : arr) {
                this.parseChildComplexInstance(npath, object, context, property, name, am);
            }
        } else {
            this.parseChildComplexInstance(npath, object, context, property, name, e);
        }
    }

    private void parseChildComplexInstance(String npath, JsonObject object, Element context, Property property, String name, JsonElement e) throws FHIRFormatError, DefinitionException {
        if (e instanceof JsonObject) {
            JsonObject child = (JsonObject)e;
            Element n = new Element(name, property).markLocation(this.line((JsonElement)child), this.col((JsonElement)child));
            this.checkObject(child, npath);
            context.getChildren().add(n);
            if (property.isResource()) {
                this.parseResource(npath, child, n, property);
            } else {
                this.parseChildren(npath, child, n, false);
            }
        } else {
            this.logError(this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, "This property must be " + (property.isList() ? "an Array" : "an Object") + ", not a " + e.getClass().getName(), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private void parseChildPrimitive(JsonObject object, Element context, Set<String> processed, Property property, String path, String name) throws FHIRFormatError, DefinitionException {
        JsonElement fork;
        String npath = path + "/" + property.getName();
        processed.add(name);
        processed.add("_" + name);
        JsonElement main = object.has(name) ? object.get(name) : null;
        JsonElement jsonElement = fork = object.has("_" + name) ? object.get("_" + name) : null;
        if (main != null || fork != null) {
            if (property.isList() && (main == null || main instanceof JsonArray) && (fork == null || fork instanceof JsonArray)) {
                JsonArray arr1 = (JsonArray)main;
                JsonArray arr2 = (JsonArray)fork;
                for (int i = 0; i < Math.max(this.arrC(arr1), this.arrC(arr2)); ++i) {
                    JsonElement m = this.arrI(arr1, i);
                    JsonElement f = this.arrI(arr2, i);
                    this.parseChildPrimitiveInstance(context, property, name, npath, m, f);
                }
            } else {
                this.parseChildPrimitiveInstance(context, property, name, npath, main, fork);
            }
        }
    }

    private JsonElement arrI(JsonArray arr, int i) {
        return arr == null || i >= arr.size() || arr.get(i) instanceof JsonNull ? null : arr.get(i);
    }

    private int arrC(JsonArray arr) {
        return arr == null ? 0 : arr.size();
    }

    private void parseChildPrimitiveInstance(Element context, Property property, String name, String npath, JsonElement main, JsonElement fork) throws FHIRFormatError, DefinitionException {
        if (main != null && !(main instanceof JsonPrimitive)) {
            this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, "This property must be an simple value, not a " + main.getClass().getName(), ValidationMessage.IssueSeverity.ERROR);
        } else if (fork != null && !(fork instanceof JsonObject)) {
            this.logError(this.line(fork), this.col(fork), npath, ValidationMessage.IssueType.INVALID, "This property must be an object, not a " + fork.getClass().getName(), ValidationMessage.IssueSeverity.ERROR);
        } else {
            Element n = new Element(name, property).markLocation(this.line(main != null ? main : fork), this.col(main != null ? main : fork));
            context.getChildren().add(n);
            if (main != null) {
                JsonPrimitive p = (JsonPrimitive)main;
                n.setValue(p.getAsString());
                if (!n.getProperty().isChoice() && n.getType().equals("xhtml")) {
                    try {
                        n.setXhtml(new XhtmlParser().setValidatorMode(this.policy == ParserBase.ValidationPolicy.EVERYTHING).parse(n.getValue(), null).getDocumentElement());
                    }
                    catch (Exception e) {
                        this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, "Error parsing XHTML: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
                if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                    if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"boolean"})) {
                        if (!p.isBoolean()) {
                            this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, "Error parsing JSON: the primitive value must be a boolean", ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"integer", "unsignedInt", "positiveInt", "decimal"})) {
                        if (!p.isNumber()) {
                            this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, "Error parsing JSON: the primitive value must be a number", ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (!p.isString()) {
                        this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, "Error parsing JSON: the primitive value must be a string", ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            }
            if (fork != null) {
                JsonObject child = (JsonObject)fork;
                this.checkObject(child, npath);
                this.parseChildren(npath, child, n, false);
            }
        }
    }

    private void parseResource(String npath, JsonObject res, Element parent, Property elementProperty) throws DefinitionException, FHIRFormatError {
        JsonElement rt = res.get("resourceType");
        if (rt == null) {
            this.logError(this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, "Unable to find resourceType property", ValidationMessage.IssueSeverity.FATAL);
        } else {
            String name = rt.getAsString();
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + name);
            if (sd == null) {
                throw new FHIRFormatError("Contained resource does not appear to be a FHIR resource (unknown name '" + name + "')");
            }
            parent.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd), Element.SpecialElement.fromProperty(parent.getProperty()), elementProperty);
            parent.setType(name);
            this.parseChildren(npath, res, parent, true);
        }
    }

    private void reapComments(JsonObject object, Element context) {
        if (object.has("fhir_comments")) {
            JsonArray arr = object.getAsJsonArray("fhir_comments");
            for (JsonElement e : arr) {
                context.getComments().add(e.getAsString());
            }
        }
    }

    private int line(JsonElement e) {
        if (this.map == null || !this.map.containsKey(e)) {
            return -1;
        }
        return this.map.get(e).getLine();
    }

    private int col(JsonElement e) {
        if (this.map == null || !this.map.containsKey(e)) {
            return -1;
        }
        return this.map.get(e).getCol();
    }

    protected void prop(String name, String value, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void open(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void close() throws IOException {
        this.json.endObject();
    }

    protected void openArray(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws IOException {
        this.json.endArray();
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String identity) throws FHIRException, IOException {
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : new JsonCreatorGson(osw);
        this.json.setIndent(style == IParser.OutputStyle.PRETTY ? "  " : "");
        this.json.beginObject();
        this.prop("resourceType", e.getType(), null);
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    public void compose(Element e, JsonCreator json) throws Exception {
        this.json = json;
        json.beginObject();
        this.prop("resourceType", e.getType(), this.linkResolver == null ? null : this.linkResolver.resolveProperty(e.getProperty()));
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        json.endObject();
        json.finish();
    }

    private void compose(String path, Element e, Set<String> done, Element child) throws IOException {
        boolean isList;
        boolean bl = isList = child.hasElementProperty() ? child.getElementProperty().isList() : child.getProperty().isList();
        if (!isList) {
            this.compose(path, child);
        } else if (!done.contains(child.getName())) {
            done.add(child.getName());
            List<Element> list = e.getChildrenByName(child.getName());
            this.composeList(path, list);
        }
    }

    private void composeList(String path, List<Element> list) throws IOException {
        String name = list.get(0).getName();
        boolean complex = true;
        if (list.get(0).isPrimitive()) {
            boolean prim = false;
            complex = false;
            for (Element item : list) {
                if (item.hasValue()) {
                    prim = true;
                }
                if (!item.hasChildren()) continue;
                complex = true;
            }
            if (prim) {
                this.openArray(name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
                for (Element item : list) {
                    if (item.hasValue()) {
                        this.primitiveValue(null, item);
                        continue;
                    }
                    this.json.nullValue();
                }
                this.closeArray();
            }
            name = "_" + name;
        }
        if (complex) {
            this.openArray(name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
            for (Element item : list) {
                if (item.hasChildren()) {
                    this.open(null, null);
                    if (item.getProperty().isResource()) {
                        this.prop("resourceType", item.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(item.getType()));
                    }
                    HashSet<String> done = new HashSet<String>();
                    for (Element child : item.getChildren()) {
                        this.compose(path + "." + name + "[]", item, done, child);
                    }
                    this.close();
                    continue;
                }
                this.json.nullValue();
            }
            this.closeArray();
        }
    }

    private void primitiveValue(String name, Element item) throws IOException {
        String type;
        if (name != null) {
            if (this.linkResolver != null) {
                this.json.link(this.linkResolver.resolveProperty(item.getProperty()));
            }
            this.json.name(name);
        }
        if (Utilities.existsInList((String)(type = item.getType()), (String[])new String[]{"boolean"})) {
            this.json.value(item.getValue().trim().equals("true") ? new Boolean(true) : new Boolean(false));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"integer", "unsignedInt", "positiveInt"})) {
            this.json.value(new Integer(item.getValue()));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"decimal"})) {
            this.json.value(new BigDecimal(item.getValue()));
        } else {
            this.json.value(item.getValue());
        }
    }

    private void compose(String path, Element element) throws IOException {
        String name = element.getName();
        if (element.isPrimitive() || this.isPrimitive(element.getType())) {
            if (element.hasValue()) {
                this.primitiveValue(name, element);
            }
            name = "_" + name;
        }
        if (element.hasChildren()) {
            this.open(name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()));
            if (element.getProperty().isResource()) {
                this.prop("resourceType", element.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(element.getType()));
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : element.getChildren()) {
                this.compose(path + "." + element.getName(), element, done, child);
            }
            this.close();
        }
    }
}

