/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.HistoryNotDoneReason;

public class HistoryNotDoneReasonEnumFactory
implements EnumFactory<HistoryNotDoneReason> {
    @Override
    public HistoryNotDoneReason fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("subject-unknown".equals(codeString)) {
            return HistoryNotDoneReason.SUBJECTUNKNOWN;
        }
        if ("withheld".equals(codeString)) {
            return HistoryNotDoneReason.WITHHELD;
        }
        if ("unable-to-obtain".equals(codeString)) {
            return HistoryNotDoneReason.UNABLETOOBTAIN;
        }
        if ("deferred".equals(codeString)) {
            return HistoryNotDoneReason.DEFERRED;
        }
        throw new IllegalArgumentException("Unknown HistoryNotDoneReason code '" + codeString + "'");
    }

    @Override
    public String toCode(HistoryNotDoneReason code) {
        if (code == HistoryNotDoneReason.SUBJECTUNKNOWN) {
            return "subject-unknown";
        }
        if (code == HistoryNotDoneReason.WITHHELD) {
            return "withheld";
        }
        if (code == HistoryNotDoneReason.UNABLETOOBTAIN) {
            return "unable-to-obtain";
        }
        if (code == HistoryNotDoneReason.DEFERRED) {
            return "deferred";
        }
        return "?";
    }

    @Override
    public String toSystem(HistoryNotDoneReason code) {
        return code.getSystem();
    }
}

