/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ReactionEventSeverity;

public class ReactionEventSeverityEnumFactory
implements EnumFactory<ReactionEventSeverity> {
    @Override
    public ReactionEventSeverity fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("mild".equals(codeString)) {
            return ReactionEventSeverity.MILD;
        }
        if ("moderate".equals(codeString)) {
            return ReactionEventSeverity.MODERATE;
        }
        if ("severe".equals(codeString)) {
            return ReactionEventSeverity.SEVERE;
        }
        throw new IllegalArgumentException("Unknown ReactionEventSeverity code '" + codeString + "'");
    }

    @Override
    public String toCode(ReactionEventSeverity code) {
        if (code == ReactionEventSeverity.MILD) {
            return "mild";
        }
        if (code == ReactionEventSeverity.MODERATE) {
            return "moderate";
        }
        if (code == ReactionEventSeverity.SEVERE) {
            return "severe";
        }
        return "?";
    }

    @Override
    public String toSystem(ReactionEventSeverity code) {
        return code.getSystem();
    }
}

