/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.terminologies;

import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;

public class ValueSetUtilities {
    public static ValueSet makeShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType t : vs.getMeta().getProfile()) {
            if (!((String)t.getValue()).equals("http://hl7.org/fhir/StructureDefinition/valueset-shareable-definition")) continue;
            return vs;
        }
        vs.getMeta().getProfile().add(new UriType("http://hl7.org/fhir/StructureDefinition/valueset-shareable-definition"));
        return vs;
    }

    public static void checkShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
        }
        for (UriType t : vs.getMeta().getProfile()) {
            if (!((String)t.getValue()).equals("http://hl7.org/fhir/StructureDefinition/valueset-shareable-definition")) continue;
            return;
        }
        throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
    }

    public static boolean hasOID(ValueSet vs) {
        return ValueSetUtilities.getOID(vs) != null;
    }

    public static String getOID(ValueSet vs) {
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ValueSet vs, String oid) {
        if (!oid.startsWith("urn:oid:")) {
            oid = "urn:oid:" + oid;
        }
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue(oid);
            return;
        }
        vs.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue(oid);
    }
}

