/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.ParserType;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.utils.INarrativeGenerator;
import org.hl7.fhir.dstu3.utils.validation.IResourceValidator;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HapiWorkerContext
extends I18nBase
implements IWorkerContext {
    private static final Logger ourLog = LoggerFactory.getLogger(HapiWorkerContext.class);
    private final FhirContext myCtx;
    private final Cache<String, Resource> myFetchedResourceCache;
    private IValidationSupport myValidationSupport;
    private ExpansionProfile myExpansionProfile;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        long timeoutMillis = HapiSystemProperties.getTestValidationResourceCachesMs();
        this.myFetchedResourceCache = CacheFactory.build((long)timeoutMillis);
        this.setValidationMessageLanguage(this.getLocale());
    }

    @CoverageIgnore
    public List<MetadataResource> allConformanceResources() {
        throw new UnsupportedOperationException(Msg.code((int)610));
    }

    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.fetchAllStructureDefinitions();
    }

    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent theInc, boolean theHierarchical) {
        ValueSet input = new ValueSet();
        input.getCompose().addInclude(theInc);
        IValidationSupport.ValueSetExpansionOutcome output = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), null, (IBaseResource)input);
        ValueSet outputValueSet = (ValueSet)output.getValueSet();
        if (outputValueSet != null) {
            return outputValueSet.getExpansion();
        }
        return null;
    }

    public StructureDefinition fetchTypeDefinition(String theCode) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + theCode);
    }

    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (CodeSystem)this.myValidationSupport.fetchCodeSystem(theSystem);
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        Validate.notBlank((CharSequence)theUri, (String)"theUri must not be null or blank", (Object[])new Object[0]);
        if (this.myValidationSupport == null) {
            return null;
        }
        try {
            return (T)((Resource)this.myFetchedResourceCache.get((Object)theUri, t -> {
                Resource resource = (Resource)this.myValidationSupport.fetchResource(theClass, theUri);
                if (resource == null) {
                    throw new IllegalArgumentException(Msg.code((int)611));
                }
                return resource;
            }));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> theClass_, String theUri) throws FHIRException {
        T retVal = this.fetchResource(theClass_, theUri);
        if (retVal == null) {
            throw new FHIRException(Msg.code((int)612) + "Unable to fetch " + theUri);
        }
        return retVal;
    }

    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException(Msg.code((int)613));
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean heiarchical) {
        throw new UnsupportedOperationException(Msg.code((int)614));
    }

    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException(Msg.code((int)615));
    }

    public ExpansionProfile getExpansionProfile() {
        return this.myExpansionProfile;
    }

    public void setExpansionProfile(ExpansionProfile theExpProfile) {
        this.myExpansionProfile = theExpProfile;
    }

    public INarrativeGenerator getNarrativeGenerator(String thePrefix, String theBasePath) {
        throw new UnsupportedOperationException(Msg.code((int)616));
    }

    public IResourceValidator newValidator() throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)617));
    }

    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException(Msg.code((int)618));
    }

    public IParser getParser(String theType) {
        throw new UnsupportedOperationException(Msg.code((int)619));
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    public Set<String> getResourceNamesAsSet() {
        return new HashSet<String>(this.getResourceNames());
    }

    public List<String> getTypeNames() {
        throw new UnsupportedOperationException(Msg.code((int)620));
    }

    public String getVersion() {
        return this.myCtx.getVersion().getVersion().getFhirVersionString();
    }

    @CoverageIgnore
    public boolean hasCache() {
        throw new UnsupportedOperationException(Msg.code((int)621));
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException(Msg.code((int)622));
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException(Msg.code((int)623));
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException(Msg.code((int)624));
    }

    public String oid2Uri(String theCode) {
        throw new UnsupportedOperationException(Msg.code((int)625));
    }

    public void setLogger(IWorkerContext.ILoggingService theLogger) {
        throw new UnsupportedOperationException(Msg.code((int)626));
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(new ValidationSupportContext(this.myValidationSupport), theSystem);
    }

    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null);
    }

    public IWorkerContext.ValidationResult validateCode(Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(system, code, display, theVs);
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay) {
        ValidationOptions options = new ValidationOptions(new String[0]);
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(options), theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        ValidationMessage.IssueSeverity severity = null;
        if (result.getSeverity() != null) {
            severity = ValidationMessage.IssueSeverity.fromCode((String)result.getSeverityCode());
        }
        CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent().setCode(result.getCode());
        return new IWorkerContext.ValidationResult(severity, result.getMessage(), definition);
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet.ConceptSetComponent theVsi) {
        throw new UnsupportedOperationException(Msg.code((int)627));
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        ValidationOptions options = new ValidationOptions(new String[0]);
        IValidationSupport.CodeValidationResult outcome = StringUtils.isNotBlank((CharSequence)theVs.getUrl()) ? this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(options), theSystem, theCode, theDisplay, theVs.getUrl()) : this.myValidationSupport.validateCodeInValueSet(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(options), theSystem, theCode, theDisplay, (IBaseResource)theVs);
        if (outcome != null && outcome.isOk()) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theCode);
            definition.setDisplay(outcome.getDisplay());
            return new IWorkerContext.ValidationResult(definition);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "]");
    }
}

