/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.hapi.rest.server;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.Bindings;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import ca.uhn.fhir.rest.server.util.BaseServerCapabilityStatementProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ServerConformanceProvider
extends BaseServerCapabilityStatementProvider
implements IServerConformanceProvider<Conformance> {
    private String myPublisher = "Not provided";

    public ServerConformanceProvider() {
    }

    @Deprecated
    public ServerConformanceProvider(RestfulServer theRestfulServer) {
        this();
    }

    public ServerConformanceProvider(RestfulServerConfiguration theServerConfiguration) {
        super(theServerConfiguration);
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
    }

    private void checkBindingForSystemOps(Conformance.ConformanceRestComponent rest, Set<Conformance.SystemRestfulInteraction> systemOps, BaseMethodBinding<?> nextMethodBinding) {
        String sysOpCode;
        if (nextMethodBinding.getRestOperationType() != null && (sysOpCode = nextMethodBinding.getRestOperationType().getCode()) != null) {
            Conformance.SystemRestfulInteraction sysOp;
            try {
                sysOp = Conformance.SystemRestfulInteraction.fromCode((String)sysOpCode);
            }
            catch (Exception e) {
                sysOp = null;
            }
            if (sysOp == null) {
                return;
            }
            if (!systemOps.contains(sysOp)) {
                systemOps.add(sysOp);
                rest.addInteraction().setCode(sysOp);
            }
        }
    }

    private Map<String, List<BaseMethodBinding<?>>> collectMethodBindings(RequestDetails theRequestDetails) {
        String resourceName;
        TreeMap resourceToMethods = new TreeMap();
        for (ResourceBinding next : this.getServerConfiguration(theRequestDetails).getResourceBindings()) {
            resourceName = next.getResourceName();
            for (BaseMethodBinding nextMethodBinding : next.getMethodBindings()) {
                if (!resourceToMethods.containsKey(resourceName)) {
                    resourceToMethods.put(resourceName, new ArrayList());
                }
                ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
            }
        }
        for (BaseMethodBinding nextMethodBinding : this.getServerConfiguration(theRequestDetails).getServerBindings()) {
            resourceName = "";
            if (!resourceToMethods.containsKey(resourceName)) {
                resourceToMethods.put(resourceName, new ArrayList());
            }
            ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
        }
        return resourceToMethods;
    }

    private String createOperationName(OperationMethodBinding theMethodBinding) {
        return theMethodBinding.getName().substring(1);
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    @Metadata
    public Conformance getServerConformance(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
        RestfulServerConfiguration serverConfiguration = this.getServerConfiguration(theRequestDetails);
        Bindings bindings = serverConfiguration.provideBindings();
        Conformance retVal = new Conformance();
        retVal.setPublisher(this.myPublisher);
        retVal.setDateElement(this.conformanceDate(theRequestDetails));
        retVal.setFhirVersion(FhirVersionEnum.DSTU2_HL7ORG.getFhirVersionString());
        retVal.setAcceptUnknown(Conformance.UnknownContentCode.EXTENSIONS);
        retVal.getImplementation().setDescription(serverConfiguration.getImplementationDescription());
        retVal.setKind(Conformance.ConformanceStatementKind.INSTANCE);
        retVal.getSoftware().setName(serverConfiguration.getServerName());
        retVal.getSoftware().setVersion(serverConfiguration.getServerVersion());
        retVal.addFormat("application/xml+fhir");
        retVal.addFormat("application/json+fhir");
        Conformance.ConformanceRestComponent rest = retVal.addRest();
        rest.setMode(Conformance.RestfulConformanceMode.SERVER);
        HashSet<Conformance.SystemRestfulInteraction> systemOps = new HashSet<Conformance.SystemRestfulInteraction>();
        HashSet<String> operationNames = new HashSet<String>();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings(theRequestDetails);
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            if (!nextEntry.getKey().isEmpty()) {
                HashSet<Conformance.TypeRestfulInteraction> resourceOps = new HashSet<Conformance.TypeRestfulInteraction>();
                Conformance.ConformanceRestResourceComponent resource = rest.addResource();
                String resourceName = nextEntry.getKey();
                RuntimeResourceDefinition def = serverConfiguration.getFhirContext().getResourceDefinition(resourceName);
                resource.getTypeElement().setValue((Object)def.getName());
                ServletContext servletContext = (ServletContext)(theRequest == null ? null : theRequest.getAttribute("ca.uhn.fhir.rest.server.RestfulServer.servlet_context"));
                String serverBase = serverConfiguration.getServerAddressStrategy().determineServerBase(servletContext, theRequest);
                resource.getProfile().setReference(def.getResourceProfile(serverBase));
                TreeSet<String> includes = new TreeSet<String>();
                for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                    String resOpCode;
                    if (nextMethodBinding.getRestOperationType() != null && (resOpCode = nextMethodBinding.getRestOperationType().getCode()) != null) {
                        Conformance.TypeRestfulInteraction resOp;
                        try {
                            resOp = Conformance.TypeRestfulInteraction.fromCode((String)resOpCode);
                        }
                        catch (Exception e) {
                            resOp = null;
                        }
                        if (resOp != null) {
                            if (!resourceOps.contains(resOp)) {
                                resourceOps.add(resOp);
                                resource.addInteraction().setCode(resOp);
                            }
                            if ("vread".equals(resOpCode) && !resourceOps.contains(resOp = Conformance.TypeRestfulInteraction.READ)) {
                                resourceOps.add(resOp);
                                resource.addInteraction().setCode(resOp);
                            }
                            if (nextMethodBinding.isSupportsConditional()) {
                                switch (resOp) {
                                    case CREATE: {
                                        resource.setConditionalCreate(true);
                                        break;
                                    }
                                    case DELETE: {
                                        resource.setConditionalDelete(Conformance.ConditionalDeleteStatus.SINGLE);
                                        break;
                                    }
                                    case UPDATE: {
                                        resource.setConditionalUpdate(true);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                    if (nextMethodBinding instanceof SearchMethodBinding) {
                        this.handleSearchMethodBinding(resource, def, includes, (SearchMethodBinding)nextMethodBinding, theRequestDetails);
                    } else if (nextMethodBinding instanceof OperationMethodBinding) {
                        OperationMethodBinding methodBinding = (OperationMethodBinding)nextMethodBinding;
                        String opName = (String)bindings.getOperationBindingToId().get(methodBinding);
                        if (operationNames.add(opName)) {
                            rest.addOperation().setName(methodBinding.getName()).getDefinition().setReference("OperationDefinition/" + opName);
                        }
                    }
                    Collections.sort(resource.getInteraction(), new Comparator<Conformance.ResourceInteractionComponent>(){

                        @Override
                        public int compare(Conformance.ResourceInteractionComponent theO1, Conformance.ResourceInteractionComponent theO2) {
                            Conformance.TypeRestfulInteraction o1 = theO1.getCode();
                            Conformance.TypeRestfulInteraction o2 = theO2.getCode();
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            if (o2 == null) {
                                return -1;
                            }
                            return o1.ordinal() - o2.ordinal();
                        }
                    });
                }
                for (String nextInclude : includes) {
                    resource.addSearchInclude(nextInclude);
                }
                continue;
            }
            for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                if (!(nextMethodBinding instanceof OperationMethodBinding)) continue;
                OperationMethodBinding methodBinding = (OperationMethodBinding)nextMethodBinding;
                String opName = (String)bindings.getOperationBindingToId().get(methodBinding);
                if (!operationNames.add(opName)) continue;
                rest.addOperation().setName(methodBinding.getName()).getDefinition().setReference("OperationDefinition/" + opName);
            }
        }
        return retVal;
    }

    private DateTimeType conformanceDate(RequestDetails theRequestDetails) {
        IPrimitiveType buildDate = this.getServerConfiguration(theRequestDetails).getConformanceDate();
        if (buildDate != null && buildDate.getValue() != null) {
            try {
                return new DateTimeType(buildDate.getValueAsString());
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return DateTimeType.now();
    }

    private void handleSearchMethodBinding(Conformance.ConformanceRestResourceComponent resource, RuntimeResourceDefinition def, TreeSet<String> includes, SearchMethodBinding searchMethodBinding, RequestDetails theRequestDetails) {
        includes.addAll(searchMethodBinding.getIncludes());
        List params = searchMethodBinding.getParameters();
        ArrayList<SearchParameter> searchParameters = new ArrayList<SearchParameter>();
        for (IParameter iParameter : params) {
            if (!(iParameter instanceof SearchParameter)) continue;
            searchParameters.add((SearchParameter)iParameter);
        }
        this.sortSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            for (SearchParameter searchParameter : searchParameters) {
                RuntimeSearchParam paramDef;
                String nextParamDescription;
                String nextParamName = searchParameter.getName();
                String chain = null;
                String nextParamUnchainedName = nextParamName;
                if (nextParamName.contains(".")) {
                    chain = nextParamName.substring(nextParamName.indexOf(46) + 1);
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (StringUtils.isBlank((CharSequence)(nextParamDescription = searchParameter.getDescription())) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                Conformance.ConformanceRestResourceSearchParamComponent param = resource.addSearchParam();
                param.setName(nextParamUnchainedName);
                if (StringUtils.isNotBlank((CharSequence)chain)) {
                    param.addChain(chain);
                }
                param.setDocumentation(nextParamDescription);
                if (searchParameter.getParamType() != null) {
                    param.getTypeElement().setValueAsString(searchParameter.getParamType().getCode());
                }
                for (Class nextTarget : searchParameter.getDeclaredTypes()) {
                    Enumerations.ResourceType code;
                    RuntimeResourceDefinition targetDef = this.getServerConfiguration(theRequestDetails).getFhirContext().getResourceDefinition(nextTarget);
                    if (targetDef == null) continue;
                    try {
                        code = Enumerations.ResourceType.fromCode((String)targetDef.getName());
                    }
                    catch (Exception e) {
                        code = null;
                    }
                    if (code == null) continue;
                    param.addTarget(code.toCode());
                }
            }
        }
    }

    @Read(type=OperationDefinition.class)
    public OperationDefinition readOperationDefinition(@IdParam IdType theId, RequestDetails theRequestDetails) {
        if (theId == null || !theId.hasIdPart()) {
            throw new ResourceNotFoundException((IIdType)theId);
        }
        List sharedDescriptions = (List)this.getServerConfiguration(theRequestDetails).provideBindings().getOperationIdToBindings().get(theId.getIdPart());
        if (sharedDescriptions == null || sharedDescriptions.isEmpty()) {
            throw new ResourceNotFoundException((IIdType)theId);
        }
        OperationDefinition op = new OperationDefinition();
        op.setStatus(Enumerations.ConformanceResourceStatus.ACTIVE);
        op.setIdempotent(true);
        HashSet<String> inParams = new HashSet<String>();
        HashSet<String> outParams = new HashSet<String>();
        for (OperationMethodBinding sharedDescription : sharedDescriptions) {
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getDescription())) {
                op.setDescription(sharedDescription.getDescription());
            }
            if (!sharedDescription.isIdempotent()) {
                op.setIdempotent(sharedDescription.isIdempotent());
            }
            op.setCode(sharedDescription.getName());
            if (sharedDescription.isCanOperateAtInstanceLevel()) {
                op.setInstance(sharedDescription.isCanOperateAtInstanceLevel());
            }
            if (sharedDescription.isCanOperateAtServerLevel()) {
                op.setSystem(sharedDescription.isCanOperateAtServerLevel());
            }
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getResourceName())) {
                op.addTypeElement().setValue((Object)sharedDescription.getResourceName());
            }
            for (IParameter nextParamUntyped : sharedDescription.getParameters()) {
                if (!(nextParamUntyped instanceof OperationParameter)) continue;
                OperationParameter nextParam = (OperationParameter)nextParamUntyped;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                if (!inParams.add(nextParam.getName())) continue;
                param.setUse(OperationDefinition.OperationParameterUse.IN);
                if (nextParam.getParamType() != null) {
                    param.setType(nextParam.getParamType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
            for (OperationMethodBinding.ReturnType nextParam : sharedDescription.getReturnParams()) {
                if (!outParams.add(nextParam.getName())) continue;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                param.setUse(OperationDefinition.OperationParameterUse.OUT);
                if (nextParam.getType() != null) {
                    param.setType(nextParam.getType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
        }
        return op;
    }

    @Deprecated
    public void setCache(boolean theCache) {
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    private void sortSearchParameters(List<SearchParameter> searchParameters) {
        Collections.sort(searchParameters, new Comparator<SearchParameter>(){

            @Override
            public int compare(SearchParameter theO1, SearchParameter theO2) {
                if (theO1.isRequired() == theO2.isRequired()) {
                    return theO1.getName().compareTo(theO2.getName());
                }
                if (theO1.isRequired()) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

