/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonCreator;
import org.hl7.fhir.r4.formats.JsonCreatorCanonical;
import org.hl7.fhir.r4.formats.JsonCreatorGson;
import org.hl7.fhir.r4.formats.ParserBase;
import org.hl7.fhir.r4.formats.ParserType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public abstract class JsonParserBase
extends ParserBase
implements IParser {
    private static JsonParser parser = new JsonParser();
    protected JsonCreator json;
    private boolean htmlPretty;

    @Override
    public ParserType getType() {
        return ParserType.JSON;
    }

    protected abstract Resource parseResource(JsonObject var1) throws IOException, FHIRFormatError;

    protected abstract Type parseType(JsonObject var1, String var2) throws IOException, FHIRFormatError;

    protected abstract Type parseType(String var1, JsonObject var2) throws IOException, FHIRFormatError;

    protected abstract boolean hasTypeName(JsonObject var1, String var2);

    protected abstract void composeResource(Resource var1) throws IOException;

    protected abstract void composeTypeInner(Type var1) throws IOException;

    @Override
    public Resource parse(InputStream input) throws IOException, FHIRFormatError {
        JsonObject json = this.loadJson(input);
        return this.parseResource(json);
    }

    public Resource parse(JsonObject json) throws FHIRFormatError, IOException {
        return this.parseResource(json);
    }

    @Override
    public Type parseType(InputStream input, String type) throws IOException, FHIRFormatError {
        JsonObject json = this.loadJson(input);
        return this.parseType(json, type);
    }

    @Override
    public void compose(OutputStream stream, Resource resource) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = this.style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : new JsonCreatorGson(osw);
        this.json.setIndent(this.style == IParser.OutputStyle.PRETTY ? "  " : "");
        this.json.beginObject();
        this.composeResource(resource);
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    public void compose(JsonCreator writer, Resource resource) throws IOException {
        this.json = writer;
        this.composeResource(resource);
    }

    @Override
    public void compose(OutputStream stream, Type type, String rootName) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = this.style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : new JsonCreatorGson(osw);
        this.json.setIndent(this.style == IParser.OutputStyle.PRETTY ? "  " : "");
        this.json.beginObject();
        this.composeTypeInner(type);
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    private JsonObject loadJson(InputStream input) throws JsonSyntaxException, IOException {
        return parser.parse(TextFile.streamToString((InputStream)input)).getAsJsonObject();
    }

    protected void parseElementProperties(JsonObject json, Element e) throws IOException, FHIRFormatError {
        if (json != null && json.has("id")) {
            e.setId(json.get("id").getAsString());
        }
        if (!Utilities.noString((String)e.getId())) {
            this.idMap.put(e.getId(), e);
        }
        if (json.has("fhir_comments") && this.handleComments) {
            JsonArray array = json.getAsJsonArray("fhir_comments");
            for (int i = 0; i < array.size(); ++i) {
                e.getFormatCommentsPre().add(array.get(i).getAsString());
            }
        }
    }

    protected XhtmlNode parseXhtml(String value) throws IOException, FHIRFormatError {
        XhtmlParser prsr = new XhtmlParser();
        try {
            return (XhtmlNode)prsr.parse(value, "div").getChildNodes().get(0);
        }
        catch (FHIRFormatError e) {
            throw new FHIRFormatError(e.getMessage(), (Throwable)e);
        }
    }

    protected DomainResource parseDomainResource(JsonObject json) throws FHIRFormatError, IOException {
        return (DomainResource)this.parseResource(json);
    }

    protected void writeNull(String name) throws IOException {
        this.json.nullValue();
    }

    protected void prop(String name, String value) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void prop(String name, Boolean value) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void prop(String name, BigDecimal value) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void prop(String name, Integer value) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void composeXhtml(String name, XhtmlNode html) throws IOException {
        if (!Utilities.noString((String)this.xhtmlMessage)) {
            this.prop(name, "<div>!-- " + this.xhtmlMessage + " --></div>");
        } else {
            XhtmlComposer comp = new XhtmlComposer();
            comp.setPretty(this.htmlPretty);
            comp.setXmlOnly(true);
            this.prop(name, comp.compose(html));
        }
    }

    protected void open(String name) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void close() throws IOException {
        this.json.endObject();
    }

    protected void openArray(String name) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws IOException {
        this.json.endArray();
    }

    protected void openObject(String name) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void closeObject() throws IOException {
        this.json.endObject();
    }

    protected boolean anyHasExtras(List<? extends Element> list) {
        for (Element element : list) {
            if (!element.hasExtension() && Utilities.noString((String)element.getId())) continue;
            return true;
        }
        return false;
    }

    protected boolean makeComments(Element element) {
        return this.handleComments && this.style != IParser.OutputStyle.CANONICAL && (!element.getFormatCommentsPre().isEmpty() || !element.getFormatCommentsPost().isEmpty());
    }

    protected void composeDomainResource(String name, DomainResource e) throws IOException {
        this.openObject(name);
        this.composeResource(e);
        this.close();
    }

    protected abstract void composeType(String var1, Type var2) throws IOException;

    abstract void composeStringCore(String var1, StringType var2, boolean var3) throws IOException;

    protected void composeStringCore(String name, IIdType value, boolean inArray) throws IOException {
        this.composeStringCore(name, new StringType(value.getValue()), inArray);
    }

    abstract void composeStringExtras(String var1, StringType var2, boolean var3) throws IOException;

    protected void composeStringExtras(String name, IIdType value, boolean inArray) throws IOException {
        this.composeStringExtras(name, new StringType(value.getValue()), inArray);
    }

    protected void parseElementProperties(JsonObject theAsJsonObject, IIdType theReferenceElement) throws FHIRFormatError, IOException {
        this.parseElementProperties(theAsJsonObject, (Element)theReferenceElement);
    }

    protected void parseElementProperties(JsonObject theAsJsonObject, IdType theReferenceElement) throws FHIRFormatError, IOException {
        this.parseElementProperties(theAsJsonObject, (Element)theReferenceElement);
    }
}

