/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.formats;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.ParserBase;
import org.hl7.fhir.r4.formats.ParserType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.hl7.fhir.utilities.xml.XMLWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class XmlParserBase
extends ParserBase
implements IParser {
    protected List<String> comments = new ArrayList<String>();
    protected IXMLWriter xml;
    protected boolean htmlPretty;

    @Override
    public ParserType getType() {
        return ParserType.XML;
    }

    protected abstract Resource parseResource(XmlPullParser var1) throws XmlPullParserException, IOException, FHIRFormatError;

    protected abstract Type parseType(XmlPullParser var1, String var2) throws XmlPullParserException, IOException, FHIRFormatError;

    protected abstract void composeType(String var1, Type var2) throws IOException;

    @Override
    public Resource parse(InputStream input) throws IOException, FHIRFormatError {
        try {
            XmlPullParser xpp = this.loadXml(input);
            return this.parse(xpp);
        }
        catch (XmlPullParserException e) {
            throw new FHIRFormatError(e.getMessage(), (Throwable)e);
        }
    }

    public Resource parse(XmlPullParser xpp) throws IOException, FHIRFormatError, XmlPullParserException {
        if (xpp.getNamespace() == null) {
            throw new FHIRFormatError("This does not appear to be a FHIR resource (no namespace '" + xpp.getNamespace() + "') (@ /) " + Integer.toString(xpp.getEventType()));
        }
        if (!xpp.getNamespace().equals("http://hl7.org/fhir")) {
            throw new FHIRFormatError("This does not appear to be a FHIR resource (wrong namespace '" + xpp.getNamespace() + "') (@ /)");
        }
        return this.parseResource(xpp);
    }

    @Override
    public Type parseType(InputStream input, String knownType) throws IOException, FHIRFormatError {
        try {
            XmlPullParser xml = this.loadXml(input);
            return this.parseType(xml, knownType);
        }
        catch (XmlPullParserException e) {
            throw new FHIRFormatError(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void compose(OutputStream stream, Resource resource) throws IOException {
        XMLWriter writer = new XMLWriter(stream, "UTF-8");
        writer.setPretty(this.style == IParser.OutputStyle.PRETTY);
        writer.start();
        this.compose((IXMLWriter)writer, resource, writer.isPretty());
        writer.end();
    }

    public void compose(OutputStream stream, Resource resource, boolean htmlPretty) throws IOException {
        XMLWriter writer = new XMLWriter(stream, "UTF-8");
        writer.setPretty(this.style == IParser.OutputStyle.PRETTY);
        writer.start();
        this.compose((IXMLWriter)writer, resource, htmlPretty);
        writer.end();
    }

    public void compose(OutputStream stream, String rootName, Type type) throws IOException {
        this.xml = new XMLWriter(stream, "UTF-8");
        this.xml.setPretty(this.style == IParser.OutputStyle.PRETTY);
        this.xml.start();
        this.xml.setDefaultNamespace("http://hl7.org/fhir");
        this.composeType(Utilities.noString((String)rootName) ? "value" : rootName, type);
        this.xml.end();
    }

    @Override
    public void compose(OutputStream stream, Type type, String rootName) throws IOException {
        this.xml = new XMLWriter(stream, "UTF-8");
        this.xml.setPretty(this.style == IParser.OutputStyle.PRETTY);
        this.xml.start();
        this.xml.setDefaultNamespace("http://hl7.org/fhir");
        this.composeType(Utilities.noString((String)rootName) ? "value" : rootName, type);
        this.xml.end();
    }

    protected XmlPullParser loadXml(String source) throws UnsupportedEncodingException, XmlPullParserException, IOException {
        return this.loadXml(new ByteArrayInputStream(source.getBytes("UTF-8")));
    }

    protected XmlPullParser loadXml(InputStream stream) throws XmlPullParserException, IOException {
        BufferedInputStream input = new BufferedInputStream(stream);
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-docdecl", false);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput((InputStream)input, "UTF-8");
        this.next(xpp);
        this.nextNoWhitespace(xpp);
        return xpp;
    }

    protected int next(XmlPullParser xpp) throws XmlPullParserException, IOException {
        if (this.handleComments) {
            return xpp.nextToken();
        }
        return xpp.next();
    }

    protected int nextNoWhitespace(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        while (eventType == 4 && xpp.isWhitespace() || eventType == 9 || eventType == 5 || eventType == 7 || eventType == 8 || eventType == 10) {
            if (eventType == 9) {
                this.comments.add(xpp.getText());
            } else if (eventType == 10) {
                throw new XmlPullParserException("DTD declarations are not allowed");
            }
            eventType = this.next(xpp);
        }
        return eventType;
    }

    protected void skipElementWithContent(XmlPullParser xpp) throws XmlPullParserException, IOException {
        while (xpp.getEventType() != 3) {
            this.next(xpp);
            if (xpp.getEventType() != 2) continue;
            this.skipElementWithContent(xpp);
        }
        this.next(xpp);
    }

    protected void skipEmptyElement(XmlPullParser xpp) throws XmlPullParserException, IOException {
        while (xpp.getEventType() != 3) {
            this.next(xpp);
        }
        this.next(xpp);
    }

    protected void parseTypeAttributes(XmlPullParser xpp, Type t) {
        this.parseElementAttributes(xpp, t);
    }

    protected void parseElementAttributes(XmlPullParser xpp, Element e) {
        if (xpp.getAttributeValue(null, "id") != null) {
            e.setId(xpp.getAttributeValue(null, "id"));
            this.idMap.put(e.getId(), e);
        }
        if (!this.comments.isEmpty()) {
            e.getFormatCommentsPre().addAll(this.comments);
            this.comments.clear();
        }
    }

    protected void parseElementClose(Base e) {
        if (!this.comments.isEmpty()) {
            e.getFormatCommentsPost().addAll(this.comments);
            this.comments.clear();
        }
    }

    protected void parseBackboneAttributes(XmlPullParser xpp, Element e) {
        this.parseElementAttributes(xpp, e);
    }

    private String pathForLocation(XmlPullParser xpp) {
        return xpp.getPositionDescription();
    }

    protected void unknownContent(XmlPullParser xpp) throws FHIRFormatError {
        if (!this.isAllowUnknownContent()) {
            throw new FHIRFormatError("Unknown Content " + xpp.getName() + " @ " + this.pathForLocation(xpp));
        }
    }

    protected XhtmlNode parseXhtml(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        XhtmlParser prsr = new XhtmlParser();
        try {
            return prsr.parseHtmlNode(xpp);
        }
        catch (FHIRFormatError e) {
            throw new FHIRFormatError(e.getMessage(), (Throwable)e);
        }
    }

    private String parseString(XmlPullParser xpp) throws XmlPullParserException, FHIRFormatError, IOException {
        StringBuilder res = new StringBuilder();
        this.next(xpp);
        while (xpp.getEventType() == 4 || xpp.getEventType() == 7 || xpp.getEventType() == 6) {
            res.append(xpp.getText());
            this.next(xpp);
        }
        if (xpp.getEventType() != 3) {
            throw new FHIRFormatError("Bad String Structure - parsed " + res.toString() + " now found " + Integer.toString(xpp.getEventType()));
        }
        this.next(xpp);
        return res.length() == 0 ? null : res.toString();
    }

    private int parseInt(XmlPullParser xpp) throws FHIRFormatError, XmlPullParserException, IOException {
        int res = -1;
        String textNode = this.parseString(xpp);
        res = Integer.parseInt(textNode);
        return res;
    }

    protected DomainResource parseDomainResourceContained(XmlPullParser xpp) throws IOException, FHIRFormatError, XmlPullParserException {
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        if (eventType == 2) {
            DomainResource dr = (DomainResource)this.parseResource(xpp);
            this.nextNoWhitespace(xpp);
            this.next(xpp);
            return dr;
        }
        this.unknownContent(xpp);
        return null;
    }

    protected Resource parseResourceContained(XmlPullParser xpp) throws IOException, FHIRFormatError, XmlPullParserException {
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        if (eventType == 2) {
            Resource r = this.parseResource(xpp);
            this.nextNoWhitespace(xpp);
            this.next(xpp);
            return r;
        }
        this.unknownContent(xpp);
        return null;
    }

    public void compose(IXMLWriter writer, Resource resource, boolean htmlPretty) throws IOException {
        this.htmlPretty = htmlPretty;
        this.xml = writer;
        this.xml.setDefaultNamespace("http://hl7.org/fhir");
        this.composeResource(resource);
    }

    protected abstract void composeResource(Resource var1) throws IOException;

    protected void composeElementAttributes(Element element) throws IOException {
        if (this.style != IParser.OutputStyle.CANONICAL) {
            for (String comment : element.getFormatCommentsPre()) {
                this.xml.comment(comment, this.getOutputStyle() == IParser.OutputStyle.PRETTY);
            }
        }
        if (element.getId() != null) {
            this.xml.attribute("id", element.getId());
        }
    }

    protected void composeElementClose(Base base) throws IOException {
        if (this.style != IParser.OutputStyle.CANONICAL) {
            for (String comment : base.getFormatCommentsPost()) {
                this.xml.comment(comment, this.getOutputStyle() == IParser.OutputStyle.PRETTY);
            }
        }
    }

    protected void composeTypeAttributes(Type type) throws IOException {
        this.composeElementAttributes(type);
    }

    protected void composeXhtml(String name, XhtmlNode html) throws IOException {
        if (!Utilities.noString((String)this.xhtmlMessage)) {
            this.xml.enter("http://www.w3.org/1999/xhtml", name);
            this.xml.comment(this.xhtmlMessage, false);
            this.xml.exit("http://www.w3.org/1999/xhtml", name);
        } else {
            XhtmlComposer comp = new XhtmlComposer();
            boolean oldPretty = this.xml.isPretty();
            this.xml.setPretty(this.htmlPretty);
            comp.setXmlOnly(true);
            if (html.getNodeType() != NodeType.Text && html.getNsDecl() == null) {
                this.xml.namespace("http://www.w3.org/1999/xhtml", null);
            }
            comp.compose(this.xml, html);
            this.xml.setPretty(oldPretty);
        }
    }

    protected abstract void composeString(String var1, StringType var2) throws IOException;

    protected void composeString(String name, IIdType value) throws IOException {
        this.composeString(name, new StringType(value.getValue()));
    }

    protected void composeDomainResource(String name, DomainResource res) throws IOException {
        this.xml.enter("http://hl7.org/fhir", name);
        this.composeResource(res.getResourceType().toString(), res);
        this.xml.exit("http://hl7.org/fhir", name);
    }

    protected abstract void composeResource(String var1, Resource var2) throws IOException;
}

