/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.fluentpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fluentpath.FluentPathExecutionException;
import ca.uhn.fhir.fluentpath.IFluentPath;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.IValidationSupport;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.utils.FHIRPathEngine;

public class FluentPathR4
implements IFluentPath {
    private FHIRPathEngine myEngine;

    public FluentPathR4(FhirContext theCtx) {
        if (!(theCtx.getValidationSupport() instanceof IValidationSupport)) {
            throw new IllegalStateException("Validation support module configured on context appears to be for the wrong FHIR version- Does not extend " + IValidationSupport.class.getName());
        }
        IValidationSupport validationSupport = (IValidationSupport)theCtx.getValidationSupport();
        this.myEngine = new FHIRPathEngine(new HapiWorkerContext(theCtx, validationSupport));
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
        List<Base> result;
        try {
            result = this.myEngine.evaluate((Base)theInput, thePath);
        }
        catch (FHIRException e) {
            throw new FluentPathExecutionException((Throwable)e);
        }
        for (Base next : result) {
            if (theReturnType.isAssignableFrom(next.getClass())) continue;
            throw new FluentPathExecutionException("FluentPath expression \"" + thePath + "\" returned unexpected type " + next.getClass().getSimpleName() + " - Expected " + theReturnType.getName());
        }
        return result;
    }
}

