/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.ResearchSubject;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AdverseEvent", profile="http://hl7.org/fhir/Profile/AdverseEvent")
public class AdverseEvent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for the event", formalDefinition="The identifier(s) of this adverse event that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected Identifier identifier;
    @Child(name="actuality", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="actual | potential", formalDefinition="Whether the event actually happened, or just had the potential to. Note that this is independent of whether anyone was affected or harmed or how severely.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-actuality")
    protected Enumeration<AdverseEventActuality> actuality;
    @Child(name="category", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ProductProblem | ProductQuality | ProductUseError | WrongDose | IncorrectPrescribingInformation | WrongTechnique | WrongRouteOfAdministration | WrongRate | WrongDuration | WrongTime | ExpiredDrug | MedicalDeviceUseError | ProblemDifferentManufacturer | UnsafePhysicalEnvironment", formalDefinition="The overall type of event, intended for search and filtering purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-category")
    protected Enumeration<AdverseEventCategory> category;
    @Child(name="event", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of the event itself in relation to the subject", formalDefinition="This element defines the specific type of event that occurred or that was prevented from occurring.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-type")
    protected CodeableConcept event;
    @Child(name="subject", type={Patient.class, ResearchSubject.class, Practitioner.class, RelatedPerson.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subject impacted by event", formalDefinition="This subject or group impacted by the event.  With a prospective adverse event, there will be no subject as the adverse event was prevented.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="date", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the event occurred", formalDefinition="The date (and perhaps time) when the adverse event occurred.")
    protected DateTimeType date;
    @Child(name="resultingCondition", type={Condition.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Effect on the subject due to this event", formalDefinition="Includes information about the reaction that occurred as a result of exposure to a substance (for example, a drug or a chemical).")
    protected List<Reference> resultingCondition;
    protected List<Condition> resultingConditionTarget;
    @Child(name="location", type={Location.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Location where adverse event occurred", formalDefinition="The information about where the adverse event occurred.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="seriousness", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Seriousness of the event", formalDefinition="Assessment whether this event was of real importance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-seriousness")
    protected CodeableConcept seriousness;
    @Child(name="severity", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Mild | Moderate | Severe", formalDefinition="Describes the severity of the adverse event, in relation to the subject. Contrast to AdverseEvent.serious - a severe rash may not be serious, but a mild heart problem is.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-severity")
    protected CodeableConcept severity;
    @Child(name="outcome", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="resolved | recovering | ongoing | resolvedWithSequelae | fatal | unknown", formalDefinition="Describes the type of outcome from the adverse event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-outcome")
    protected CodeableConcept outcome;
    @Child(name="recorder", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who recorded the adverse event", formalDefinition="Information on who recorded the adverse event.  May be the patient or a practitioner.")
    protected Reference recorder;
    protected Resource recorderTarget;
    @Child(name="eventParticipant", type={Practitioner.class, Device.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who  was involved in the adverse event or the potential adverse event", formalDefinition="Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g. consultant), information that the Act itself seeks to reveal (e.g. informant of clinical history), or information about what Act was performed (e.g. informant witness).")
    protected Reference eventParticipant;
    protected Resource eventParticipantTarget;
    @Child(name="description", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of the adverse event", formalDefinition="Describes the adverse event in text.")
    protected StringType description;
    @Child(name="suspectEntity", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The suspected agent causing the adverse event", formalDefinition="Describes the entity that is suspected to have caused the adverse event.")
    protected List<AdverseEventSuspectEntityComponent> suspectEntity;
    @Child(name="subjectMedicalHistory", type={Condition.class, Observation.class, AllergyIntolerance.class, FamilyMemberHistory.class, Immunization.class, Procedure.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="AdverseEvent.subjectMedicalHistory", formalDefinition="AdverseEvent.subjectMedicalHistory.")
    protected List<Reference> subjectMedicalHistory;
    protected List<Resource> subjectMedicalHistoryTarget;
    @Child(name="referenceDocument", type={DocumentReference.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="AdverseEvent.referenceDocument", formalDefinition="AdverseEvent.referenceDocument.")
    protected List<Reference> referenceDocument;
    protected List<DocumentReference> referenceDocumentTarget;
    @Child(name="study", type={ResearchStudy.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="AdverseEvent.study", formalDefinition="AdverseEvent.study.")
    protected List<Reference> study;
    protected List<ResearchStudy> studyTarget;
    private static final long serialVersionUID = -1251491657L;
    @SearchParamDefinition(name="date", path="AdverseEvent.date", description="When the event occurred", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="severity", path="AdverseEvent.severity", description="Mild | Moderate | Severe", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="recorder", path="AdverseEvent.recorder", description="Who recorded the adverse event", type="reference", providesMembershipIn={@Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    public static final Include INCLUDE_RECORDER = new Include("AdverseEvent:recorder").toLocked();
    @SearchParamDefinition(name="study", path="AdverseEvent.study", description="AdverseEvent.study", type="reference", target={ResearchStudy.class})
    public static final String SP_STUDY = "study";
    public static final ReferenceClientParam STUDY = new ReferenceClientParam("study");
    public static final Include INCLUDE_STUDY = new Include("AdverseEvent:study").toLocked();
    @SearchParamDefinition(name="actuality", path="AdverseEvent.actuality", description="actual | potential", type="token")
    public static final String SP_ACTUALITY = "actuality";
    public static final TokenClientParam ACTUALITY = new TokenClientParam("actuality");
    @SearchParamDefinition(name="seriousness", path="AdverseEvent.seriousness", description="Seriousness of the event", type="token")
    public static final String SP_SERIOUSNESS = "seriousness";
    public static final TokenClientParam SERIOUSNESS = new TokenClientParam("seriousness");
    @SearchParamDefinition(name="subject", path="AdverseEvent.subject", description="Subject impacted by event", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class, Practitioner.class, RelatedPerson.class, ResearchSubject.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("AdverseEvent:subject").toLocked();
    @SearchParamDefinition(name="resultingcondition", path="AdverseEvent.resultingCondition", description="Effect on the subject due to this event", type="reference", target={Condition.class})
    public static final String SP_RESULTINGCONDITION = "resultingcondition";
    public static final ReferenceClientParam RESULTINGCONDITION = new ReferenceClientParam("resultingcondition");
    public static final Include INCLUDE_RESULTINGCONDITION = new Include("AdverseEvent:resultingcondition").toLocked();
    @SearchParamDefinition(name="substance", path="AdverseEvent.suspectEntity.instance", description="Refers to the specific entity that caused the adverse event", type="reference", target={Device.class, Medication.class, MedicationAdministration.class, MedicationStatement.class, Substance.class})
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_SUBSTANCE = new Include("AdverseEvent:substance").toLocked();
    @SearchParamDefinition(name="location", path="AdverseEvent.location", description="Location where adverse event occurred", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("AdverseEvent:location").toLocked();
    @SearchParamDefinition(name="category", path="AdverseEvent.category", description="ProductProblem | ProductQuality | ProductUseError | WrongDose | IncorrectPrescribingInformation | WrongTechnique | WrongRouteOfAdministration | WrongRate | WrongDuration | WrongTime | ExpiredDrug | MedicalDeviceUseError | ProblemDifferentManufacturer | UnsafePhysicalEnvironment", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="event", path="AdverseEvent.event", description="Type of the event itself in relation to the subject", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");

    public AdverseEvent() {
    }

    public AdverseEvent(Enumeration<AdverseEventActuality> actuality) {
        this.actuality = actuality;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public AdverseEvent setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<AdverseEventActuality> getActualityElement() {
        if (this.actuality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.actuality");
            }
            if (Configuration.doAutoCreate()) {
                this.actuality = new Enumeration<AdverseEventActuality>(new AdverseEventActualityEnumFactory());
            }
        }
        return this.actuality;
    }

    public boolean hasActualityElement() {
        return this.actuality != null && !this.actuality.isEmpty();
    }

    public boolean hasActuality() {
        return this.actuality != null && !this.actuality.isEmpty();
    }

    public AdverseEvent setActualityElement(Enumeration<AdverseEventActuality> value) {
        this.actuality = value;
        return this;
    }

    public AdverseEventActuality getActuality() {
        return this.actuality == null ? null : (AdverseEventActuality)((Object)this.actuality.getValue());
    }

    public AdverseEvent setActuality(AdverseEventActuality value) {
        if (this.actuality == null) {
            this.actuality = new Enumeration<AdverseEventActuality>(new AdverseEventActualityEnumFactory());
        }
        this.actuality.setValue((Object)value);
        return this;
    }

    public Enumeration<AdverseEventCategory> getCategoryElement() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new Enumeration<AdverseEventCategory>(new AdverseEventCategoryEnumFactory());
            }
        }
        return this.category;
    }

    public boolean hasCategoryElement() {
        return this.category != null && !this.category.isEmpty();
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public AdverseEvent setCategoryElement(Enumeration<AdverseEventCategory> value) {
        this.category = value;
        return this;
    }

    public AdverseEventCategory getCategory() {
        return this.category == null ? null : (AdverseEventCategory)((Object)this.category.getValue());
    }

    public AdverseEvent setCategory(AdverseEventCategory value) {
        if (value == null) {
            this.category = null;
        } else {
            if (this.category == null) {
                this.category = new Enumeration<AdverseEventCategory>(new AdverseEventCategoryEnumFactory());
            }
            this.category.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getEvent() {
        if (this.event == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.event");
            }
            if (Configuration.doAutoCreate()) {
                this.event = new CodeableConcept();
            }
        }
        return this.event;
    }

    public boolean hasEvent() {
        return this.event != null && !this.event.isEmpty();
    }

    public AdverseEvent setEvent(CodeableConcept value) {
        this.event = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public AdverseEvent setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public AdverseEvent setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public AdverseEvent setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public AdverseEvent setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<Reference> getResultingCondition() {
        if (this.resultingCondition == null) {
            this.resultingCondition = new ArrayList<Reference>();
        }
        return this.resultingCondition;
    }

    public AdverseEvent setResultingCondition(List<Reference> theResultingCondition) {
        this.resultingCondition = theResultingCondition;
        return this;
    }

    public boolean hasResultingCondition() {
        if (this.resultingCondition == null) {
            return false;
        }
        for (Reference item : this.resultingCondition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResultingCondition() {
        Reference t = new Reference();
        if (this.resultingCondition == null) {
            this.resultingCondition = new ArrayList<Reference>();
        }
        this.resultingCondition.add(t);
        return t;
    }

    public AdverseEvent addResultingCondition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.resultingCondition == null) {
            this.resultingCondition = new ArrayList<Reference>();
        }
        this.resultingCondition.add(t);
        return this;
    }

    public Reference getResultingConditionFirstRep() {
        if (this.getResultingCondition().isEmpty()) {
            this.addResultingCondition();
        }
        return this.getResultingCondition().get(0);
    }

    @Deprecated
    public List<Condition> getResultingConditionTarget() {
        if (this.resultingConditionTarget == null) {
            this.resultingConditionTarget = new ArrayList<Condition>();
        }
        return this.resultingConditionTarget;
    }

    @Deprecated
    public Condition addResultingConditionTarget() {
        Condition r = new Condition();
        if (this.resultingConditionTarget == null) {
            this.resultingConditionTarget = new ArrayList<Condition>();
        }
        this.resultingConditionTarget.add(r);
        return r;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public AdverseEvent setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public AdverseEvent setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public CodeableConcept getSeriousness() {
        if (this.seriousness == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.seriousness");
            }
            if (Configuration.doAutoCreate()) {
                this.seriousness = new CodeableConcept();
            }
        }
        return this.seriousness;
    }

    public boolean hasSeriousness() {
        return this.seriousness != null && !this.seriousness.isEmpty();
    }

    public AdverseEvent setSeriousness(CodeableConcept value) {
        this.seriousness = value;
        return this;
    }

    public CodeableConcept getSeverity() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new CodeableConcept();
            }
        }
        return this.severity;
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public AdverseEvent setSeverity(CodeableConcept value) {
        this.severity = value;
        return this;
    }

    public CodeableConcept getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new CodeableConcept();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public AdverseEvent setOutcome(CodeableConcept value) {
        this.outcome = value;
        return this;
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public AdverseEvent setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public Resource getRecorderTarget() {
        return this.recorderTarget;
    }

    public AdverseEvent setRecorderTarget(Resource value) {
        this.recorderTarget = value;
        return this;
    }

    public Reference getEventParticipant() {
        if (this.eventParticipant == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.eventParticipant");
            }
            if (Configuration.doAutoCreate()) {
                this.eventParticipant = new Reference();
            }
        }
        return this.eventParticipant;
    }

    public boolean hasEventParticipant() {
        return this.eventParticipant != null && !this.eventParticipant.isEmpty();
    }

    public AdverseEvent setEventParticipant(Reference value) {
        this.eventParticipant = value;
        return this;
    }

    public Resource getEventParticipantTarget() {
        return this.eventParticipantTarget;
    }

    public AdverseEvent setEventParticipantTarget(Resource value) {
        this.eventParticipantTarget = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public AdverseEvent setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public AdverseEvent setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<AdverseEventSuspectEntityComponent> getSuspectEntity() {
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        return this.suspectEntity;
    }

    public AdverseEvent setSuspectEntity(List<AdverseEventSuspectEntityComponent> theSuspectEntity) {
        this.suspectEntity = theSuspectEntity;
        return this;
    }

    public boolean hasSuspectEntity() {
        if (this.suspectEntity == null) {
            return false;
        }
        for (AdverseEventSuspectEntityComponent item : this.suspectEntity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventSuspectEntityComponent addSuspectEntity() {
        AdverseEventSuspectEntityComponent t = new AdverseEventSuspectEntityComponent();
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        this.suspectEntity.add(t);
        return t;
    }

    public AdverseEvent addSuspectEntity(AdverseEventSuspectEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        this.suspectEntity.add(t);
        return this;
    }

    public AdverseEventSuspectEntityComponent getSuspectEntityFirstRep() {
        if (this.getSuspectEntity().isEmpty()) {
            this.addSuspectEntity();
        }
        return this.getSuspectEntity().get(0);
    }

    public List<Reference> getSubjectMedicalHistory() {
        if (this.subjectMedicalHistory == null) {
            this.subjectMedicalHistory = new ArrayList<Reference>();
        }
        return this.subjectMedicalHistory;
    }

    public AdverseEvent setSubjectMedicalHistory(List<Reference> theSubjectMedicalHistory) {
        this.subjectMedicalHistory = theSubjectMedicalHistory;
        return this;
    }

    public boolean hasSubjectMedicalHistory() {
        if (this.subjectMedicalHistory == null) {
            return false;
        }
        for (Reference item : this.subjectMedicalHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubjectMedicalHistory() {
        Reference t = new Reference();
        if (this.subjectMedicalHistory == null) {
            this.subjectMedicalHistory = new ArrayList<Reference>();
        }
        this.subjectMedicalHistory.add(t);
        return t;
    }

    public AdverseEvent addSubjectMedicalHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subjectMedicalHistory == null) {
            this.subjectMedicalHistory = new ArrayList<Reference>();
        }
        this.subjectMedicalHistory.add(t);
        return this;
    }

    public Reference getSubjectMedicalHistoryFirstRep() {
        if (this.getSubjectMedicalHistory().isEmpty()) {
            this.addSubjectMedicalHistory();
        }
        return this.getSubjectMedicalHistory().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectMedicalHistoryTarget() {
        if (this.subjectMedicalHistoryTarget == null) {
            this.subjectMedicalHistoryTarget = new ArrayList<Resource>();
        }
        return this.subjectMedicalHistoryTarget;
    }

    public List<Reference> getReferenceDocument() {
        if (this.referenceDocument == null) {
            this.referenceDocument = new ArrayList<Reference>();
        }
        return this.referenceDocument;
    }

    public AdverseEvent setReferenceDocument(List<Reference> theReferenceDocument) {
        this.referenceDocument = theReferenceDocument;
        return this;
    }

    public boolean hasReferenceDocument() {
        if (this.referenceDocument == null) {
            return false;
        }
        for (Reference item : this.referenceDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReferenceDocument() {
        Reference t = new Reference();
        if (this.referenceDocument == null) {
            this.referenceDocument = new ArrayList<Reference>();
        }
        this.referenceDocument.add(t);
        return t;
    }

    public AdverseEvent addReferenceDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.referenceDocument == null) {
            this.referenceDocument = new ArrayList<Reference>();
        }
        this.referenceDocument.add(t);
        return this;
    }

    public Reference getReferenceDocumentFirstRep() {
        if (this.getReferenceDocument().isEmpty()) {
            this.addReferenceDocument();
        }
        return this.getReferenceDocument().get(0);
    }

    @Deprecated
    public List<DocumentReference> getReferenceDocumentTarget() {
        if (this.referenceDocumentTarget == null) {
            this.referenceDocumentTarget = new ArrayList<DocumentReference>();
        }
        return this.referenceDocumentTarget;
    }

    @Deprecated
    public DocumentReference addReferenceDocumentTarget() {
        DocumentReference r = new DocumentReference();
        if (this.referenceDocumentTarget == null) {
            this.referenceDocumentTarget = new ArrayList<DocumentReference>();
        }
        this.referenceDocumentTarget.add(r);
        return r;
    }

    public List<Reference> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        return this.study;
    }

    public AdverseEvent setStudy(List<Reference> theStudy) {
        this.study = theStudy;
        return this;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (Reference item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addStudy() {
        Reference t = new Reference();
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return t;
    }

    public AdverseEvent addStudy(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return this;
    }

    public Reference getStudyFirstRep() {
        if (this.getStudy().isEmpty()) {
            this.addStudy();
        }
        return this.getStudy().get(0);
    }

    @Deprecated
    public List<ResearchStudy> getStudyTarget() {
        if (this.studyTarget == null) {
            this.studyTarget = new ArrayList<ResearchStudy>();
        }
        return this.studyTarget;
    }

    @Deprecated
    public ResearchStudy addStudyTarget() {
        ResearchStudy r = new ResearchStudy();
        if (this.studyTarget == null) {
            this.studyTarget = new ArrayList<ResearchStudy>();
        }
        this.studyTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "The identifier(s) of this adverse event that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier));
        children.add(new Property(SP_ACTUALITY, "code", "Whether the event actually happened, or just had the potential to. Note that this is independent of whether anyone was affected or harmed or how severely.", 0, 1, this.actuality));
        children.add(new Property(SP_CATEGORY, "code", "The overall type of event, intended for search and filtering purposes.", 0, 1, this.category));
        children.add(new Property(SP_EVENT, "CodeableConcept", "This element defines the specific type of event that occurred or that was prevented from occurring.", 0, 1, this.event));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|ResearchSubject|Practitioner|RelatedPerson)", "This subject or group impacted by the event.  With a prospective adverse event, there will be no subject as the adverse event was prevented.", 0, 1, this.subject));
        children.add(new Property(SP_DATE, "dateTime", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.date));
        children.add(new Property("resultingCondition", "Reference(Condition)", "Includes information about the reaction that occurred as a result of exposure to a substance (for example, a drug or a chemical).", 0, Integer.MAX_VALUE, this.resultingCondition));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The information about where the adverse event occurred.", 0, 1, this.location));
        children.add(new Property(SP_SERIOUSNESS, "CodeableConcept", "Assessment whether this event was of real importance.", 0, 1, this.seriousness));
        children.add(new Property(SP_SEVERITY, "CodeableConcept", "Describes the severity of the adverse event, in relation to the subject. Contrast to AdverseEvent.serious - a severe rash may not be serious, but a mild heart problem is.", 0, 1, this.severity));
        children.add(new Property("outcome", "CodeableConcept", "Describes the type of outcome from the adverse event.", 0, 1, this.outcome));
        children.add(new Property(SP_RECORDER, "Reference(Patient|Practitioner|RelatedPerson)", "Information on who recorded the adverse event.  May be the patient or a practitioner.", 0, 1, this.recorder));
        children.add(new Property("eventParticipant", "Reference(Practitioner|Device)", "Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g. consultant), information that the Act itself seeks to reveal (e.g. informant of clinical history), or information about what Act was performed (e.g. informant witness).", 0, 1, this.eventParticipant));
        children.add(new Property("description", "string", "Describes the adverse event in text.", 0, 1, this.description));
        children.add(new Property("suspectEntity", "", "Describes the entity that is suspected to have caused the adverse event.", 0, Integer.MAX_VALUE, this.suspectEntity));
        children.add(new Property("subjectMedicalHistory", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure)", "AdverseEvent.subjectMedicalHistory.", 0, Integer.MAX_VALUE, this.subjectMedicalHistory));
        children.add(new Property("referenceDocument", "Reference(DocumentReference)", "AdverseEvent.referenceDocument.", 0, Integer.MAX_VALUE, this.referenceDocument));
        children.add(new Property(SP_STUDY, "Reference(ResearchStudy)", "AdverseEvent.study.", 0, Integer.MAX_VALUE, this.study));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "The identifier(s) of this adverse event that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier);
            }
            case 528866400: {
                return new Property(SP_ACTUALITY, "code", "Whether the event actually happened, or just had the potential to. Note that this is independent of whether anyone was affected or harmed or how severely.", 0, 1, this.actuality);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "code", "The overall type of event, intended for search and filtering purposes.", 0, 1, this.category);
            }
            case 96891546: {
                return new Property(SP_EVENT, "CodeableConcept", "This element defines the specific type of event that occurred or that was prevented from occurring.", 0, 1, this.event);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|ResearchSubject|Practitioner|RelatedPerson)", "This subject or group impacted by the event.  With a prospective adverse event, there will be no subject as the adverse event was prevented.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.date);
            }
            case -830261258: {
                return new Property("resultingCondition", "Reference(Condition)", "Includes information about the reaction that occurred as a result of exposure to a substance (for example, a drug or a chemical).", 0, Integer.MAX_VALUE, this.resultingCondition);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The information about where the adverse event occurred.", 0, 1, this.location);
            }
            case -1551003909: {
                return new Property(SP_SERIOUSNESS, "CodeableConcept", "Assessment whether this event was of real importance.", 0, 1, this.seriousness);
            }
            case 1478300413: {
                return new Property(SP_SEVERITY, "CodeableConcept", "Describes the severity of the adverse event, in relation to the subject. Contrast to AdverseEvent.serious - a severe rash may not be serious, but a mild heart problem is.", 0, 1, this.severity);
            }
            case -1106507950: {
                return new Property("outcome", "CodeableConcept", "Describes the type of outcome from the adverse event.", 0, 1, this.outcome);
            }
            case -799233858: {
                return new Property(SP_RECORDER, "Reference(Patient|Practitioner|RelatedPerson)", "Information on who recorded the adverse event.  May be the patient or a practitioner.", 0, 1, this.recorder);
            }
            case 270753849: {
                return new Property("eventParticipant", "Reference(Practitioner|Device)", "Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g. consultant), information that the Act itself seeks to reveal (e.g. informant of clinical history), or information about what Act was performed (e.g. informant witness).", 0, 1, this.eventParticipant);
            }
            case -1724546052: {
                return new Property("description", "string", "Describes the adverse event in text.", 0, 1, this.description);
            }
            case -1957422662: {
                return new Property("suspectEntity", "", "Describes the entity that is suspected to have caused the adverse event.", 0, Integer.MAX_VALUE, this.suspectEntity);
            }
            case -1685245681: {
                return new Property("subjectMedicalHistory", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure)", "AdverseEvent.subjectMedicalHistory.", 0, Integer.MAX_VALUE, this.subjectMedicalHistory);
            }
            case 1013971334: {
                return new Property("referenceDocument", "Reference(DocumentReference)", "AdverseEvent.referenceDocument.", 0, Integer.MAX_VALUE, this.referenceDocument);
            }
            case 109776329: {
                return new Property(SP_STUDY, "Reference(ResearchStudy)", "AdverseEvent.study.", 0, Integer.MAX_VALUE, this.study);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 528866400: {
                Base[] baseArray;
                if (this.actuality == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.actuality;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case 96891546: {
                Base[] baseArray;
                if (this.event == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.event;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case -830261258: {
                return this.resultingCondition == null ? new Base[]{} : this.resultingCondition.toArray(new Base[this.resultingCondition.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.location;
                }
                return baseArray;
            }
            case -1551003909: {
                Base[] baseArray;
                if (this.seriousness == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.seriousness;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.severity;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.outcome;
                }
                return baseArray;
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.recorder;
                }
                return baseArray;
            }
            case 270753849: {
                Base[] baseArray;
                if (this.eventParticipant == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.eventParticipant;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.description;
                }
                return baseArray;
            }
            case -1957422662: {
                return this.suspectEntity == null ? new Base[]{} : this.suspectEntity.toArray(new Base[this.suspectEntity.size()]);
            }
            case -1685245681: {
                return this.subjectMedicalHistory == null ? new Base[]{} : this.subjectMedicalHistory.toArray(new Base[this.subjectMedicalHistory.size()]);
            }
            case 1013971334: {
                return this.referenceDocument == null ? new Base[]{} : this.referenceDocument.toArray(new Base[this.referenceDocument.size()]);
            }
            case 109776329: {
                return this.study == null ? new Base[]{} : this.study.toArray(new Base[this.study.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 528866400: {
                value = new AdverseEventActualityEnumFactory().fromType(this.castToCode(value));
                this.actuality = value;
                return value;
            }
            case 50511102: {
                value = new AdverseEventCategoryEnumFactory().fromType(this.castToCode(value));
                this.category = value;
                return value;
            }
            case 96891546: {
                this.event = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case -830261258: {
                this.getResultingCondition().add(this.castToReference(value));
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case -1551003909: {
                this.seriousness = this.castToCodeableConcept(value);
                return value;
            }
            case 1478300413: {
                this.severity = this.castToCodeableConcept(value);
                return value;
            }
            case -1106507950: {
                this.outcome = this.castToCodeableConcept(value);
                return value;
            }
            case -799233858: {
                this.recorder = this.castToReference(value);
                return value;
            }
            case 270753849: {
                this.eventParticipant = this.castToReference(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -1957422662: {
                this.getSuspectEntity().add((AdverseEventSuspectEntityComponent)((Object)value));
                return value;
            }
            case -1685245681: {
                this.getSubjectMedicalHistory().add(this.castToReference(value));
                return value;
            }
            case 1013971334: {
                this.getReferenceDocument().add(this.castToReference(value));
                return value;
            }
            case 109776329: {
                this.getStudy().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_ACTUALITY)) {
            value = new AdverseEventActualityEnumFactory().fromType(this.castToCode(value));
            this.actuality = value;
        } else if (name.equals(SP_CATEGORY)) {
            value = new AdverseEventCategoryEnumFactory().fromType(this.castToCode(value));
            this.category = value;
        } else if (name.equals(SP_EVENT)) {
            this.event = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("resultingCondition")) {
            this.getResultingCondition().add(this.castToReference(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals(SP_SERIOUSNESS)) {
            this.seriousness = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SEVERITY)) {
            this.severity = this.castToCodeableConcept(value);
        } else if (name.equals("outcome")) {
            this.outcome = this.castToCodeableConcept(value);
        } else if (name.equals(SP_RECORDER)) {
            this.recorder = this.castToReference(value);
        } else if (name.equals("eventParticipant")) {
            this.eventParticipant = this.castToReference(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("suspectEntity")) {
            this.getSuspectEntity().add((AdverseEventSuspectEntityComponent)((Object)value));
        } else if (name.equals("subjectMedicalHistory")) {
            this.getSubjectMedicalHistory().add(this.castToReference(value));
        } else if (name.equals("referenceDocument")) {
            this.getReferenceDocument().add(this.castToReference(value));
        } else if (name.equals(SP_STUDY)) {
            this.getStudy().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 528866400: {
                return this.getActualityElement();
            }
            case 50511102: {
                return this.getCategoryElement();
            }
            case 96891546: {
                return this.getEvent();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -830261258: {
                return this.addResultingCondition();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1551003909: {
                return this.getSeriousness();
            }
            case 1478300413: {
                return this.getSeverity();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case -799233858: {
                return this.getRecorder();
            }
            case 270753849: {
                return this.getEventParticipant();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1957422662: {
                return this.addSuspectEntity();
            }
            case -1685245681: {
                return this.addSubjectMedicalHistory();
            }
            case 1013971334: {
                return this.addReferenceDocument();
            }
            case 109776329: {
                return this.addStudy();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 528866400: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"code"};
            }
            case 96891546: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -830261258: {
                return new String[]{"Reference"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1551003909: {
                return new String[]{"CodeableConcept"};
            }
            case 1478300413: {
                return new String[]{"CodeableConcept"};
            }
            case -1106507950: {
                return new String[]{"CodeableConcept"};
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case 270753849: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1957422662: {
                return new String[0];
            }
            case -1685245681: {
                return new String[]{"Reference"};
            }
            case 1013971334: {
                return new String[]{"Reference"};
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_ACTUALITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type AdverseEvent.actuality");
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a primitive type AdverseEvent.category");
        }
        if (name.equals(SP_EVENT)) {
            this.event = new CodeableConcept();
            return this.event;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type AdverseEvent.date");
        }
        if (name.equals("resultingCondition")) {
            return this.addResultingCondition();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_SERIOUSNESS)) {
            this.seriousness = new CodeableConcept();
            return this.seriousness;
        }
        if (name.equals(SP_SEVERITY)) {
            this.severity = new CodeableConcept();
            return this.severity;
        }
        if (name.equals("outcome")) {
            this.outcome = new CodeableConcept();
            return this.outcome;
        }
        if (name.equals(SP_RECORDER)) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals("eventParticipant")) {
            this.eventParticipant = new Reference();
            return this.eventParticipant;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type AdverseEvent.description");
        }
        if (name.equals("suspectEntity")) {
            return this.addSuspectEntity();
        }
        if (name.equals("subjectMedicalHistory")) {
            return this.addSubjectMedicalHistory();
        }
        if (name.equals("referenceDocument")) {
            return this.addReferenceDocument();
        }
        if (name.equals(SP_STUDY)) {
            return this.addStudy();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AdverseEvent";
    }

    @Override
    public AdverseEvent copy() {
        AdverseEvent dst = new AdverseEvent();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.actuality = this.actuality == null ? null : this.actuality.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.event = this.event == null ? null : this.event.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.resultingCondition != null) {
            dst.resultingCondition = new ArrayList<Reference>();
            for (Reference reference : this.resultingCondition) {
                dst.resultingCondition.add(reference.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        dst.seriousness = this.seriousness == null ? null : this.seriousness.copy();
        dst.severity = this.severity == null ? null : this.severity.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.recorder = this.recorder == null ? null : this.recorder.copy();
        dst.eventParticipant = this.eventParticipant == null ? null : this.eventParticipant.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.suspectEntity != null) {
            dst.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
            for (AdverseEventSuspectEntityComponent adverseEventSuspectEntityComponent : this.suspectEntity) {
                dst.suspectEntity.add(adverseEventSuspectEntityComponent.copy());
            }
        }
        if (this.subjectMedicalHistory != null) {
            dst.subjectMedicalHistory = new ArrayList<Reference>();
            for (Reference reference : this.subjectMedicalHistory) {
                dst.subjectMedicalHistory.add(reference.copy());
            }
        }
        if (this.referenceDocument != null) {
            dst.referenceDocument = new ArrayList<Reference>();
            for (Reference reference : this.referenceDocument) {
                dst.referenceDocument.add(reference.copy());
            }
        }
        if (this.study != null) {
            dst.study = new ArrayList<Reference>();
            for (Reference reference : this.study) {
                dst.study.add(reference.copy());
            }
        }
        return dst;
    }

    protected AdverseEvent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof AdverseEvent)) {
            return false;
        }
        AdverseEvent o = (AdverseEvent)other;
        return AdverseEvent.compareDeep(this.identifier, o.identifier, true) && AdverseEvent.compareDeep(this.actuality, o.actuality, true) && AdverseEvent.compareDeep(this.category, o.category, true) && AdverseEvent.compareDeep(this.event, o.event, true) && AdverseEvent.compareDeep(this.subject, o.subject, true) && AdverseEvent.compareDeep(this.date, o.date, true) && AdverseEvent.compareDeep(this.resultingCondition, o.resultingCondition, true) && AdverseEvent.compareDeep(this.location, o.location, true) && AdverseEvent.compareDeep(this.seriousness, o.seriousness, true) && AdverseEvent.compareDeep(this.severity, o.severity, true) && AdverseEvent.compareDeep(this.outcome, o.outcome, true) && AdverseEvent.compareDeep(this.recorder, o.recorder, true) && AdverseEvent.compareDeep(this.eventParticipant, o.eventParticipant, true) && AdverseEvent.compareDeep(this.description, o.description, true) && AdverseEvent.compareDeep(this.suspectEntity, o.suspectEntity, true) && AdverseEvent.compareDeep(this.subjectMedicalHistory, o.subjectMedicalHistory, true) && AdverseEvent.compareDeep(this.referenceDocument, o.referenceDocument, true) && AdverseEvent.compareDeep(this.study, o.study, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof AdverseEvent)) {
            return false;
        }
        AdverseEvent o = (AdverseEvent)other;
        return AdverseEvent.compareValues(this.actuality, o.actuality, true) && AdverseEvent.compareValues(this.category, o.category, true) && AdverseEvent.compareValues(this.date, o.date, true) && AdverseEvent.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.actuality, this.category, this.event, this.subject, this.date, this.resultingCondition, this.location, this.seriousness, this.severity, this.outcome, this.recorder, this.eventParticipant, this.description, this.suspectEntity, this.subjectMedicalHistory, this.referenceDocument, this.study});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AdverseEvent;
    }

    @Block
    public static class AdverseEventSuspectEntityCausalityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="assessment", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Assessment of if the entity caused the event", formalDefinition="Assessment of if the entity caused the event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-assess")
        protected CodeableConcept assessment;
        @Child(name="productRelatedness", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="AdverseEvent.suspectEntity.causalityProductRelatedness", formalDefinition="AdverseEvent.suspectEntity.causalityProductRelatedness.")
        protected StringType productRelatedness;
        @Child(name="author", type={Practitioner.class, PractitionerRole.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="AdverseEvent.suspectEntity.causalityAuthor", formalDefinition="AdverseEvent.suspectEntity.causalityAuthor.")
        protected Reference author;
        protected Resource authorTarget;
        @Child(name="method", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="ProbabilityScale | Bayesian | Checklist", formalDefinition="ProbabilityScale | Bayesian | Checklist.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-method")
        protected CodeableConcept method;
        private static final long serialVersionUID = -1847234837L;

        public CodeableConcept getAssessment() {
            if (this.assessment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityCausalityComponent.assessment");
                }
                if (Configuration.doAutoCreate()) {
                    this.assessment = new CodeableConcept();
                }
            }
            return this.assessment;
        }

        public boolean hasAssessment() {
            return this.assessment != null && !this.assessment.isEmpty();
        }

        public AdverseEventSuspectEntityCausalityComponent setAssessment(CodeableConcept value) {
            this.assessment = value;
            return this;
        }

        public StringType getProductRelatednessElement() {
            if (this.productRelatedness == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityCausalityComponent.productRelatedness");
                }
                if (Configuration.doAutoCreate()) {
                    this.productRelatedness = new StringType();
                }
            }
            return this.productRelatedness;
        }

        public boolean hasProductRelatednessElement() {
            return this.productRelatedness != null && !this.productRelatedness.isEmpty();
        }

        public boolean hasProductRelatedness() {
            return this.productRelatedness != null && !this.productRelatedness.isEmpty();
        }

        public AdverseEventSuspectEntityCausalityComponent setProductRelatednessElement(StringType value) {
            this.productRelatedness = value;
            return this;
        }

        public String getProductRelatedness() {
            return this.productRelatedness == null ? null : (String)this.productRelatedness.getValue();
        }

        public AdverseEventSuspectEntityCausalityComponent setProductRelatedness(String value) {
            if (Utilities.noString((String)value)) {
                this.productRelatedness = null;
            } else {
                if (this.productRelatedness == null) {
                    this.productRelatedness = new StringType();
                }
                this.productRelatedness.setValue(value);
            }
            return this;
        }

        public Reference getAuthor() {
            if (this.author == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityCausalityComponent.author");
                }
                if (Configuration.doAutoCreate()) {
                    this.author = new Reference();
                }
            }
            return this.author;
        }

        public boolean hasAuthor() {
            return this.author != null && !this.author.isEmpty();
        }

        public AdverseEventSuspectEntityCausalityComponent setAuthor(Reference value) {
            this.author = value;
            return this;
        }

        public Resource getAuthorTarget() {
            return this.authorTarget;
        }

        public AdverseEventSuspectEntityCausalityComponent setAuthorTarget(Resource value) {
            this.authorTarget = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityCausalityComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public AdverseEventSuspectEntityCausalityComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("assessment", "CodeableConcept", "Assessment of if the entity caused the event.", 0, 1, this.assessment));
            children.add(new Property("productRelatedness", "string", "AdverseEvent.suspectEntity.causalityProductRelatedness.", 0, 1, this.productRelatedness));
            children.add(new Property("author", "Reference(Practitioner|PractitionerRole)", "AdverseEvent.suspectEntity.causalityAuthor.", 0, 1, this.author));
            children.add(new Property("method", "CodeableConcept", "ProbabilityScale | Bayesian | Checklist.", 0, 1, this.method));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2119382722: {
                    return new Property("assessment", "CodeableConcept", "Assessment of if the entity caused the event.", 0, 1, this.assessment);
                }
                case 1824577683: {
                    return new Property("productRelatedness", "string", "AdverseEvent.suspectEntity.causalityProductRelatedness.", 0, 1, this.productRelatedness);
                }
                case -1406328437: {
                    return new Property("author", "Reference(Practitioner|PractitionerRole)", "AdverseEvent.suspectEntity.causalityAuthor.", 0, 1, this.author);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "ProbabilityScale | Bayesian | Checklist.", 0, 1, this.method);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 2119382722: {
                    Base[] baseArray;
                    if (this.assessment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.assessment;
                    }
                    return baseArray;
                }
                case 1824577683: {
                    Base[] baseArray;
                    if (this.productRelatedness == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productRelatedness;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    Base[] baseArray;
                    if (this.author == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.author;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.method;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 2119382722: {
                    this.assessment = this.castToCodeableConcept(value);
                    return value;
                }
                case 1824577683: {
                    this.productRelatedness = this.castToString(value);
                    return value;
                }
                case -1406328437: {
                    this.author = this.castToReference(value);
                    return value;
                }
                case -1077554975: {
                    this.method = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("assessment")) {
                this.assessment = this.castToCodeableConcept(value);
            } else if (name.equals("productRelatedness")) {
                this.productRelatedness = this.castToString(value);
            } else if (name.equals("author")) {
                this.author = this.castToReference(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2119382722: {
                    return this.getAssessment();
                }
                case 1824577683: {
                    return this.getProductRelatednessElement();
                }
                case -1406328437: {
                    return this.getAuthor();
                }
                case -1077554975: {
                    return this.getMethod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2119382722: {
                    return new String[]{"CodeableConcept"};
                }
                case 1824577683: {
                    return new String[]{"string"};
                }
                case -1406328437: {
                    return new String[]{"Reference"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("assessment")) {
                this.assessment = new CodeableConcept();
                return this.assessment;
            }
            if (name.equals("productRelatedness")) {
                throw new FHIRException("Cannot call addChild on a primitive type AdverseEvent.productRelatedness");
            }
            if (name.equals("author")) {
                this.author = new Reference();
                return this.author;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventSuspectEntityCausalityComponent copy() {
            AdverseEventSuspectEntityCausalityComponent dst = new AdverseEventSuspectEntityCausalityComponent();
            this.copyValues(dst);
            dst.assessment = this.assessment == null ? null : this.assessment.copy();
            dst.productRelatedness = this.productRelatedness == null ? null : this.productRelatedness.copy();
            dst.author = this.author == null ? null : this.author.copy();
            dst.method = this.method == null ? null : this.method.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AdverseEventSuspectEntityCausalityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityCausalityComponent o = (AdverseEventSuspectEntityCausalityComponent)other;
            return AdverseEventSuspectEntityCausalityComponent.compareDeep(this.assessment, o.assessment, true) && AdverseEventSuspectEntityCausalityComponent.compareDeep(this.productRelatedness, o.productRelatedness, true) && AdverseEventSuspectEntityCausalityComponent.compareDeep(this.author, o.author, true) && AdverseEventSuspectEntityCausalityComponent.compareDeep(this.method, o.method, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AdverseEventSuspectEntityCausalityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityCausalityComponent o = (AdverseEventSuspectEntityCausalityComponent)other;
            return AdverseEventSuspectEntityCausalityComponent.compareValues(this.productRelatedness, o.productRelatedness, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.assessment, this.productRelatedness, this.author, this.method});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.suspectEntity.causality";
        }
    }

    @Block
    public static class AdverseEventSuspectEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="instance", type={Substance.class, Medication.class, MedicationAdministration.class, MedicationStatement.class, Device.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Refers to the specific entity that caused the adverse event", formalDefinition="Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.")
        protected Reference instance;
        protected Resource instanceTarget;
        @Child(name="causality", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Information on the possible cause of the event", formalDefinition="Information on the possible cause of the event.")
        protected List<AdverseEventSuspectEntityCausalityComponent> causality;
        private static final long serialVersionUID = 1245759325L;

        public AdverseEventSuspectEntityComponent() {
        }

        public AdverseEventSuspectEntityComponent(Reference instance) {
            this.instance = instance;
        }

        public Reference getInstance() {
            if (this.instance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.instance");
                }
                if (Configuration.doAutoCreate()) {
                    this.instance = new Reference();
                }
            }
            return this.instance;
        }

        public boolean hasInstance() {
            return this.instance != null && !this.instance.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setInstance(Reference value) {
            this.instance = value;
            return this;
        }

        public Resource getInstanceTarget() {
            return this.instanceTarget;
        }

        public AdverseEventSuspectEntityComponent setInstanceTarget(Resource value) {
            this.instanceTarget = value;
            return this;
        }

        public List<AdverseEventSuspectEntityCausalityComponent> getCausality() {
            if (this.causality == null) {
                this.causality = new ArrayList<AdverseEventSuspectEntityCausalityComponent>();
            }
            return this.causality;
        }

        public AdverseEventSuspectEntityComponent setCausality(List<AdverseEventSuspectEntityCausalityComponent> theCausality) {
            this.causality = theCausality;
            return this;
        }

        public boolean hasCausality() {
            if (this.causality == null) {
                return false;
            }
            for (AdverseEventSuspectEntityCausalityComponent item : this.causality) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdverseEventSuspectEntityCausalityComponent addCausality() {
            AdverseEventSuspectEntityCausalityComponent t = new AdverseEventSuspectEntityCausalityComponent();
            if (this.causality == null) {
                this.causality = new ArrayList<AdverseEventSuspectEntityCausalityComponent>();
            }
            this.causality.add(t);
            return t;
        }

        public AdverseEventSuspectEntityComponent addCausality(AdverseEventSuspectEntityCausalityComponent t) {
            if (t == null) {
                return this;
            }
            if (this.causality == null) {
                this.causality = new ArrayList<AdverseEventSuspectEntityCausalityComponent>();
            }
            this.causality.add(t);
            return this;
        }

        public AdverseEventSuspectEntityCausalityComponent getCausalityFirstRep() {
            if (this.getCausality().isEmpty()) {
                this.addCausality();
            }
            return this.getCausality().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("instance", "Reference(Substance|Medication|MedicationAdministration|MedicationStatement|Device)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance));
            children.add(new Property("causality", "", "Information on the possible cause of the event.", 0, Integer.MAX_VALUE, this.causality));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 555127957: {
                    return new Property("instance", "Reference(Substance|Medication|MedicationAdministration|MedicationStatement|Device)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance);
                }
                case -1446450521: {
                    return new Property("causality", "", "Information on the possible cause of the event.", 0, Integer.MAX_VALUE, this.causality);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    Base[] baseArray;
                    if (this.instance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.instance;
                    }
                    return baseArray;
                }
                case -1446450521: {
                    return this.causality == null ? new Base[]{} : this.causality.toArray(new Base[this.causality.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    this.instance = this.castToReference(value);
                    return value;
                }
                case -1446450521: {
                    this.getCausality().add((AdverseEventSuspectEntityCausalityComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("instance")) {
                this.instance = this.castToReference(value);
            } else if (name.equals("causality")) {
                this.getCausality().add((AdverseEventSuspectEntityCausalityComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    return this.getInstance();
                }
                case -1446450521: {
                    return this.addCausality();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    return new String[]{"Reference"};
                }
                case -1446450521: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("instance")) {
                this.instance = new Reference();
                return this.instance;
            }
            if (name.equals("causality")) {
                return this.addCausality();
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventSuspectEntityComponent copy() {
            AdverseEventSuspectEntityComponent dst = new AdverseEventSuspectEntityComponent();
            this.copyValues(dst);
            Reference reference = dst.instance = this.instance == null ? null : this.instance.copy();
            if (this.causality != null) {
                dst.causality = new ArrayList<AdverseEventSuspectEntityCausalityComponent>();
                for (AdverseEventSuspectEntityCausalityComponent i : this.causality) {
                    dst.causality.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AdverseEventSuspectEntityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityComponent o = (AdverseEventSuspectEntityComponent)other;
            return AdverseEventSuspectEntityComponent.compareDeep(this.instance, o.instance, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causality, o.causality, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AdverseEventSuspectEntityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityComponent o = (AdverseEventSuspectEntityComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.instance, this.causality});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.suspectEntity";
        }
    }

    public static class AdverseEventCategoryEnumFactory
    implements EnumFactory<AdverseEventCategory> {
        @Override
        public AdverseEventCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ProductProblem".equals(codeString)) {
                return AdverseEventCategory.PRODUCTPROBLEM;
            }
            if ("ProductQuality".equals(codeString)) {
                return AdverseEventCategory.PRODUCTQUALITY;
            }
            if ("ProductUseError".equals(codeString)) {
                return AdverseEventCategory.PRODUCTUSEERROR;
            }
            if ("WrongDose".equals(codeString)) {
                return AdverseEventCategory.WRONGDOSE;
            }
            if ("IncorrectPrescribingInformation".equals(codeString)) {
                return AdverseEventCategory.INCORRECTPRESCRIBINGINFORMATION;
            }
            if ("WrongTechnique".equals(codeString)) {
                return AdverseEventCategory.WRONGTECHNIQUE;
            }
            if ("WrongRouteOfAdministration".equals(codeString)) {
                return AdverseEventCategory.WRONGROUTEOFADMINISTRATION;
            }
            if ("WrongRate".equals(codeString)) {
                return AdverseEventCategory.WRONGRATE;
            }
            if ("WrongDuration".equals(codeString)) {
                return AdverseEventCategory.WRONGDURATION;
            }
            if ("WrongTime".equals(codeString)) {
                return AdverseEventCategory.WRONGTIME;
            }
            if ("ExpiredDrug".equals(codeString)) {
                return AdverseEventCategory.EXPIREDDRUG;
            }
            if ("MedicalDeviceUseError".equals(codeString)) {
                return AdverseEventCategory.MEDICALDEVICEUSEERROR;
            }
            if ("ProblemDifferentManufacturer".equals(codeString)) {
                return AdverseEventCategory.PROBLEMDIFFERENTMANUFACTURER;
            }
            if ("UnsafePhysicalEnvironment".equals(codeString)) {
                return AdverseEventCategory.UNSAFEPHYSICALENVIRONMENT;
            }
            throw new IllegalArgumentException("Unknown AdverseEventCategory code '" + codeString + "'");
        }

        public Enumeration<AdverseEventCategory> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AdverseEventCategory>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ProductProblem".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.PRODUCTPROBLEM);
            }
            if ("ProductQuality".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.PRODUCTQUALITY);
            }
            if ("ProductUseError".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.PRODUCTUSEERROR);
            }
            if ("WrongDose".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.WRONGDOSE);
            }
            if ("IncorrectPrescribingInformation".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.INCORRECTPRESCRIBINGINFORMATION);
            }
            if ("WrongTechnique".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.WRONGTECHNIQUE);
            }
            if ("WrongRouteOfAdministration".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.WRONGROUTEOFADMINISTRATION);
            }
            if ("WrongRate".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.WRONGRATE);
            }
            if ("WrongDuration".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.WRONGDURATION);
            }
            if ("WrongTime".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.WRONGTIME);
            }
            if ("ExpiredDrug".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.EXPIREDDRUG);
            }
            if ("MedicalDeviceUseError".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.MEDICALDEVICEUSEERROR);
            }
            if ("ProblemDifferentManufacturer".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.PROBLEMDIFFERENTMANUFACTURER);
            }
            if ("UnsafePhysicalEnvironment".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.UNSAFEPHYSICALENVIRONMENT);
            }
            throw new FHIRException("Unknown AdverseEventCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(AdverseEventCategory code) {
            if (code == AdverseEventCategory.PRODUCTPROBLEM) {
                return "ProductProblem";
            }
            if (code == AdverseEventCategory.PRODUCTQUALITY) {
                return "ProductQuality";
            }
            if (code == AdverseEventCategory.PRODUCTUSEERROR) {
                return "ProductUseError";
            }
            if (code == AdverseEventCategory.WRONGDOSE) {
                return "WrongDose";
            }
            if (code == AdverseEventCategory.INCORRECTPRESCRIBINGINFORMATION) {
                return "IncorrectPrescribingInformation";
            }
            if (code == AdverseEventCategory.WRONGTECHNIQUE) {
                return "WrongTechnique";
            }
            if (code == AdverseEventCategory.WRONGROUTEOFADMINISTRATION) {
                return "WrongRouteOfAdministration";
            }
            if (code == AdverseEventCategory.WRONGRATE) {
                return "WrongRate";
            }
            if (code == AdverseEventCategory.WRONGDURATION) {
                return "WrongDuration";
            }
            if (code == AdverseEventCategory.WRONGTIME) {
                return "WrongTime";
            }
            if (code == AdverseEventCategory.EXPIREDDRUG) {
                return "ExpiredDrug";
            }
            if (code == AdverseEventCategory.MEDICALDEVICEUSEERROR) {
                return "MedicalDeviceUseError";
            }
            if (code == AdverseEventCategory.PROBLEMDIFFERENTMANUFACTURER) {
                return "ProblemDifferentManufacturer";
            }
            if (code == AdverseEventCategory.UNSAFEPHYSICALENVIRONMENT) {
                return "UnsafePhysicalEnvironment";
            }
            return "?";
        }

        @Override
        public String toSystem(AdverseEventCategory code) {
            return code.getSystem();
        }
    }

    public static enum AdverseEventCategory {
        PRODUCTPROBLEM,
        PRODUCTQUALITY,
        PRODUCTUSEERROR,
        WRONGDOSE,
        INCORRECTPRESCRIBINGINFORMATION,
        WRONGTECHNIQUE,
        WRONGROUTEOFADMINISTRATION,
        WRONGRATE,
        WRONGDURATION,
        WRONGTIME,
        EXPIREDDRUG,
        MEDICALDEVICEUSEERROR,
        PROBLEMDIFFERENTMANUFACTURER,
        UNSAFEPHYSICALENVIRONMENT,
        NULL;


        public static AdverseEventCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ProductProblem".equals(codeString)) {
                return PRODUCTPROBLEM;
            }
            if ("ProductQuality".equals(codeString)) {
                return PRODUCTQUALITY;
            }
            if ("ProductUseError".equals(codeString)) {
                return PRODUCTUSEERROR;
            }
            if ("WrongDose".equals(codeString)) {
                return WRONGDOSE;
            }
            if ("IncorrectPrescribingInformation".equals(codeString)) {
                return INCORRECTPRESCRIBINGINFORMATION;
            }
            if ("WrongTechnique".equals(codeString)) {
                return WRONGTECHNIQUE;
            }
            if ("WrongRouteOfAdministration".equals(codeString)) {
                return WRONGROUTEOFADMINISTRATION;
            }
            if ("WrongRate".equals(codeString)) {
                return WRONGRATE;
            }
            if ("WrongDuration".equals(codeString)) {
                return WRONGDURATION;
            }
            if ("WrongTime".equals(codeString)) {
                return WRONGTIME;
            }
            if ("ExpiredDrug".equals(codeString)) {
                return EXPIREDDRUG;
            }
            if ("MedicalDeviceUseError".equals(codeString)) {
                return MEDICALDEVICEUSEERROR;
            }
            if ("ProblemDifferentManufacturer".equals(codeString)) {
                return PROBLEMDIFFERENTMANUFACTURER;
            }
            if ("UnsafePhysicalEnvironment".equals(codeString)) {
                return UNSAFEPHYSICALENVIRONMENT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AdverseEventCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRODUCTPROBLEM: {
                    return "ProductProblem";
                }
                case PRODUCTQUALITY: {
                    return "ProductQuality";
                }
                case PRODUCTUSEERROR: {
                    return "ProductUseError";
                }
                case WRONGDOSE: {
                    return "WrongDose";
                }
                case INCORRECTPRESCRIBINGINFORMATION: {
                    return "IncorrectPrescribingInformation";
                }
                case WRONGTECHNIQUE: {
                    return "WrongTechnique";
                }
                case WRONGROUTEOFADMINISTRATION: {
                    return "WrongRouteOfAdministration";
                }
                case WRONGRATE: {
                    return "WrongRate";
                }
                case WRONGDURATION: {
                    return "WrongDuration";
                }
                case WRONGTIME: {
                    return "WrongTime";
                }
                case EXPIREDDRUG: {
                    return "ExpiredDrug";
                }
                case MEDICALDEVICEUSEERROR: {
                    return "MedicalDeviceUseError";
                }
                case PROBLEMDIFFERENTMANUFACTURER: {
                    return "ProblemDifferentManufacturer";
                }
                case UNSAFEPHYSICALENVIRONMENT: {
                    return "UnsafePhysicalEnvironment";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRODUCTPROBLEM: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case PRODUCTQUALITY: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case PRODUCTUSEERROR: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case WRONGDOSE: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case INCORRECTPRESCRIBINGINFORMATION: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case WRONGTECHNIQUE: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case WRONGROUTEOFADMINISTRATION: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case WRONGRATE: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case WRONGDURATION: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case WRONGTIME: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case EXPIREDDRUG: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case MEDICALDEVICEUSEERROR: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case PROBLEMDIFFERENTMANUFACTURER: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case UNSAFEPHYSICALENVIRONMENT: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRODUCTPROBLEM: {
                    return "";
                }
                case PRODUCTQUALITY: {
                    return "";
                }
                case PRODUCTUSEERROR: {
                    return "";
                }
                case WRONGDOSE: {
                    return "";
                }
                case INCORRECTPRESCRIBINGINFORMATION: {
                    return "";
                }
                case WRONGTECHNIQUE: {
                    return "";
                }
                case WRONGROUTEOFADMINISTRATION: {
                    return "";
                }
                case WRONGRATE: {
                    return "";
                }
                case WRONGDURATION: {
                    return "";
                }
                case WRONGTIME: {
                    return "";
                }
                case EXPIREDDRUG: {
                    return "";
                }
                case MEDICALDEVICEUSEERROR: {
                    return "";
                }
                case PROBLEMDIFFERENTMANUFACTURER: {
                    return "";
                }
                case UNSAFEPHYSICALENVIRONMENT: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRODUCTPROBLEM: {
                    return "Product Problem";
                }
                case PRODUCTQUALITY: {
                    return "Product Quality";
                }
                case PRODUCTUSEERROR: {
                    return "Product Use Error";
                }
                case WRONGDOSE: {
                    return "Wrong Dose";
                }
                case INCORRECTPRESCRIBINGINFORMATION: {
                    return "Incorrect Prescribing Information";
                }
                case WRONGTECHNIQUE: {
                    return "Wrong Technique";
                }
                case WRONGROUTEOFADMINISTRATION: {
                    return "Wrong Route of Administration";
                }
                case WRONGRATE: {
                    return "Wrong Rate";
                }
                case WRONGDURATION: {
                    return "Wrong Duration";
                }
                case WRONGTIME: {
                    return "Wrong Time";
                }
                case EXPIREDDRUG: {
                    return "Expired Drug";
                }
                case MEDICALDEVICEUSEERROR: {
                    return "Medical Device Use Error";
                }
                case PROBLEMDIFFERENTMANUFACTURER: {
                    return "Problem with Different Manufacturer of Same Medicine";
                }
                case UNSAFEPHYSICALENVIRONMENT: {
                    return "Unsafe Physical Environment";
                }
            }
            return "?";
        }
    }

    public static class AdverseEventActualityEnumFactory
    implements EnumFactory<AdverseEventActuality> {
        @Override
        public AdverseEventActuality fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("actual".equals(codeString)) {
                return AdverseEventActuality.ACTUAL;
            }
            if ("potential".equals(codeString)) {
                return AdverseEventActuality.POTENTIAL;
            }
            throw new IllegalArgumentException("Unknown AdverseEventActuality code '" + codeString + "'");
        }

        public Enumeration<AdverseEventActuality> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AdverseEventActuality>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("actual".equals(codeString)) {
                return new Enumeration<AdverseEventActuality>(this, AdverseEventActuality.ACTUAL);
            }
            if ("potential".equals(codeString)) {
                return new Enumeration<AdverseEventActuality>(this, AdverseEventActuality.POTENTIAL);
            }
            throw new FHIRException("Unknown AdverseEventActuality code '" + codeString + "'");
        }

        @Override
        public String toCode(AdverseEventActuality code) {
            if (code == AdverseEventActuality.ACTUAL) {
                return "actual";
            }
            if (code == AdverseEventActuality.POTENTIAL) {
                return "potential";
            }
            return "?";
        }

        @Override
        public String toSystem(AdverseEventActuality code) {
            return code.getSystem();
        }
    }

    public static enum AdverseEventActuality {
        ACTUAL,
        POTENTIAL,
        NULL;


        public static AdverseEventActuality fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("actual".equals(codeString)) {
                return ACTUAL;
            }
            if ("potential".equals(codeString)) {
                return POTENTIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AdverseEventActuality code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTUAL: {
                    return "actual";
                }
                case POTENTIAL: {
                    return "potential";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTUAL: {
                    return "http://hl7.org/fhir/adverse-event-actuality";
                }
                case POTENTIAL: {
                    return "http://hl7.org/fhir/adverse-event-actuality";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTUAL: {
                    return "";
                }
                case POTENTIAL: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTUAL: {
                    return "Adverse Event";
                }
                case POTENTIAL: {
                    return "Potential Adverse Event";
                }
            }
            return "?";
        }
    }
}

