/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BaseBinary;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;

@ResourceDef(name="Binary", profile="http://hl7.org/fhir/Profile/Binary")
public class Binary
extends BaseBinary
implements IBaseBinary {
    @Child(name="contentType", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="MimeType of the binary content", formalDefinition="MimeType of the binary content represented as a standard MimeType (BCP 13).")
    protected CodeType contentType;
    @Child(name="securityContext", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Access Control Management", formalDefinition="Treat this binary as if it was this other resource for access control purposes.")
    protected Reference securityContext;
    protected Resource securityContextTarget;
    @Child(name="content", type={Base64BinaryType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual content", formalDefinition="The actual content, base64 encoded.")
    protected Base64BinaryType content;
    private static final long serialVersionUID = 1111991335L;
    @SearchParamDefinition(name="contenttype", path="Binary.contentType", description="MimeType of the binary content", type="token")
    public static final String SP_CONTENTTYPE = "contenttype";
    public static final TokenClientParam CONTENTTYPE = new TokenClientParam("contenttype");

    public Binary() {
    }

    public Binary(CodeType contentType, Base64BinaryType content) {
        this.contentType = contentType;
        this.content = content;
    }

    public CodeType getContentTypeElement() {
        if (this.contentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Binary.contentType");
            }
            if (Configuration.doAutoCreate()) {
                this.contentType = new CodeType();
            }
        }
        return this.contentType;
    }

    public boolean hasContentTypeElement() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public Binary setContentTypeElement(CodeType value) {
        this.contentType = value;
        return this;
    }

    public String getContentType() {
        return this.contentType == null ? null : (String)this.contentType.getValue();
    }

    public Binary setContentType(String value) {
        if (this.contentType == null) {
            this.contentType = new CodeType();
        }
        this.contentType.setValue(value);
        return this;
    }

    public Reference getSecurityContext() {
        if (this.securityContext == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Binary.securityContext");
            }
            if (Configuration.doAutoCreate()) {
                this.securityContext = new Reference();
            }
        }
        return this.securityContext;
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null && !this.securityContext.isEmpty();
    }

    public Binary setSecurityContext(Reference value) {
        this.securityContext = value;
        return this;
    }

    public Resource getSecurityContextTarget() {
        return this.securityContextTarget;
    }

    public Binary setSecurityContextTarget(Resource value) {
        this.securityContextTarget = value;
        return this;
    }

    @Override
    public Base64BinaryType getContentElement() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Binary.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Base64BinaryType();
            }
        }
        return this.content;
    }

    public boolean hasContentElement() {
        return this.content != null && !this.content.isEmpty();
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public Binary setContentElement(Base64BinaryType value) {
        this.content = value;
        return this;
    }

    public byte[] getContent() {
        return this.content == null ? null : (byte[])this.content.getValue();
    }

    public Binary setContent(byte[] value) {
        if (this.content == null) {
            this.content = new Base64BinaryType();
        }
        this.content.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("contentType", "code", "MimeType of the binary content represented as a standard MimeType (BCP 13).", 0, 1, this.contentType));
        children.add(new Property("securityContext", "Reference(Any)", "Treat this binary as if it was this other resource for access control purposes.", 0, 1, this.securityContext));
        children.add(new Property("content", "base64Binary", "The actual content, base64 encoded.", 0, 1, this.content));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -389131437: {
                return new Property("contentType", "code", "MimeType of the binary content represented as a standard MimeType (BCP 13).", 0, 1, this.contentType);
            }
            case -1622888881: {
                return new Property("securityContext", "Reference(Any)", "Treat this binary as if it was this other resource for access control purposes.", 0, 1, this.securityContext);
            }
            case 951530617: {
                return new Property("content", "base64Binary", "The actual content, base64 encoded.", 0, 1, this.content);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -389131437: {
                Base[] baseArray;
                if (this.contentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.contentType;
                }
                return baseArray;
            }
            case -1622888881: {
                Base[] baseArray;
                if (this.securityContext == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.securityContext;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.content;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -389131437: {
                this.contentType = this.castToCode(value);
                return value;
            }
            case -1622888881: {
                this.securityContext = this.castToReference(value);
                return value;
            }
            case 951530617: {
                this.content = this.castToBase64Binary(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("contentType")) {
            this.contentType = this.castToCode(value);
        } else if (name.equals("securityContext")) {
            this.securityContext = this.castToReference(value);
        } else if (name.equals("content")) {
            this.content = this.castToBase64Binary(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -389131437: {
                return this.getContentTypeElement();
            }
            case -1622888881: {
                return this.getSecurityContext();
            }
            case 951530617: {
                return this.getContentElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -389131437: {
                return new String[]{"code"};
            }
            case -1622888881: {
                return new String[]{"Reference"};
            }
            case 951530617: {
                return new String[]{"base64Binary"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("contentType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Binary.contentType");
        }
        if (name.equals("securityContext")) {
            this.securityContext = new Reference();
            return this.securityContext;
        }
        if (name.equals("content")) {
            throw new FHIRException("Cannot call addChild on a primitive type Binary.content");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Binary";
    }

    @Override
    public Binary copy() {
        Binary dst = new Binary();
        this.copyValues(dst);
        dst.contentType = this.contentType == null ? null : this.contentType.copy();
        dst.securityContext = this.securityContext == null ? null : this.securityContext.copy();
        dst.content = this.content == null ? null : this.content.copy();
        return dst;
    }

    protected Binary typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Binary)) {
            return false;
        }
        Binary o = (Binary)other;
        return Binary.compareDeep(this.contentType, o.contentType, true) && Binary.compareDeep(this.securityContext, o.securityContext, true) && Binary.compareDeep(this.content, o.content, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Binary)) {
            return false;
        }
        Binary o = (Binary)other;
        return Binary.compareValues(this.contentType, o.contentType, true) && Binary.compareValues(this.content, o.content, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.contentType, this.securityContext, this.content});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Binary;
    }
}

