/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ClaimResponse", profile="http://hl7.org/fhir/Profile/ClaimResponse")
public class ClaimResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Response  number", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<ClaimResponseStatus> status;
    @Child(name="patient", type={Patient.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="created", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="insurer", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance issuing organization", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="requestProvider", type={Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    protected Practitioner requestProviderTarget;
    @Child(name="requestOrganization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference requestOrganization;
    protected Organization requestOrganizationTarget;
    @Child(name="request", type={Claim.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Id of resource triggering adjudication", formalDefinition="Original request resource referrence.")
    protected Reference request;
    protected Claim requestTarget;
    @Child(name="outcome", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="complete | error | partial", formalDefinition="Transaction: error, complete, partial processing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    protected Enumeration<RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="payeeType", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party to be paid any benefits payable", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payeetype")
    protected CodeableConcept payeeType;
    @Child(name="item", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Line items", formalDefinition="The first tier service adjudications for submitted services.")
    protected List<ItemComponent> item;
    @Child(name="addItem", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer added line items", formalDefinition="The first tier service adjudications for payor added services.")
    protected List<AddedItemComponent> addItem;
    @Child(name="error", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing errors", formalDefinition="Mutually exclusive with Services Provided (Item).")
    protected List<ErrorComponent> error;
    @Child(name="totalCost", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Total Cost of service from the Claim", formalDefinition="The total cost of the services reported.")
    protected Money totalCost;
    @Child(name="unallocDeductable", type={Money.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Unallocated deductible", formalDefinition="The amount of deductible applied which was not allocated to any particular service line.")
    protected Money unallocDeductable;
    @Child(name="totalBenefit", type={Money.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Total benefit payable for the Claim", formalDefinition="Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductible).")
    protected Money totalBenefit;
    @Child(name="payment", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment details, if paid", formalDefinition="Payment details for the claim if the claim has been paid.")
    protected PaymentComponent payment;
    @Child(name="reserved", type={Coding.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Funds reserved status", formalDefinition="Status of funds reservation (For provider, for Patient, None).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fundsreserve")
    protected Coding reserved;
    @Child(name="form", type={CodeableConcept.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept form;
    @Child(name="processNote", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing notes", formalDefinition="Note text.")
    protected List<NoteComponent> processNote;
    @Child(name="communicationRequest", type={CommunicationRequest.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request for additional information", formalDefinition="Request for additional supporting or authorizing information, such as: documents, images or resources.")
    protected List<Reference> communicationRequest;
    protected List<CommunicationRequest> communicationRequestTarget;
    @Child(name="insurance", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected List<InsuranceComponent> insurance;
    private static final long serialVersionUID = 676985103L;
    @SearchParamDefinition(name="identifier", path="ClaimResponse.identifier", description="The identity of the claimresponse", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="ClaimResponse.request", description="The claim reference", type="reference", target={Claim.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("ClaimResponse:request").toLocked();
    @SearchParamDefinition(name="disposition", path="ClaimResponse.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="insurer", path="ClaimResponse.insurer", description="The organization who generated this resource", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("ClaimResponse:insurer").toLocked();
    @SearchParamDefinition(name="created", path="ClaimResponse.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="patient", path="ClaimResponse.patient", description="The subject of care.", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ClaimResponse:patient").toLocked();
    @SearchParamDefinition(name="payment-date", path="ClaimResponse.payment.date", description="The expected paymentDate", type="date")
    public static final String SP_PAYMENT_DATE = "payment-date";
    public static final DateClientParam PAYMENT_DATE = new DateClientParam("payment-date");
    @SearchParamDefinition(name="request-provider", path="ClaimResponse.requestProvider", description="The Provider of the claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_REQUEST_PROVIDER = "request-provider";
    public static final ReferenceClientParam REQUEST_PROVIDER = new ReferenceClientParam("request-provider");
    public static final Include INCLUDE_REQUEST_PROVIDER = new Include("ClaimResponse:request-provider").toLocked();
    @SearchParamDefinition(name="outcome", path="ClaimResponse.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="status", path="ClaimResponse.status", description="The status of the claim response", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ClaimResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ClaimResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ClaimResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ClaimResponseStatus>(new ClaimResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ClaimResponse setStatusElement(Enumeration<ClaimResponseStatus> value) {
        this.status = value;
        return this;
    }

    public ClaimResponseStatus getStatus() {
        return this.status == null ? null : (ClaimResponseStatus)((Object)this.status.getValue());
    }

    public ClaimResponse setStatus(ClaimResponseStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ClaimResponseStatus>(new ClaimResponseStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ClaimResponse setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ClaimResponse setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ClaimResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ClaimResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public ClaimResponse setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public ClaimResponse setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public ClaimResponse setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    public Practitioner getRequestProviderTarget() {
        if (this.requestProviderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProviderTarget = new Practitioner();
            }
        }
        return this.requestProviderTarget;
    }

    public ClaimResponse setRequestProviderTarget(Practitioner value) {
        this.requestProviderTarget = value;
        return this;
    }

    public Reference getRequestOrganization() {
        if (this.requestOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganization = new Reference();
            }
        }
        return this.requestOrganization;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public ClaimResponse setRequestOrganization(Reference value) {
        this.requestOrganization = value;
        return this;
    }

    public Organization getRequestOrganizationTarget() {
        if (this.requestOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganizationTarget = new Organization();
            }
        }
        return this.requestOrganizationTarget;
    }

    public ClaimResponse setRequestOrganizationTarget(Organization value) {
        this.requestOrganizationTarget = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public ClaimResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Claim getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new Claim();
            }
        }
        return this.requestTarget;
    }

    public ClaimResponse setRequestTarget(Claim value) {
        this.requestTarget = value;
        return this;
    }

    public Enumeration<RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<RemittanceOutcome>(new RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public ClaimResponse setOutcomeElement(Enumeration<RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public ClaimResponse setOutcome(RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<RemittanceOutcome>(new RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ClaimResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ClaimResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public CodeableConcept getPayeeType() {
        if (this.payeeType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.payeeType");
            }
            if (Configuration.doAutoCreate()) {
                this.payeeType = new CodeableConcept();
            }
        }
        return this.payeeType;
    }

    public boolean hasPayeeType() {
        return this.payeeType != null && !this.payeeType.isEmpty();
    }

    public ClaimResponse setPayeeType(CodeableConcept value) {
        this.payeeType = value;
        return this;
    }

    public List<ItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        return this.item;
    }

    public ClaimResponse setItem(List<ItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemComponent addItem() {
        ItemComponent t = new ItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public ClaimResponse addItem(ItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public ItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<AddedItemComponent> getAddItem() {
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        return this.addItem;
    }

    public ClaimResponse setAddItem(List<AddedItemComponent> theAddItem) {
        this.addItem = theAddItem;
        return this;
    }

    public boolean hasAddItem() {
        if (this.addItem == null) {
            return false;
        }
        for (AddedItemComponent item : this.addItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AddedItemComponent addAddItem() {
        AddedItemComponent t = new AddedItemComponent();
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return t;
    }

    public ClaimResponse addAddItem(AddedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return this;
    }

    public AddedItemComponent getAddItemFirstRep() {
        if (this.getAddItem().isEmpty()) {
            this.addAddItem();
        }
        return this.getAddItem().get(0);
    }

    public List<ErrorComponent> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        return this.error;
    }

    public ClaimResponse setError(List<ErrorComponent> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (ErrorComponent item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ErrorComponent addError() {
        ErrorComponent t = new ErrorComponent();
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        this.error.add(t);
        return t;
    }

    public ClaimResponse addError(ErrorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        this.error.add(t);
        return this;
    }

    public ErrorComponent getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    public Money getTotalCost() {
        if (this.totalCost == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.totalCost");
            }
            if (Configuration.doAutoCreate()) {
                this.totalCost = new Money();
            }
        }
        return this.totalCost;
    }

    public boolean hasTotalCost() {
        return this.totalCost != null && !this.totalCost.isEmpty();
    }

    public ClaimResponse setTotalCost(Money value) {
        this.totalCost = value;
        return this;
    }

    public Money getUnallocDeductable() {
        if (this.unallocDeductable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.unallocDeductable");
            }
            if (Configuration.doAutoCreate()) {
                this.unallocDeductable = new Money();
            }
        }
        return this.unallocDeductable;
    }

    public boolean hasUnallocDeductable() {
        return this.unallocDeductable != null && !this.unallocDeductable.isEmpty();
    }

    public ClaimResponse setUnallocDeductable(Money value) {
        this.unallocDeductable = value;
        return this;
    }

    public Money getTotalBenefit() {
        if (this.totalBenefit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.totalBenefit");
            }
            if (Configuration.doAutoCreate()) {
                this.totalBenefit = new Money();
            }
        }
        return this.totalBenefit;
    }

    public boolean hasTotalBenefit() {
        return this.totalBenefit != null && !this.totalBenefit.isEmpty();
    }

    public ClaimResponse setTotalBenefit(Money value) {
        this.totalBenefit = value;
        return this;
    }

    public PaymentComponent getPayment() {
        if (this.payment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.payment");
            }
            if (Configuration.doAutoCreate()) {
                this.payment = new PaymentComponent();
            }
        }
        return this.payment;
    }

    public boolean hasPayment() {
        return this.payment != null && !this.payment.isEmpty();
    }

    public ClaimResponse setPayment(PaymentComponent value) {
        this.payment = value;
        return this;
    }

    public Coding getReserved() {
        if (this.reserved == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.reserved");
            }
            if (Configuration.doAutoCreate()) {
                this.reserved = new Coding();
            }
        }
        return this.reserved;
    }

    public boolean hasReserved() {
        return this.reserved != null && !this.reserved.isEmpty();
    }

    public ClaimResponse setReserved(Coding value) {
        this.reserved = value;
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ClaimResponse setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public List<NoteComponent> getProcessNote() {
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        return this.processNote;
    }

    public ClaimResponse setProcessNote(List<NoteComponent> theProcessNote) {
        this.processNote = theProcessNote;
        return this;
    }

    public boolean hasProcessNote() {
        if (this.processNote == null) {
            return false;
        }
        for (NoteComponent item : this.processNote) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NoteComponent addProcessNote() {
        NoteComponent t = new NoteComponent();
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return t;
    }

    public ClaimResponse addProcessNote(NoteComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return this;
    }

    public NoteComponent getProcessNoteFirstRep() {
        if (this.getProcessNote().isEmpty()) {
            this.addProcessNote();
        }
        return this.getProcessNote().get(0);
    }

    public List<Reference> getCommunicationRequest() {
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        return this.communicationRequest;
    }

    public ClaimResponse setCommunicationRequest(List<Reference> theCommunicationRequest) {
        this.communicationRequest = theCommunicationRequest;
        return this;
    }

    public boolean hasCommunicationRequest() {
        if (this.communicationRequest == null) {
            return false;
        }
        for (Reference item : this.communicationRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCommunicationRequest() {
        Reference t = new Reference();
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return t;
    }

    public ClaimResponse addCommunicationRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return this;
    }

    public Reference getCommunicationRequestFirstRep() {
        if (this.getCommunicationRequest().isEmpty()) {
            this.addCommunicationRequest();
        }
        return this.getCommunicationRequest().get(0);
    }

    @Deprecated
    public List<CommunicationRequest> getCommunicationRequestTarget() {
        if (this.communicationRequestTarget == null) {
            this.communicationRequestTarget = new ArrayList<CommunicationRequest>();
        }
        return this.communicationRequestTarget;
    }

    @Deprecated
    public CommunicationRequest addCommunicationRequestTarget() {
        CommunicationRequest r = new CommunicationRequest();
        if (this.communicationRequestTarget == null) {
            this.communicationRequestTarget = new ArrayList<CommunicationRequest>();
        }
        this.communicationRequestTarget.add(r);
        return r;
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public ClaimResponse setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public ClaimResponse addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient));
        children.add(new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.insurer));
        children.add(new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider));
        children.add(new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.requestOrganization));
        children.add(new Property(SP_REQUEST, "Reference(Claim)", "Original request resource referrence.", 0, 1, this.request));
        children.add(new Property(SP_OUTCOME, "code", "Transaction: error, complete, partial processing.", 0, 1, this.outcome));
        children.add(new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property("payeeType", "CodeableConcept", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.payeeType));
        children.add(new Property("item", "", "The first tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.item));
        children.add(new Property("addItem", "", "The first tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem));
        children.add(new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error));
        children.add(new Property("totalCost", "Money", "The total cost of the services reported.", 0, 1, this.totalCost));
        children.add(new Property("unallocDeductable", "Money", "The amount of deductible applied which was not allocated to any particular service line.", 0, 1, this.unallocDeductable));
        children.add(new Property("totalBenefit", "Money", "Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductible).", 0, 1, this.totalBenefit));
        children.add(new Property("payment", "", "Payment details for the claim if the claim has been paid.", 0, 1, this.payment));
        children.add(new Property("reserved", "Coding", "Status of funds reservation (For provider, for Patient, None).", 0, 1, this.reserved));
        children.add(new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form));
        children.add(new Property("processNote", "", "Note text.", 0, Integer.MAX_VALUE, this.processNote));
        children.add(new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information, such as: documents, images or resources.", 0, Integer.MAX_VALUE, this.communicationRequest));
        children.add(new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.insurer);
            }
            case 1601527200: {
                return new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider);
            }
            case 599053666: {
                return new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.requestOrganization);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Claim)", "Original request resource referrence.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "code", "Transaction: error, complete, partial processing.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case -316321118: {
                return new Property("payeeType", "CodeableConcept", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.payeeType);
            }
            case 3242771: {
                return new Property("item", "", "The first tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.item);
            }
            case -1148899500: {
                return new Property("addItem", "", "The first tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem);
            }
            case 96784904: {
                return new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error);
            }
            case -577782479: {
                return new Property("totalCost", "Money", "The total cost of the services reported.", 0, 1, this.totalCost);
            }
            case 2096309753: {
                return new Property("unallocDeductable", "Money", "The amount of deductible applied which was not allocated to any particular service line.", 0, 1, this.unallocDeductable);
            }
            case 332332211: {
                return new Property("totalBenefit", "Money", "Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductible).", 0, 1, this.totalBenefit);
            }
            case -786681338: {
                return new Property("payment", "", "Payment details for the claim if the claim has been paid.", 0, 1, this.payment);
            }
            case -350385368: {
                return new Property("reserved", "Coding", "Status of funds reservation (For provider, for Patient, None).", 0, 1, this.reserved);
            }
            case 3148996: {
                return new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form);
            }
            case 202339073: {
                return new Property("processNote", "", "Note text.", 0, Integer.MAX_VALUE, this.processNote);
            }
            case -2071896615: {
                return new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information, such as: documents, images or resources.", 0, Integer.MAX_VALUE, this.communicationRequest);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.created;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.insurer;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.requestProvider;
                }
                return baseArray;
            }
            case 599053666: {
                Base[] baseArray;
                if (this.requestOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.requestOrganization;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.disposition;
                }
                return baseArray;
            }
            case -316321118: {
                Base[] baseArray;
                if (this.payeeType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.payeeType;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
            case -1148899500: {
                return this.addItem == null ? new Base[]{} : this.addItem.toArray(new Base[this.addItem.size()]);
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
            case -577782479: {
                Base[] baseArray;
                if (this.totalCost == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.totalCost;
                }
                return baseArray;
            }
            case 2096309753: {
                Base[] baseArray;
                if (this.unallocDeductable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.unallocDeductable;
                }
                return baseArray;
            }
            case 332332211: {
                Base[] baseArray;
                if (this.totalBenefit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.totalBenefit;
                }
                return baseArray;
            }
            case -786681338: {
                Base[] baseArray;
                if (this.payment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.payment;
                }
                return baseArray;
            }
            case -350385368: {
                Base[] baseArray;
                if (this.reserved == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.reserved;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.form;
                }
                return baseArray;
            }
            case 202339073: {
                return this.processNote == null ? new Base[]{} : this.processNote.toArray(new Base[this.processNote.size()]);
            }
            case -2071896615: {
                return this.communicationRequest == null ? new Base[]{} : this.communicationRequest.toArray(new Base[this.communicationRequest.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ClaimResponseStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case 1601527200: {
                this.requestProvider = this.castToReference(value);
                return value;
            }
            case 599053666: {
                this.requestOrganization = this.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                return value;
            }
            case -316321118: {
                this.payeeType = this.castToCodeableConcept(value);
                return value;
            }
            case 3242771: {
                this.getItem().add((ItemComponent)((Object)value));
                return value;
            }
            case -1148899500: {
                this.getAddItem().add((AddedItemComponent)((Object)value));
                return value;
            }
            case 96784904: {
                this.getError().add((ErrorComponent)((Object)value));
                return value;
            }
            case -577782479: {
                this.totalCost = this.castToMoney(value);
                return value;
            }
            case 2096309753: {
                this.unallocDeductable = this.castToMoney(value);
                return value;
            }
            case 332332211: {
                this.totalBenefit = this.castToMoney(value);
                return value;
            }
            case -786681338: {
                this.payment = (PaymentComponent)((Object)value);
                return value;
            }
            case -350385368: {
                this.reserved = this.castToCoding(value);
                return value;
            }
            case 3148996: {
                this.form = this.castToCodeableConcept(value);
                return value;
            }
            case 202339073: {
                this.getProcessNote().add((NoteComponent)((Object)value));
                return value;
            }
            case -2071896615: {
                this.getCommunicationRequest().add(this.castToReference(value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ClaimResponseStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = this.castToReference(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = this.castToReference(value);
        } else if (name.equals("requestOrganization")) {
            this.requestOrganization = this.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals(SP_OUTCOME)) {
            value = new RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
            this.outcome = value;
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals("payeeType")) {
            this.payeeType = this.castToCodeableConcept(value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemComponent)((Object)value));
        } else if (name.equals("addItem")) {
            this.getAddItem().add((AddedItemComponent)((Object)value));
        } else if (name.equals("error")) {
            this.getError().add((ErrorComponent)((Object)value));
        } else if (name.equals("totalCost")) {
            this.totalCost = this.castToMoney(value);
        } else if (name.equals("unallocDeductable")) {
            this.unallocDeductable = this.castToMoney(value);
        } else if (name.equals("totalBenefit")) {
            this.totalBenefit = this.castToMoney(value);
        } else if (name.equals("payment")) {
            this.payment = (PaymentComponent)((Object)value);
        } else if (name.equals("reserved")) {
            this.reserved = this.castToCoding(value);
        } else if (name.equals("form")) {
            this.form = this.castToCodeableConcept(value);
        } else if (name.equals("processNote")) {
            this.getProcessNote().add((NoteComponent)((Object)value));
        } else if (name.equals("communicationRequest")) {
            this.getCommunicationRequest().add(this.castToReference(value));
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 1601527200: {
                return this.getRequestProvider();
            }
            case 599053666: {
                return this.getRequestOrganization();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case -316321118: {
                return this.getPayeeType();
            }
            case 3242771: {
                return this.addItem();
            }
            case -1148899500: {
                return this.addAddItem();
            }
            case 96784904: {
                return this.addError();
            }
            case -577782479: {
                return this.getTotalCost();
            }
            case 2096309753: {
                return this.getUnallocDeductable();
            }
            case 332332211: {
                return this.getTotalBenefit();
            }
            case -786681338: {
                return this.getPayment();
            }
            case -350385368: {
                return this.getReserved();
            }
            case 3148996: {
                return this.getForm();
            }
            case 202339073: {
                return this.addProcessNote();
            }
            case -2071896615: {
                return this.addCommunicationRequest();
            }
            case 73049818: {
                return this.addInsurance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 1601527200: {
                return new String[]{"Reference"};
            }
            case 599053666: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case -316321118: {
                return new String[]{"CodeableConcept"};
            }
            case 3242771: {
                return new String[0];
            }
            case -1148899500: {
                return new String[0];
            }
            case 96784904: {
                return new String[0];
            }
            case -577782479: {
                return new String[]{"Money"};
            }
            case 2096309753: {
                return new String[]{"Money"};
            }
            case 332332211: {
                return new String[]{"Money"};
            }
            case -786681338: {
                return new String[0];
            }
            case -350385368: {
                return new String[]{"Coding"};
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case 202339073: {
                return new String[0];
            }
            case -2071896615: {
                return new String[]{"Reference"};
            }
            case 73049818: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.status");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.created");
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganization")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.disposition");
        }
        if (name.equals("payeeType")) {
            this.payeeType = new CodeableConcept();
            return this.payeeType;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("addItem")) {
            return this.addAddItem();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        if (name.equals("totalCost")) {
            this.totalCost = new Money();
            return this.totalCost;
        }
        if (name.equals("unallocDeductable")) {
            this.unallocDeductable = new Money();
            return this.unallocDeductable;
        }
        if (name.equals("totalBenefit")) {
            this.totalBenefit = new Money();
            return this.totalBenefit;
        }
        if (name.equals("payment")) {
            this.payment = new PaymentComponent();
            return this.payment;
        }
        if (name.equals("reserved")) {
            this.reserved = new Coding();
            return this.reserved;
        }
        if (name.equals("form")) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("processNote")) {
            return this.addProcessNote();
        }
        if (name.equals("communicationRequest")) {
            return this.addCommunicationRequest();
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClaimResponse";
    }

    @Override
    public ClaimResponse copy() {
        ClaimResponse dst = new ClaimResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        CodeableConcept codeableConcept = dst.payeeType = this.payeeType == null ? null : this.payeeType.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemComponent>();
            for (ItemComponent itemComponent : this.item) {
                dst.item.add(itemComponent.copy());
            }
        }
        if (this.addItem != null) {
            dst.addItem = new ArrayList<AddedItemComponent>();
            for (AddedItemComponent addedItemComponent : this.addItem) {
                dst.addItem.add(addedItemComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<ErrorComponent>();
            for (ErrorComponent errorComponent : this.error) {
                dst.error.add(errorComponent.copy());
            }
        }
        dst.totalCost = this.totalCost == null ? null : this.totalCost.copy();
        dst.unallocDeductable = this.unallocDeductable == null ? null : this.unallocDeductable.copy();
        dst.totalBenefit = this.totalBenefit == null ? null : this.totalBenefit.copy();
        dst.payment = this.payment == null ? null : this.payment.copy();
        dst.reserved = this.reserved == null ? null : this.reserved.copy();
        CodeableConcept codeableConcept2 = dst.form = this.form == null ? null : this.form.copy();
        if (this.processNote != null) {
            dst.processNote = new ArrayList<NoteComponent>();
            for (NoteComponent noteComponent : this.processNote) {
                dst.processNote.add(noteComponent.copy());
            }
        }
        if (this.communicationRequest != null) {
            dst.communicationRequest = new ArrayList<Reference>();
            for (Reference reference : this.communicationRequest) {
                dst.communicationRequest.add(reference.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        return dst;
    }

    protected ClaimResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other;
        return ClaimResponse.compareDeep(this.identifier, o.identifier, true) && ClaimResponse.compareDeep(this.status, o.status, true) && ClaimResponse.compareDeep(this.patient, o.patient, true) && ClaimResponse.compareDeep(this.created, o.created, true) && ClaimResponse.compareDeep(this.insurer, o.insurer, true) && ClaimResponse.compareDeep(this.requestProvider, o.requestProvider, true) && ClaimResponse.compareDeep(this.requestOrganization, o.requestOrganization, true) && ClaimResponse.compareDeep(this.request, o.request, true) && ClaimResponse.compareDeep(this.outcome, o.outcome, true) && ClaimResponse.compareDeep(this.disposition, o.disposition, true) && ClaimResponse.compareDeep(this.payeeType, o.payeeType, true) && ClaimResponse.compareDeep(this.item, o.item, true) && ClaimResponse.compareDeep(this.addItem, o.addItem, true) && ClaimResponse.compareDeep(this.error, o.error, true) && ClaimResponse.compareDeep(this.totalCost, o.totalCost, true) && ClaimResponse.compareDeep(this.unallocDeductable, o.unallocDeductable, true) && ClaimResponse.compareDeep(this.totalBenefit, o.totalBenefit, true) && ClaimResponse.compareDeep(this.payment, o.payment, true) && ClaimResponse.compareDeep(this.reserved, o.reserved, true) && ClaimResponse.compareDeep(this.form, o.form, true) && ClaimResponse.compareDeep(this.processNote, o.processNote, true) && ClaimResponse.compareDeep(this.communicationRequest, o.communicationRequest, true) && ClaimResponse.compareDeep(this.insurance, o.insurance, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other;
        return ClaimResponse.compareValues(this.status, o.status, true) && ClaimResponse.compareValues(this.created, o.created, true) && ClaimResponse.compareValues(this.outcome, o.outcome, true) && ClaimResponse.compareValues(this.disposition, o.disposition, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.patient, this.created, this.insurer, this.requestProvider, this.requestOrganization, this.request, this.outcome, this.disposition, this.payeeType, this.item, this.addItem, this.error, this.totalCost, this.unallocDeductable, this.totalBenefit, this.payment, this.reserved, this.form, this.processNote, this.communicationRequest, this.insurance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClaimResponse;
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance identifier", formalDefinition="A service line item.")
        protected PositiveIntType sequence;
        @Child(name="focal", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is the focal Coverage", formalDefinition="The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="businessArrangement", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business agreement", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
        protected StringType businessArrangement;
        @Child(name="preAuthRef", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pre-Authorization/Determination Reference", formalDefinition="A list of references from the Insurer to which these services pertain.")
        protected List<StringType> preAuthRef;
        @Child(name="claimResponse", type={ClaimResponse.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication results", formalDefinition="The Coverages adjudication details.")
        protected Reference claimResponse;
        protected ClaimResponse claimResponseTarget;
        private static final long serialVersionUID = -1216535489L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(PositiveIntType sequence, BooleanType focal, Reference coverage) {
            this.sequence = sequence;
            this.focal = focal;
            this.coverage = coverage;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public InsuranceComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public InsuranceComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public InsuranceComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public InsuranceComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public InsuranceComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public InsuranceComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public InsuranceComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        public List<StringType> getPreAuthRef() {
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            return this.preAuthRef;
        }

        public InsuranceComponent setPreAuthRef(List<StringType> thePreAuthRef) {
            this.preAuthRef = thePreAuthRef;
            return this;
        }

        public boolean hasPreAuthRef() {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType item : this.preAuthRef) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPreAuthRefElement() {
            StringType t = new StringType();
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return t;
        }

        public InsuranceComponent addPreAuthRef(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return this;
        }

        public boolean hasPreAuthRef(String value) {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType v : this.preAuthRef) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Reference getClaimResponse() {
            if (this.claimResponse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponse = new Reference();
                }
            }
            return this.claimResponse;
        }

        public boolean hasClaimResponse() {
            return this.claimResponse != null && !this.claimResponse.isEmpty();
        }

        public InsuranceComponent setClaimResponse(Reference value) {
            this.claimResponse = value;
            return this;
        }

        public ClaimResponse getClaimResponseTarget() {
            if (this.claimResponseTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponseTarget = new ClaimResponse();
                }
            }
            return this.claimResponseTarget;
        }

        public InsuranceComponent setClaimResponseTarget(ClaimResponse value) {
            this.claimResponseTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line item.", 0, 1, this.sequence));
            children.add(new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, 1, this.focal));
            children.add(new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage));
            children.add(new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, 1, this.businessArrangement));
            children.add(new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, Integer.MAX_VALUE, this.preAuthRef));
            children.add(new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, 1, this.claimResponse));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line item.", 0, 1, this.sequence);
                }
                case 97604197: {
                    return new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, 1, this.focal);
                }
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage);
                }
                case 259920682: {
                    return new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, 1, this.businessArrangement);
                }
                case 522246568: {
                    return new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, Integer.MAX_VALUE, this.preAuthRef);
                }
                case 689513629: {
                    return new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, 1, this.claimResponse);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 97604197: {
                    Base[] baseArray;
                    if (this.focal == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.focal;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 259920682: {
                    Base[] baseArray;
                    if (this.businessArrangement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.businessArrangement;
                    }
                    return baseArray;
                }
                case 522246568: {
                    return this.preAuthRef == null ? new Base[]{} : this.preAuthRef.toArray(new Base[this.preAuthRef.size()]);
                }
                case 689513629: {
                    Base[] baseArray;
                    if (this.claimResponse == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.claimResponse;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 97604197: {
                    this.focal = this.castToBoolean(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
                case 259920682: {
                    this.businessArrangement = this.castToString(value);
                    return value;
                }
                case 522246568: {
                    this.getPreAuthRef().add(this.castToString(value));
                    return value;
                }
                case 689513629: {
                    this.claimResponse = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = this.castToString(value);
            } else if (name.equals("preAuthRef")) {
                this.getPreAuthRef().add(this.castToString(value));
            } else if (name.equals("claimResponse")) {
                this.claimResponse = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 97604197: {
                    return this.getFocalElement();
                }
                case -351767064: {
                    return this.getCoverage();
                }
                case 259920682: {
                    return this.getBusinessArrangementElement();
                }
                case 522246568: {
                    return this.addPreAuthRefElement();
                }
                case 689513629: {
                    return this.getClaimResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 97604197: {
                    return new String[]{"boolean"};
                }
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case 259920682: {
                    return new String[]{"string"};
                }
                case 522246568: {
                    return new String[]{"string"};
                }
                case 689513629: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequence");
            }
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.focal");
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.businessArrangement");
            }
            if (name.equals("preAuthRef")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.preAuthRef");
            }
            if (name.equals("claimResponse")) {
                this.claimResponse = new Reference();
                return this.claimResponse;
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            StringType stringType = dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
            if (this.preAuthRef != null) {
                dst.preAuthRef = new ArrayList<StringType>();
                for (StringType i : this.preAuthRef) {
                    dst.preAuthRef.add(i.copy());
                }
            }
            dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other;
            return InsuranceComponent.compareDeep(this.sequence, o.sequence, true) && InsuranceComponent.compareDeep(this.focal, o.focal, true) && InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareDeep(this.preAuthRef, o.preAuthRef, true) && InsuranceComponent.compareDeep(this.claimResponse, o.claimResponse, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other;
            return InsuranceComponent.compareValues(this.sequence, o.sequence, true) && InsuranceComponent.compareValues(this.focal, o.focal, true) && InsuranceComponent.compareValues(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareValues(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.focal, this.coverage, this.businessArrangement, this.preAuthRef, this.claimResponse});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.insurance";
        }
    }

    @Block
    public static class NoteComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sequence Number for this note", formalDefinition="An integer associated with each note which may be referred to from each service line item.")
        protected PositiveIntType number;
        @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        protected Enumeration<Enumerations.NoteType> type;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note explanatory text", formalDefinition="The note text.")
        protected StringType text;
        @Child(name="language", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language if different from the resource", formalDefinition="The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        private static final long serialVersionUID = -385184277L;

        public PositiveIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new PositiveIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public NoteComponent setNumberElement(PositiveIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public NoteComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new PositiveIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Enumeration<Enumerations.NoteType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NoteComponent setTypeElement(Enumeration<Enumerations.NoteType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.NoteType getType() {
            return this.type == null ? null : (Enumerations.NoteType)((Object)this.type.getValue());
        }

        public NoteComponent setType(Enumerations.NoteType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NoteComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NoteComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public NoteComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, 1, this.number));
            children.add(new Property("type", "code", "The note purpose: Print/Display.", 0, 1, this.type));
            children.add(new Property("text", "string", "The note text.", 0, 1, this.text));
            children.add(new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, 1, this.language));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, 1, this.number);
                }
                case 3575610: {
                    return new Property("type", "code", "The note purpose: Print/Display.", 0, 1, this.type);
                }
                case 3556653: {
                    return new Property("text", "string", "The note text.", 0, 1, this.text);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, 1, this.language);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.language;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = this.castToPositiveInt(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"positiveInt"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.number");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.type");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.text");
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            return super.addChild(name);
        }

        @Override
        public NoteComponent copy() {
            NoteComponent dst = new NoteComponent();
            this.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.language = this.language == null ? null : this.language.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other;
            return NoteComponent.compareDeep(this.number, o.number, true) && NoteComponent.compareDeep(this.type, o.type, true) && NoteComponent.compareDeep(this.text, o.text, true) && NoteComponent.compareDeep(this.language, o.language, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other;
            return NoteComponent.compareValues(this.number, o.number, true) && NoteComponent.compareValues(this.type, o.type, true) && NoteComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.number, this.type, this.text, this.language});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.processNote";
        }
    }

    @Block
    public static class PaymentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Partial or Complete", formalDefinition="Whether this represents partial or complete payment of the claim.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-paymenttype")
        protected CodeableConcept type;
        @Child(name="adjustment", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payment adjustment for non-Claim issues", formalDefinition="Adjustment to the payment of this transaction which is not related to adjudication of this transaction.")
        protected Money adjustment;
        @Child(name="adjustmentReason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation for the non-claim adjustment", formalDefinition="Reason for the payment adjustment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-adjustment-reason")
        protected CodeableConcept adjustmentReason;
        @Child(name="date", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Expected data of Payment", formalDefinition="Estimated payment data.")
        protected DateType date;
        @Child(name="amount", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payable amount after adjustment", formalDefinition="Payable less any payment adjustment.")
        protected Money amount;
        @Child(name="identifier", type={Identifier.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier of the payment instrument", formalDefinition="Payment identifier.")
        protected Identifier identifier;
        private static final long serialVersionUID = 1539906026L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PaymentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Money getAdjustment() {
            if (this.adjustment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustment");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustment = new Money();
                }
            }
            return this.adjustment;
        }

        public boolean hasAdjustment() {
            return this.adjustment != null && !this.adjustment.isEmpty();
        }

        public PaymentComponent setAdjustment(Money value) {
            this.adjustment = value;
            return this;
        }

        public CodeableConcept getAdjustmentReason() {
            if (this.adjustmentReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustmentReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustmentReason = new CodeableConcept();
                }
            }
            return this.adjustmentReason;
        }

        public boolean hasAdjustmentReason() {
            return this.adjustmentReason != null && !this.adjustmentReason.isEmpty();
        }

        public PaymentComponent setAdjustmentReason(CodeableConcept value) {
            this.adjustmentReason = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public PaymentComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public PaymentComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PaymentComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public PaymentComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the claim.", 0, 1, this.type));
            children.add(new Property("adjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, 1, this.adjustment));
            children.add(new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason));
            children.add(new Property("date", "date", "Estimated payment data.", 0, 1, this.date));
            children.add(new Property("amount", "Money", "Payable less any payment adjustment.", 0, 1, this.amount));
            children.add(new Property(ClaimResponse.SP_IDENTIFIER, "Identifier", "Payment identifier.", 0, 1, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the claim.", 0, 1, this.type);
                }
                case 1977085293: {
                    return new Property("adjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, 1, this.adjustment);
                }
                case -1255938543: {
                    return new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason);
                }
                case 3076014: {
                    return new Property("date", "date", "Estimated payment data.", 0, 1, this.date);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Payable less any payment adjustment.", 0, 1, this.amount);
                }
                case -1618432855: {
                    return new Property(ClaimResponse.SP_IDENTIFIER, "Identifier", "Payment identifier.", 0, 1, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1977085293: {
                    Base[] baseArray;
                    if (this.adjustment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.adjustment;
                    }
                    return baseArray;
                }
                case -1255938543: {
                    Base[] baseArray;
                    if (this.adjustmentReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.adjustmentReason;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.date;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.identifier;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1977085293: {
                    this.adjustment = this.castToMoney(value);
                    return value;
                }
                case -1255938543: {
                    this.adjustmentReason = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("adjustment")) {
                this.adjustment = this.castToMoney(value);
            } else if (name.equals("adjustmentReason")) {
                this.adjustmentReason = this.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals(ClaimResponse.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1977085293: {
                    return this.getAdjustment();
                }
                case -1255938543: {
                    return this.getAdjustmentReason();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1977085293: {
                    return new String[]{"Money"};
                }
                case -1255938543: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"date"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("adjustment")) {
                this.adjustment = new Money();
                return this.adjustment;
            }
            if (name.equals("adjustmentReason")) {
                this.adjustmentReason = new CodeableConcept();
                return this.adjustmentReason;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.date");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals(ClaimResponse.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            return super.addChild(name);
        }

        @Override
        public PaymentComponent copy() {
            PaymentComponent dst = new PaymentComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.adjustment = this.adjustment == null ? null : this.adjustment.copy();
            dst.adjustmentReason = this.adjustmentReason == null ? null : this.adjustmentReason.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other;
            return PaymentComponent.compareDeep(this.type, o.type, true) && PaymentComponent.compareDeep(this.adjustment, o.adjustment, true) && PaymentComponent.compareDeep(this.adjustmentReason, o.adjustmentReason, true) && PaymentComponent.compareDeep(this.date, o.date, true) && PaymentComponent.compareDeep(this.amount, o.amount, true) && PaymentComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other;
            return PaymentComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.adjustment, this.adjustmentReason, this.date, this.amount, this.identifier});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.payment";
        }
    }

    @Block
    public static class ErrorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Item sequence number", formalDefinition="The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="detailSequenceLinkId", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected PositiveIntType detailSequenceLinkId;
        @Child(name="subdetailSequenceLinkId", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected PositiveIntType subdetailSequenceLinkId;
        @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Error code detailing processing issues", formalDefinition="An error code,from a specified code system, which details why the claim could not be adjudicated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
        protected CodeableConcept code;
        private static final long serialVersionUID = -1379670472L;

        public ErrorComponent() {
        }

        public ErrorComponent(CodeableConcept code) {
            this.code = code;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public ErrorComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public ErrorComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public PositiveIntType getDetailSequenceLinkIdElement() {
            if (this.detailSequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.detailSequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailSequenceLinkId = new PositiveIntType();
                }
            }
            return this.detailSequenceLinkId;
        }

        public boolean hasDetailSequenceLinkIdElement() {
            return this.detailSequenceLinkId != null && !this.detailSequenceLinkId.isEmpty();
        }

        public boolean hasDetailSequenceLinkId() {
            return this.detailSequenceLinkId != null && !this.detailSequenceLinkId.isEmpty();
        }

        public ErrorComponent setDetailSequenceLinkIdElement(PositiveIntType value) {
            this.detailSequenceLinkId = value;
            return this;
        }

        public int getDetailSequenceLinkId() {
            return this.detailSequenceLinkId == null || this.detailSequenceLinkId.isEmpty() ? 0 : (Integer)this.detailSequenceLinkId.getValue();
        }

        public ErrorComponent setDetailSequenceLinkId(int value) {
            if (this.detailSequenceLinkId == null) {
                this.detailSequenceLinkId = new PositiveIntType();
            }
            this.detailSequenceLinkId.setValue((Object)value);
            return this;
        }

        public PositiveIntType getSubdetailSequenceLinkIdElement() {
            if (this.subdetailSequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.subdetailSequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.subdetailSequenceLinkId = new PositiveIntType();
                }
            }
            return this.subdetailSequenceLinkId;
        }

        public boolean hasSubdetailSequenceLinkIdElement() {
            return this.subdetailSequenceLinkId != null && !this.subdetailSequenceLinkId.isEmpty();
        }

        public boolean hasSubdetailSequenceLinkId() {
            return this.subdetailSequenceLinkId != null && !this.subdetailSequenceLinkId.isEmpty();
        }

        public ErrorComponent setSubdetailSequenceLinkIdElement(PositiveIntType value) {
            this.subdetailSequenceLinkId = value;
            return this;
        }

        public int getSubdetailSequenceLinkId() {
            return this.subdetailSequenceLinkId == null || this.subdetailSequenceLinkId.isEmpty() ? 0 : (Integer)this.subdetailSequenceLinkId.getValue();
        }

        public ErrorComponent setSubdetailSequenceLinkId(int value) {
            if (this.subdetailSequenceLinkId == null) {
                this.subdetailSequenceLinkId = new PositiveIntType();
            }
            this.subdetailSequenceLinkId.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ErrorComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequenceLinkId", "positiveInt", "The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.", 0, 1, this.sequenceLinkId));
            children.add(new Property("detailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.detailSequenceLinkId));
            children.add(new Property("subdetailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.subdetailSequenceLinkId));
            children.add(new Property("code", "CodeableConcept", "An error code,from a specified code system, which details why the claim could not be adjudicated.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422298666: {
                    return new Property("sequenceLinkId", "positiveInt", "The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.", 0, 1, this.sequenceLinkId);
                }
                case 516748423: {
                    return new Property("detailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.detailSequenceLinkId);
                }
                case -1061088569: {
                    return new Property("subdetailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.subdetailSequenceLinkId);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "An error code,from a specified code system, which details why the claim could not be adjudicated.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    Base[] baseArray;
                    if (this.sequenceLinkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequenceLinkId;
                    }
                    return baseArray;
                }
                case 516748423: {
                    Base[] baseArray;
                    if (this.detailSequenceLinkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detailSequenceLinkId;
                    }
                    return baseArray;
                }
                case -1061088569: {
                    Base[] baseArray;
                    if (this.subdetailSequenceLinkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subdetailSequenceLinkId;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    this.sequenceLinkId = this.castToPositiveInt(value);
                    return value;
                }
                case 516748423: {
                    this.detailSequenceLinkId = this.castToPositiveInt(value);
                    return value;
                }
                case -1061088569: {
                    this.subdetailSequenceLinkId = this.castToPositiveInt(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("detailSequenceLinkId")) {
                this.detailSequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("subdetailSequenceLinkId")) {
                this.subdetailSequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return this.getSequenceLinkIdElement();
                }
                case 516748423: {
                    return this.getDetailSequenceLinkIdElement();
                }
                case -1061088569: {
                    return this.getSubdetailSequenceLinkIdElement();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return new String[]{"positiveInt"};
                }
                case 516748423: {
                    return new String[]{"positiveInt"};
                }
                case -1061088569: {
                    return new String[]{"positiveInt"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("detailSequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.detailSequenceLinkId");
            }
            if (name.equals("subdetailSequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.subdetailSequenceLinkId");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ErrorComponent copy() {
            ErrorComponent dst = new ErrorComponent();
            this.copyValues(dst);
            dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            dst.detailSequenceLinkId = this.detailSequenceLinkId == null ? null : this.detailSequenceLinkId.copy();
            dst.subdetailSequenceLinkId = this.subdetailSequenceLinkId == null ? null : this.subdetailSequenceLinkId.copy();
            dst.code = this.code == null ? null : this.code.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ErrorComponent)) {
                return false;
            }
            ErrorComponent o = (ErrorComponent)other;
            return ErrorComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && ErrorComponent.compareDeep(this.detailSequenceLinkId, o.detailSequenceLinkId, true) && ErrorComponent.compareDeep(this.subdetailSequenceLinkId, o.subdetailSequenceLinkId, true) && ErrorComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ErrorComponent)) {
                return false;
            }
            ErrorComponent o = (ErrorComponent)other;
            return ErrorComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && ErrorComponent.compareValues(this.detailSequenceLinkId, o.detailSequenceLinkId, true) && ErrorComponent.compareValues(this.subdetailSequenceLinkId, o.subdetailSequenceLinkId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequenceLinkId, this.detailSequenceLinkId, this.subdetailSequenceLinkId, this.code});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.error";
        }
    }

    @Block
    public static class AddedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service instances", formalDefinition="List of input service items which this service line is intended to replace.")
        protected List<PositiveIntType> sequenceLinkId;
        @Child(name="detailSequenceLinkId", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected List<PositiveIntType> detailSequenceLinkId;
        @Child(name="subdetailSequenceLinkId", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected List<PositiveIntType> subdetailSequenceLinkId;
        @Child(name="service", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Group, Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept service;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="fee", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Professional fee or Product charge", formalDefinition="The fee charged for the professional service or product..")
        protected Money fee;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudications results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = 286653346L;

        public List<PositiveIntType> getSequenceLinkId() {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            return this.sequenceLinkId;
        }

        public AddedItemComponent setSequenceLinkId(List<PositiveIntType> theSequenceLinkId) {
            this.sequenceLinkId = theSequenceLinkId;
            return this;
        }

        public boolean hasSequenceLinkId() {
            if (this.sequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.sequenceLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSequenceLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.sequenceLinkId.add(t);
            return t;
        }

        public AddedItemComponent addSequenceLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.sequenceLinkId.add(t);
            return this;
        }

        public boolean hasSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.sequenceLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getDetailSequenceLinkId() {
            if (this.detailSequenceLinkId == null) {
                this.detailSequenceLinkId = new ArrayList<PositiveIntType>();
            }
            return this.detailSequenceLinkId;
        }

        public AddedItemComponent setDetailSequenceLinkId(List<PositiveIntType> theDetailSequenceLinkId) {
            this.detailSequenceLinkId = theDetailSequenceLinkId;
            return this;
        }

        public boolean hasDetailSequenceLinkId() {
            if (this.detailSequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.detailSequenceLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDetailSequenceLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.detailSequenceLinkId == null) {
                this.detailSequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.detailSequenceLinkId.add(t);
            return t;
        }

        public AddedItemComponent addDetailSequenceLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.detailSequenceLinkId == null) {
                this.detailSequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.detailSequenceLinkId.add(t);
            return this;
        }

        public boolean hasDetailSequenceLinkId(int value) {
            if (this.detailSequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.detailSequenceLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getSubdetailSequenceLinkId() {
            if (this.subdetailSequenceLinkId == null) {
                this.subdetailSequenceLinkId = new ArrayList<PositiveIntType>();
            }
            return this.subdetailSequenceLinkId;
        }

        public AddedItemComponent setSubdetailSequenceLinkId(List<PositiveIntType> theSubdetailSequenceLinkId) {
            this.subdetailSequenceLinkId = theSubdetailSequenceLinkId;
            return this;
        }

        public boolean hasSubdetailSequenceLinkId() {
            if (this.subdetailSequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.subdetailSequenceLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSubdetailSequenceLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.subdetailSequenceLinkId == null) {
                this.subdetailSequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.subdetailSequenceLinkId.add(t);
            return t;
        }

        public AddedItemComponent addSubdetailSequenceLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.subdetailSequenceLinkId == null) {
                this.subdetailSequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.subdetailSequenceLinkId.add(t);
            return this;
        }

        public boolean hasSubdetailSequenceLinkId(int value) {
            if (this.subdetailSequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.subdetailSequenceLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new CodeableConcept();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public AddedItemComponent setService(CodeableConcept value) {
            this.service = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Money getFee() {
            if (this.fee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.fee");
                }
                if (Configuration.doAutoCreate()) {
                    this.fee = new Money();
                }
            }
            return this.fee;
        }

        public boolean hasFee() {
            return this.fee != null && !this.fee.isEmpty();
        }

        public AddedItemComponent setFee(Money value) {
            this.fee = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequenceLinkId", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
            children.add(new Property("detailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.detailSequenceLinkId));
            children.add(new Property("subdetailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.subdetailSequenceLinkId));
            children.add(new Property("service", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.service));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("fee", "Money", "The fee charged for the professional service or product..", 0, 1, this.fee));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422298666: {
                    return new Property("sequenceLinkId", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.sequenceLinkId);
                }
                case 516748423: {
                    return new Property("detailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.detailSequenceLinkId);
                }
                case -1061088569: {
                    return new Property("subdetailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.subdetailSequenceLinkId);
                }
                case 1984153269: {
                    return new Property("service", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.service);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 101254: {
                    return new Property("fee", "Money", "The fee charged for the professional service or product..", 0, 1, this.fee);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return this.sequenceLinkId == null ? new Base[]{} : this.sequenceLinkId.toArray(new Base[this.sequenceLinkId.size()]);
                }
                case 516748423: {
                    return this.detailSequenceLinkId == null ? new Base[]{} : this.detailSequenceLinkId.toArray(new Base[this.detailSequenceLinkId.size()]);
                }
                case -1061088569: {
                    return this.subdetailSequenceLinkId == null ? new Base[]{} : this.subdetailSequenceLinkId.toArray(new Base[this.subdetailSequenceLinkId.size()]);
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.service;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 101254: {
                    Base[] baseArray;
                    if (this.fee == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.fee;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    this.getSequenceLinkId().add(this.castToPositiveInt(value));
                    return value;
                }
                case 516748423: {
                    this.getDetailSequenceLinkId().add(this.castToPositiveInt(value));
                    return value;
                }
                case -1061088569: {
                    this.getSubdetailSequenceLinkId().add(this.castToPositiveInt(value));
                    return value;
                }
                case 1984153269: {
                    this.service = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 101254: {
                    this.fee = this.castToMoney(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.getSequenceLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("detailSequenceLinkId")) {
                this.getDetailSequenceLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("subdetailSequenceLinkId")) {
                this.getSubdetailSequenceLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("service")) {
                this.service = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("fee")) {
                this.fee = this.castToMoney(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return this.addSequenceLinkIdElement();
                }
                case 516748423: {
                    return this.addDetailSequenceLinkIdElement();
                }
                case -1061088569: {
                    return this.addSubdetailSequenceLinkIdElement();
                }
                case 1984153269: {
                    return this.getService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 101254: {
                    return this.getFee();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return new String[]{"positiveInt"};
                }
                case 516748423: {
                    return new String[]{"positiveInt"};
                }
                case -1061088569: {
                    return new String[]{"positiveInt"};
                }
                case 1984153269: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 101254: {
                    return new String[]{"Money"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("detailSequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.detailSequenceLinkId");
            }
            if (name.equals("subdetailSequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.subdetailSequenceLinkId");
            }
            if (name.equals("service")) {
                this.service = new CodeableConcept();
                return this.service;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("fee")) {
                this.fee = new Money();
                return this.fee;
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemComponent copy() {
            AddedItemComponent dst = new AddedItemComponent();
            this.copyValues(dst);
            if (this.sequenceLinkId != null) {
                dst.sequenceLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.sequenceLinkId) {
                    dst.sequenceLinkId.add(positiveIntType.copy());
                }
            }
            if (this.detailSequenceLinkId != null) {
                dst.detailSequenceLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.detailSequenceLinkId) {
                    dst.detailSequenceLinkId.add(positiveIntType.copy());
                }
            }
            if (this.subdetailSequenceLinkId != null) {
                dst.subdetailSequenceLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.subdetailSequenceLinkId) {
                    dst.subdetailSequenceLinkId.add(positiveIntType.copy());
                }
            }
            CodeableConcept codeableConcept = dst.service = this.service == null ? null : this.service.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            Money money = dst.fee = this.fee == null ? null : this.fee.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other;
            return AddedItemComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && AddedItemComponent.compareDeep(this.detailSequenceLinkId, o.detailSequenceLinkId, true) && AddedItemComponent.compareDeep(this.subdetailSequenceLinkId, o.subdetailSequenceLinkId, true) && AddedItemComponent.compareDeep(this.service, o.service, true) && AddedItemComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemComponent.compareDeep(this.fee, o.fee, true) && AddedItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other;
            return AddedItemComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && AddedItemComponent.compareValues(this.detailSequenceLinkId, o.detailSequenceLinkId, true) && AddedItemComponent.compareValues(this.subdetailSequenceLinkId, o.subdetailSequenceLinkId, true) && AddedItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequenceLinkId, this.detailSequenceLinkId, this.subdetailSequenceLinkId, this.service, this.modifier, this.fee, this.noteNumber, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem";
        }
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail level adjudication details", formalDefinition="The adjudications results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = 1770463342L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType sequenceLinkId) {
            this.sequenceLinkId = sequenceLinkId;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public SubDetailComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public SubDetailComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public SubDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public SubDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public SubDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public SubDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, 1, this.sequenceLinkId));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422298666: {
                    return new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, 1, this.sequenceLinkId);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    Base[] baseArray;
                    if (this.sequenceLinkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequenceLinkId;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    this.sequenceLinkId = this.castToPositiveInt(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return this.getSequenceLinkIdElement();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return new String[]{"positiveInt"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && SubDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && SubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && SubDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequenceLinkId, this.noteNumber, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail.subDetail";
        }
    }

    @Block
    public static class ItemDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail level adjudication details", formalDefinition="The adjudications results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail line items", formalDefinition="The third tier service adjudications for submitted services.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = -1245557773L;

        public ItemDetailComponent() {
        }

        public ItemDetailComponent(PositiveIntType sequenceLinkId) {
            this.sequenceLinkId = sequenceLinkId;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemDetailComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public ItemDetailComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public ItemDetailComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public ItemDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public ItemDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public ItemDetailComponent setSubDetail(List<SubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public ItemDetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public SubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, 1, this.sequenceLinkId));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("subDetail", "", "The third tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422298666: {
                    return new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, 1, this.sequenceLinkId);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -828829007: {
                    return new Property("subDetail", "", "The third tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    Base[] baseArray;
                    if (this.sequenceLinkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequenceLinkId;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    this.sequenceLinkId = this.castToPositiveInt(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((SubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return this.getSequenceLinkIdElement();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return new String[]{"positiveInt"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemDetailComponent copy() {
            ItemDetailComponent dst = new ItemDetailComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other;
            return ItemDetailComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && ItemDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemDetailComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemDetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other;
            return ItemDetailComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && ItemDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequenceLinkId, this.noteNumber, this.adjudication, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail";
        }
    }

    @Block
    public static class AdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        protected CodeableConcept category;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation of Adjudication outcome", formalDefinition="Adjudication reason such as limit reached.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-reason")
        protected CodeableConcept reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = 1559898786L;

        public AdjudicationComponent() {
        }

        public AdjudicationComponent(CodeableConcept category) {
            this.category = category;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public AdjudicationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public AdjudicationComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public AdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public AdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public AdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category));
            children.add(new Property("reason", "CodeableConcept", "Adjudication reason such as limit reached.", 0, 1, this.reason));
            children.add(new Property("amount", "Money", "Monetary amount associated with the code.", 0, 1, this.amount));
            children.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Adjudication reason such as limit reached.", 0, 1, this.reason);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Monetary amount associated with the code.", 0, 1, this.amount);
                }
                case 111972721: {
                    return new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case 111972721: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.value");
            }
            return super.addChild(name);
        }

        @Override
        public AdjudicationComponent copy() {
            AdjudicationComponent dst = new AdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other;
            return AdjudicationComponent.compareDeep(this.category, o.category, true) && AdjudicationComponent.compareDeep(this.reason, o.reason, true) && AdjudicationComponent.compareDeep(this.amount, o.amount, true) && AdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other;
            return AdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.reason, this.amount, this.value});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.adjudication";
        }
    }

    @Block
    public static class ItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail line items", formalDefinition="The second tier service adjudications for submitted services.")
        protected List<ItemDetailComponent> detail;
        private static final long serialVersionUID = -1282041398L;

        public ItemComponent() {
        }

        public ItemComponent(PositiveIntType sequenceLinkId) {
            this.sequenceLinkId = sequenceLinkId;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public ItemComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public ItemComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public ItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public ItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<ItemDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            return this.detail;
        }

        public ItemComponent setDetail(List<ItemDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (ItemDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ItemDetailComponent addDetail() {
            ItemDetailComponent t = new ItemDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemComponent addDetail(ItemDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public ItemDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, 1, this.sequenceLinkId));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("detail", "", "The second tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422298666: {
                    return new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, 1, this.sequenceLinkId);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -1335224239: {
                    return new Property("detail", "", "The second tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    Base[] baseArray;
                    if (this.sequenceLinkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequenceLinkId;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    this.sequenceLinkId = this.castToPositiveInt(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((ItemDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((ItemDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return this.getSequenceLinkIdElement();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return new String[]{"positiveInt"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[0];
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemComponent copy() {
            ItemComponent dst = new ItemComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<ItemDetailComponent>();
                for (ItemDetailComponent itemDetailComponent : this.detail) {
                    dst.detail.add(itemDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other;
            return ItemComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && ItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other;
            return ItemComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && ItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequenceLinkId, this.noteNumber, this.adjudication, this.detail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item";
        }
    }

    public static class RemittanceOutcomeEnumFactory
    implements EnumFactory<RemittanceOutcome> {
        @Override
        public RemittanceOutcome fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return RemittanceOutcome.COMPLETE;
            }
            if ("error".equals(codeString)) {
                return RemittanceOutcome.ERROR;
            }
            if ("partial".equals(codeString)) {
                return RemittanceOutcome.PARTIAL;
            }
            throw new IllegalArgumentException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        public Enumeration<RemittanceOutcome> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RemittanceOutcome>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.COMPLETE);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.ERROR);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.PARTIAL);
            }
            throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        @Override
        public String toCode(RemittanceOutcome code) {
            if (code == RemittanceOutcome.COMPLETE) {
                return "complete";
            }
            if (code == RemittanceOutcome.ERROR) {
                return "error";
            }
            if (code == RemittanceOutcome.PARTIAL) {
                return "partial";
            }
            return "?";
        }

        @Override
        public String toSystem(RemittanceOutcome code) {
            return code.getSystem();
        }
    }

    public static enum RemittanceOutcome {
        COMPLETE,
        ERROR,
        PARTIAL,
        NULL;


        public static RemittanceOutcome fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETE: {
                    return "complete";
                }
                case ERROR: {
                    return "error";
                }
                case PARTIAL: {
                    return "partial";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETE: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETE: {
                    return "The processing has completed without errors";
                }
                case ERROR: {
                    return "One or more errors have been detected in the Claim";
                }
                case PARTIAL: {
                    return "No errors have been detected in the Claim and some of the adjudication has been performed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETE: {
                    return "Processing Complete";
                }
                case ERROR: {
                    return "Error";
                }
                case PARTIAL: {
                    return "Partial Processing";
                }
            }
            return "?";
        }
    }

    public static class ClaimResponseStatusEnumFactory
    implements EnumFactory<ClaimResponseStatus> {
        @Override
        public ClaimResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ClaimResponseStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ClaimResponseStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return ClaimResponseStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ClaimResponseStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ClaimResponseStatus code '" + codeString + "'");
        }

        public Enumeration<ClaimResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ClaimResponseStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ClaimResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ClaimResponseStatus code) {
            if (code == ClaimResponseStatus.ACTIVE) {
                return "active";
            }
            if (code == ClaimResponseStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ClaimResponseStatus.DRAFT) {
                return "draft";
            }
            if (code == ClaimResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ClaimResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum ClaimResponseStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static ClaimResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ClaimResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

