/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;

@DatatypeDef(name="DataRequirement")
public class DataRequirement
extends Type
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of the required data", formalDefinition="The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-types")
    protected CodeType type;
    @Child(name="profile", type={UriType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The profile of the required data", formalDefinition="The profile of the required data, specified as the uri of the profile definition.")
    protected List<UriType> profile;
    @Child(name="mustSupport", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates that specific structure elements are referenced by the knowledge module", formalDefinition="Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available. Note that the value for this element can be a path to allow references to nested elements. In that case, all the elements along the path must be supported.")
    protected List<StringType> mustSupport;
    @Child(name="codeFilter", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What codes are expected", formalDefinition="Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.")
    protected List<DataRequirementCodeFilterComponent> codeFilter;
    @Child(name="dateFilter", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What dates/date ranges are expected", formalDefinition="Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.")
    protected List<DataRequirementDateFilterComponent> dateFilter;
    private static final long serialVersionUID = 274786645L;

    public DataRequirement() {
    }

    public DataRequirement(CodeType type) {
        this.type = type;
    }

    public CodeType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataRequirement.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DataRequirement setTypeElement(CodeType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public DataRequirement setType(String value) {
        if (this.type == null) {
            this.type = new CodeType();
        }
        this.type.setValue(value);
        return this;
    }

    public List<UriType> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<UriType>();
        }
        return this.profile;
    }

    public DataRequirement setProfile(List<UriType> theProfile) {
        this.profile = theProfile;
        return this;
    }

    public boolean hasProfile() {
        if (this.profile == null) {
            return false;
        }
        for (UriType item : this.profile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addProfileElement() {
        UriType t = new UriType();
        if (this.profile == null) {
            this.profile = new ArrayList<UriType>();
        }
        this.profile.add(t);
        return t;
    }

    public DataRequirement addProfile(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.profile == null) {
            this.profile = new ArrayList<UriType>();
        }
        this.profile.add(t);
        return this;
    }

    public boolean hasProfile(String value) {
        if (this.profile == null) {
            return false;
        }
        for (UriType v : this.profile) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getMustSupport() {
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        return this.mustSupport;
    }

    public DataRequirement setMustSupport(List<StringType> theMustSupport) {
        this.mustSupport = theMustSupport;
        return this;
    }

    public boolean hasMustSupport() {
        if (this.mustSupport == null) {
            return false;
        }
        for (StringType item : this.mustSupport) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addMustSupportElement() {
        StringType t = new StringType();
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        this.mustSupport.add(t);
        return t;
    }

    public DataRequirement addMustSupport(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        this.mustSupport.add(t);
        return this;
    }

    public boolean hasMustSupport(String value) {
        if (this.mustSupport == null) {
            return false;
        }
        for (StringType v : this.mustSupport) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<DataRequirementCodeFilterComponent> getCodeFilter() {
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        return this.codeFilter;
    }

    public DataRequirement setCodeFilter(List<DataRequirementCodeFilterComponent> theCodeFilter) {
        this.codeFilter = theCodeFilter;
        return this;
    }

    public boolean hasCodeFilter() {
        if (this.codeFilter == null) {
            return false;
        }
        for (DataRequirementCodeFilterComponent item : this.codeFilter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementCodeFilterComponent addCodeFilter() {
        DataRequirementCodeFilterComponent t = new DataRequirementCodeFilterComponent();
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        this.codeFilter.add(t);
        return t;
    }

    public DataRequirement addCodeFilter(DataRequirementCodeFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        this.codeFilter.add(t);
        return this;
    }

    public DataRequirementCodeFilterComponent getCodeFilterFirstRep() {
        if (this.getCodeFilter().isEmpty()) {
            this.addCodeFilter();
        }
        return this.getCodeFilter().get(0);
    }

    public List<DataRequirementDateFilterComponent> getDateFilter() {
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        return this.dateFilter;
    }

    public DataRequirement setDateFilter(List<DataRequirementDateFilterComponent> theDateFilter) {
        this.dateFilter = theDateFilter;
        return this;
    }

    public boolean hasDateFilter() {
        if (this.dateFilter == null) {
            return false;
        }
        for (DataRequirementDateFilterComponent item : this.dateFilter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementDateFilterComponent addDateFilter() {
        DataRequirementDateFilterComponent t = new DataRequirementDateFilterComponent();
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        this.dateFilter.add(t);
        return t;
    }

    public DataRequirement addDateFilter(DataRequirementDateFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        this.dateFilter.add(t);
        return this;
    }

    public DataRequirementDateFilterComponent getDateFilterFirstRep() {
        if (this.getDateFilter().isEmpty()) {
            this.addDateFilter();
        }
        return this.getDateFilter().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "code", "The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.", 0, 1, this.type));
        children.add(new Property("profile", "uri", "The profile of the required data, specified as the uri of the profile definition.", 0, Integer.MAX_VALUE, this.profile));
        children.add(new Property("mustSupport", "string", "Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available. Note that the value for this element can be a path to allow references to nested elements. In that case, all the elements along the path must be supported.", 0, Integer.MAX_VALUE, this.mustSupport));
        children.add(new Property("codeFilter", "", "Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.codeFilter));
        children.add(new Property("dateFilter", "", "Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.dateFilter));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "code", "The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.", 0, 1, this.type);
            }
            case -309425751: {
                return new Property("profile", "uri", "The profile of the required data, specified as the uri of the profile definition.", 0, Integer.MAX_VALUE, this.profile);
            }
            case -1402857082: {
                return new Property("mustSupport", "string", "Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available. Note that the value for this element can be a path to allow references to nested elements. In that case, all the elements along the path must be supported.", 0, Integer.MAX_VALUE, this.mustSupport);
            }
            case -1303674939: {
                return new Property("codeFilter", "", "Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.codeFilter);
            }
            case 149531846: {
                return new Property("dateFilter", "", "Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.dateFilter);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -309425751: {
                return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
            }
            case -1402857082: {
                return this.mustSupport == null ? new Base[]{} : this.mustSupport.toArray(new Base[this.mustSupport.size()]);
            }
            case -1303674939: {
                return this.codeFilter == null ? new Base[]{} : this.codeFilter.toArray(new Base[this.codeFilter.size()]);
            }
            case 149531846: {
                return this.dateFilter == null ? new Base[]{} : this.dateFilter.toArray(new Base[this.dateFilter.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.type = this.castToCode(value);
                return value;
            }
            case -309425751: {
                this.getProfile().add(this.castToUri(value));
                return value;
            }
            case -1402857082: {
                this.getMustSupport().add(this.castToString(value));
                return value;
            }
            case -1303674939: {
                this.getCodeFilter().add((DataRequirementCodeFilterComponent)value);
                return value;
            }
            case 149531846: {
                this.getDateFilter().add((DataRequirementDateFilterComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.type = this.castToCode(value);
        } else if (name.equals("profile")) {
            this.getProfile().add(this.castToUri(value));
        } else if (name.equals("mustSupport")) {
            this.getMustSupport().add(this.castToString(value));
        } else if (name.equals("codeFilter")) {
            this.getCodeFilter().add((DataRequirementCodeFilterComponent)value);
        } else if (name.equals("dateFilter")) {
            this.getDateFilter().add((DataRequirementDateFilterComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getTypeElement();
            }
            case -309425751: {
                return this.addProfileElement();
            }
            case -1402857082: {
                return this.addMustSupportElement();
            }
            case -1303674939: {
                return this.addCodeFilter();
            }
            case 149531846: {
                return this.addDateFilter();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"code"};
            }
            case -309425751: {
                return new String[]{"uri"};
            }
            case -1402857082: {
                return new String[]{"string"};
            }
            case -1303674939: {
                return new String[0];
            }
            case 149531846: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type DataRequirement.type");
        }
        if (name.equals("profile")) {
            throw new FHIRException("Cannot call addChild on a primitive type DataRequirement.profile");
        }
        if (name.equals("mustSupport")) {
            throw new FHIRException("Cannot call addChild on a primitive type DataRequirement.mustSupport");
        }
        if (name.equals("codeFilter")) {
            return this.addCodeFilter();
        }
        if (name.equals("dateFilter")) {
            return this.addDateFilter();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DataRequirement";
    }

    @Override
    public DataRequirement copy() {
        DataRequirement dst = new DataRequirement();
        this.copyValues(dst);
        CodeType codeType = dst.type = this.type == null ? null : this.type.copy();
        if (this.profile != null) {
            dst.profile = new ArrayList<UriType>();
            for (UriType uriType : this.profile) {
                dst.profile.add(uriType.copy());
            }
        }
        if (this.mustSupport != null) {
            dst.mustSupport = new ArrayList<StringType>();
            for (StringType stringType : this.mustSupport) {
                dst.mustSupport.add(stringType.copy());
            }
        }
        if (this.codeFilter != null) {
            dst.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
            for (DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : this.codeFilter) {
                dst.codeFilter.add(dataRequirementCodeFilterComponent.copy());
            }
        }
        if (this.dateFilter != null) {
            dst.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
            for (DataRequirementDateFilterComponent dataRequirementDateFilterComponent : this.dateFilter) {
                dst.dateFilter.add(dataRequirementDateFilterComponent.copy());
            }
        }
        return dst;
    }

    @Override
    protected DataRequirement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DataRequirement)) {
            return false;
        }
        DataRequirement o = (DataRequirement)other;
        return DataRequirement.compareDeep(this.type, o.type, true) && DataRequirement.compareDeep(this.profile, o.profile, true) && DataRequirement.compareDeep(this.mustSupport, o.mustSupport, true) && DataRequirement.compareDeep(this.codeFilter, o.codeFilter, true) && DataRequirement.compareDeep(this.dateFilter, o.dateFilter, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DataRequirement)) {
            return false;
        }
        DataRequirement o = (DataRequirement)other;
        return DataRequirement.compareValues(this.type, o.type, true) && DataRequirement.compareValues(this.profile, o.profile, true) && DataRequirement.compareValues(this.mustSupport, o.mustSupport, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.profile, this.mustSupport, this.codeFilter, this.dateFilter});
    }

    @Block
    public static class DataRequirementDateFilterComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The date-valued attribute of the filter", formalDefinition="The date-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type dateTime, Period, Schedule, or Timing.")
        protected StringType path;
        @Child(name="value", type={DateTimeType.class, Period.class, Duration.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The value of the filter, as a Period, DateTime, or Duration value", formalDefinition="The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration from now.")
        protected Type value;
        private static final long serialVersionUID = 1791957163L;

        public DataRequirementDateFilterComponent() {
        }

        public DataRequirementDateFilterComponent(StringType path) {
            this.path = path;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementDateFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementDateFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementDateFilterComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this.value instanceof Period;
        }

        public Duration getValueDuration() throws FHIRException {
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this.value instanceof Duration;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DataRequirementDateFilterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The date-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type dateTime, Period, Schedule, or Timing.", 0, 1, this.path));
            children.add(new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration from now.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The date-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type dateTime, Period, Schedule, or Timing.", 0, 1, this.path);
                }
                case -1410166417: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration from now.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration from now.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration from now.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration from now.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration from now.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"dateTime", "Period", "Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type DataRequirement.path");
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementDateFilterComponent copy() {
            DataRequirementDateFilterComponent dst = new DataRequirementDateFilterComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementDateFilterComponent)) {
                return false;
            }
            DataRequirementDateFilterComponent o = (DataRequirementDateFilterComponent)other;
            return DataRequirementDateFilterComponent.compareDeep(this.path, o.path, true) && DataRequirementDateFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementDateFilterComponent)) {
                return false;
            }
            DataRequirementDateFilterComponent o = (DataRequirementDateFilterComponent)other;
            return DataRequirementDateFilterComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.value});
        }

        @Override
        public String fhirType() {
            return "DataRequirement.dateFilter";
        }
    }

    @Block
    public static class DataRequirementCodeFilterComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The code-valued attribute of the filter", formalDefinition="The code-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.")
        protected StringType path;
        @Child(name="valueSet", type={UriType.class, ValueSet.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Valueset for the filter", formalDefinition="The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.")
        protected Type valueSet;
        @Child(name="code", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="What code is expected", formalDefinition="The codes for the code filter. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes. If codes are specified in addition to a value set, the filter returns items matching a code in the value set or one of the specified codes.")
        protected List<Coding> code;
        private static final long serialVersionUID = -1836756746L;

        public DataRequirementCodeFilterComponent() {
        }

        public DataRequirementCodeFilterComponent(StringType path) {
            this.path = path;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementCodeFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementCodeFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementCodeFilterComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Type getValueSet() {
            return this.valueSet;
        }

        public UriType getValueSetUriType() throws FHIRException {
            if (!(this.valueSet instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (UriType)this.valueSet;
        }

        public boolean hasValueSetUriType() {
            return this.valueSet instanceof UriType;
        }

        public Reference getValueSetReference() throws FHIRException {
            if (!(this.valueSet instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (Reference)this.valueSet;
        }

        public boolean hasValueSetReference() {
            return this.valueSet instanceof Reference;
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public DataRequirementCodeFilterComponent setValueSet(Type value) {
            this.valueSet = value;
            return this;
        }

        public List<Coding> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            return this.code;
        }

        public DataRequirementCodeFilterComponent setCode(List<Coding> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (Coding item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addCode() {
            Coding t = new Coding();
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return t;
        }

        public DataRequirementCodeFilterComponent addCode(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return this;
        }

        public Coding getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The code-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.", 0, 1, this.path));
            children.add(new Property("valueSet[x]", "uri|Reference(ValueSet)", "The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, 1, this.valueSet));
            children.add(new Property("code", "Coding", "The codes for the code filter. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes. If codes are specified in addition to a value set, the filter returns items matching a code in the value set or one of the specified codes.", 0, Integer.MAX_VALUE, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The code-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.", 0, 1, this.path);
                }
                case -1438410321: {
                    return new Property("valueSet[x]", "uri|Reference(ValueSet)", "The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, 1, this.valueSet);
                }
                case -1410174671: {
                    return new Property("valueSet[x]", "uri|Reference(ValueSet)", "The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, 1, this.valueSet);
                }
                case -1438416261: {
                    return new Property("valueSet[x]", "uri|Reference(ValueSet)", "The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, 1, this.valueSet);
                }
                case 295220506: {
                    return new Property("valueSet[x]", "uri|Reference(ValueSet)", "The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, 1, this.valueSet);
                }
                case 3059181: {
                    return new Property("code", "Coding", "The codes for the code filter. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes. If codes are specified in addition to a value set, the filter returns items matching a code in the value set or one of the specified codes.", 0, Integer.MAX_VALUE, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = this.castToType(value);
                    return value;
                }
                case 3059181: {
                    this.getCode().add(this.castToCoding(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("valueSet[x]")) {
                this.valueSet = this.castToType(value);
            } else if (name.equals("code")) {
                this.getCode().add(this.castToCoding(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -1438410321: {
                    return this.getValueSet();
                }
                case -1410174671: {
                    return this.getValueSet();
                }
                case 3059181: {
                    return this.addCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"uri", "Reference"};
                }
                case 3059181: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type DataRequirement.path");
            }
            if (name.equals("valueSetUri")) {
                this.valueSet = new UriType();
                return this.valueSet;
            }
            if (name.equals("valueSetReference")) {
                this.valueSet = new Reference();
                return this.valueSet;
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementCodeFilterComponent copy() {
            DataRequirementCodeFilterComponent dst = new DataRequirementCodeFilterComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            Type type = dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            if (this.code != null) {
                dst.code = new ArrayList<Coding>();
                for (Coding i : this.code) {
                    dst.code.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementCodeFilterComponent)) {
                return false;
            }
            DataRequirementCodeFilterComponent o = (DataRequirementCodeFilterComponent)other;
            return DataRequirementCodeFilterComponent.compareDeep(this.path, o.path, true) && DataRequirementCodeFilterComponent.compareDeep(this.valueSet, o.valueSet, true) && DataRequirementCodeFilterComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementCodeFilterComponent)) {
                return false;
            }
            DataRequirementCodeFilterComponent o = (DataRequirementCodeFilterComponent)other;
            return DataRequirementCodeFilterComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.path, this.valueSet, this.code});
        }

        @Override
        public String fhirType() {
            return "DataRequirement.codeFilter";
        }
    }
}

