/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hl7.fhir.r4.model.BaseDateTimeType;

@DatatypeDef(name="dateTime")
public class DateTimeType
extends BaseDateTimeType {
    private static final long serialVersionUID = 3L;
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.SECOND;

    public DateTimeType() {
    }

    public DateTimeType(Date theDate) {
        super(theDate, DEFAULT_PRECISION, TimeZone.getDefault());
    }

    public DateTimeType(Date theDate, TemporalPrecisionEnum thePrecision) {
        super(theDate, thePrecision, TimeZone.getDefault());
    }

    public DateTimeType(String theValue) {
        super(theValue);
    }

    public DateTimeType(Date theDate, TemporalPrecisionEnum thePrecision, TimeZone theTimezone) {
        super(theDate, thePrecision, theTimezone);
    }

    public DateTimeType(Calendar theCalendar) {
        if (theCalendar != null) {
            this.setValue(theCalendar.getTime());
            this.setPrecision(DEFAULT_PRECISION);
            this.setTimeZone(theCalendar.getTimeZone());
        }
    }

    @Override
    boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case SECOND: 
            case MILLI: {
                return true;
            }
        }
        return false;
    }

    public static DateTimeType now() {
        return new DateTimeType(new Date(), TemporalPrecisionEnum.SECOND, TimeZone.getDefault());
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }

    @Override
    public DateTimeType copy() {
        return new DateTimeType(this.getValueAsString());
    }

    public static DateTimeType parseV3(String theV3String) {
        DateTimeType retVal = new DateTimeType();
        retVal.setValueAsV3String(theV3String);
        return retVal;
    }

    public static DateTimeType today() {
        DateTimeType retVal = DateTimeType.now();
        retVal.setPrecision(TemporalPrecisionEnum.DAY);
        return retVal;
    }

    public boolean getTzSign() {
        return this.getTimeZone().getRawOffset() >= 0;
    }

    public int getTzHour() {
        return (int)((long)this.getTimeZone().getRawOffset() / 60000L) / 60;
    }

    public int getTzMin() {
        return (int)((long)this.getTimeZone().getRawOffset() / 60000L) % 60;
    }

    @Override
    public String fhirType() {
        return "dateTime";
    }
}

