/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r4.model.TypeDetails;
import org.hl7.fhir.utilities.Utilities;

public class ExpressionNode {
    private String uniqueId;
    private Kind kind;
    private String name;
    private String constant;
    private Function function;
    private List<ExpressionNode> parameters;
    private ExpressionNode inner;
    private ExpressionNode group;
    private Operation operation;
    private boolean proximal;
    private ExpressionNode opNext;
    private SourceLocation start;
    private SourceLocation end;
    private SourceLocation opStart;
    private SourceLocation opEnd;
    private TypeDetails types;
    private TypeDetails opTypes;

    public ExpressionNode(int uniqueId) {
        this.uniqueId = Integer.toString(uniqueId);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        switch (this.kind) {
            case Name: {
                b.append(this.name);
                break;
            }
            case Function: {
                if (this.function == Function.Item) {
                    b.append("[");
                } else {
                    b.append(this.name);
                    b.append("(");
                }
                boolean first = true;
                for (ExpressionNode n : this.parameters) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    b.append(n.toString());
                }
                if (this.function == Function.Item) {
                    b.append("]");
                    break;
                }
                b.append(")");
                break;
            }
            case Constant: {
                if (Utilities.isInteger((String)this.constant) || Utilities.existsInList((String)this.constant, (String[])new String[]{"true", "false"})) {
                    b.append(Utilities.escapeJava((String)this.constant));
                    break;
                }
                b.append(Utilities.escapeJava((String)this.constant));
                break;
            }
            case Group: {
                b.append("(");
                b.append(this.group.toString());
                b.append(")");
            }
        }
        if (this.inner != null) {
            b.append(".");
            b.append(this.inner.toString());
        }
        if (this.operation != null) {
            b.append(" ");
            b.append(this.operation.toCode());
            b.append(" ");
            b.append(this.opNext.toString());
        }
        return b.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConstant() {
        return this.constant;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
        if (this.parameters == null) {
            this.parameters = new ArrayList<ExpressionNode>();
        }
    }

    public boolean isProximal() {
        return this.proximal;
    }

    public void setProximal(boolean proximal) {
        this.proximal = proximal;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public ExpressionNode getInner() {
        return this.inner;
    }

    public void setInner(ExpressionNode value) {
        this.inner = value;
    }

    public ExpressionNode getOpNext() {
        return this.opNext;
    }

    public void setOpNext(ExpressionNode value) {
        this.opNext = value;
    }

    public List<ExpressionNode> getParameters() {
        return this.parameters;
    }

    public boolean checkName() {
        if (!this.name.startsWith("$")) {
            return true;
        }
        return this.name.equals("$this");
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public ExpressionNode getGroup() {
        return this.group;
    }

    public void setGroup(ExpressionNode group) {
        this.group = group;
    }

    public SourceLocation getStart() {
        return this.start;
    }

    public void setStart(SourceLocation start) {
        this.start = start;
    }

    public SourceLocation getEnd() {
        return this.end;
    }

    public void setEnd(SourceLocation end) {
        this.end = end;
    }

    public SourceLocation getOpStart() {
        return this.opStart;
    }

    public void setOpStart(SourceLocation opStart) {
        this.opStart = opStart;
    }

    public SourceLocation getOpEnd() {
        return this.opEnd;
    }

    public void setOpEnd(SourceLocation opEnd) {
        this.opEnd = opEnd;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int parameterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public String Canonical() {
        StringBuilder b = new StringBuilder();
        this.write(b);
        return b.toString();
    }

    public String summary() {
        switch (this.kind) {
            case Name: {
                return this.uniqueId + ": " + this.name;
            }
            case Function: {
                return this.uniqueId + ": " + this.function.toString() + "()";
            }
            case Constant: {
                return this.uniqueId + ": " + this.constant;
            }
            case Group: {
                return this.uniqueId + ": (Group)";
            }
        }
        return "??";
    }

    private void write(StringBuilder b) {
        switch (this.kind) {
            case Name: {
                b.append(this.name);
                break;
            }
            case Constant: {
                b.append(this.constant);
                break;
            }
            case Function: {
                b.append(this.function.toCode());
                b.append('(');
                boolean f = true;
                for (ExpressionNode n : this.parameters) {
                    if (f) {
                        f = false;
                    } else {
                        b.append(", ");
                    }
                    n.write(b);
                }
                b.append(')');
                break;
            }
            case Group: {
                b.append('(');
                this.group.write(b);
                b.append(')');
            }
        }
        if (this.inner != null) {
            b.append('.');
            this.inner.write(b);
        }
        if (this.operation != null) {
            b.append(' ');
            b.append(this.operation.toCode());
            b.append(' ');
            this.opNext.write(b);
        }
    }

    public String check() {
        String msg;
        switch (this.kind) {
            case Name: {
                if (!Utilities.noString((String)this.name)) break;
                return "No Name provided @ " + this.location();
            }
            case Function: {
                if (this.function == null) {
                    return "No Function id provided @ " + this.location();
                }
                for (ExpressionNode n : this.parameters) {
                    String msg2 = n.check();
                    if (msg2 == null) continue;
                    return msg2;
                }
                break;
            }
            case Constant: {
                if (!Utilities.noString((String)this.constant)) break;
                return "No Constant provided @ " + this.location();
            }
            case Group: {
                if (this.group == null) {
                    return "No Group provided @ " + this.location();
                }
                msg = this.group.check();
                if (msg == null) break;
                return msg;
            }
        }
        if (this.inner != null && (msg = this.inner.check()) != null) {
            return msg;
        }
        if (this.operation == null) {
            if (this.opNext != null) {
                return "Next provided when it shouldn't be @ " + this.location();
            }
        } else {
            if (this.opNext == null) {
                return "No Next provided @ " + this.location();
            }
            this.opNext.check();
        }
        return null;
    }

    private String location() {
        return Integer.toString(this.start.line) + ", " + Integer.toString(this.start.column);
    }

    public TypeDetails getTypes() {
        return this.types;
    }

    public void setTypes(TypeDetails types) {
        this.types = types;
    }

    public TypeDetails getOpTypes() {
        return this.opTypes;
    }

    public void setOpTypes(TypeDetails opTypes) {
        this.opTypes = opTypes;
    }

    public static enum CollectionStatus {
        SINGLETON,
        ORDERED,
        UNORDERED;

    }

    public static enum Operation {
        Equals,
        Equivalent,
        NotEquals,
        NotEquivalent,
        LessThen,
        Greater,
        LessOrEqual,
        GreaterOrEqual,
        Is,
        As,
        Union,
        Or,
        And,
        Xor,
        Implies,
        Times,
        DivideBy,
        Plus,
        Minus,
        Concatenate,
        Div,
        Mod,
        In,
        Contains,
        MemberOf;


        public static Operation fromCode(String name) {
            if (Utilities.noString((String)name)) {
                return null;
            }
            if (name.equals("=")) {
                return Equals;
            }
            if (name.equals("~")) {
                return Equivalent;
            }
            if (name.equals("!=")) {
                return NotEquals;
            }
            if (name.equals("!~")) {
                return NotEquivalent;
            }
            if (name.equals(">")) {
                return Greater;
            }
            if (name.equals("<")) {
                return LessThen;
            }
            if (name.equals(">=")) {
                return GreaterOrEqual;
            }
            if (name.equals("<=")) {
                return LessOrEqual;
            }
            if (name.equals("|")) {
                return Union;
            }
            if (name.equals("or")) {
                return Or;
            }
            if (name.equals("and")) {
                return And;
            }
            if (name.equals("xor")) {
                return Xor;
            }
            if (name.equals("is")) {
                return Is;
            }
            if (name.equals("as")) {
                return As;
            }
            if (name.equals("*")) {
                return Times;
            }
            if (name.equals("/")) {
                return DivideBy;
            }
            if (name.equals("+")) {
                return Plus;
            }
            if (name.equals("-")) {
                return Minus;
            }
            if (name.equals("&")) {
                return Concatenate;
            }
            if (name.equals("implies")) {
                return Implies;
            }
            if (name.equals("div")) {
                return Div;
            }
            if (name.equals("mod")) {
                return Mod;
            }
            if (name.equals("in")) {
                return In;
            }
            if (name.equals("contains")) {
                return Contains;
            }
            if (name.equals("memberOf")) {
                return MemberOf;
            }
            return null;
        }

        public String toCode() {
            switch (this) {
                case Equals: {
                    return "=";
                }
                case Equivalent: {
                    return "~";
                }
                case NotEquals: {
                    return "!=";
                }
                case NotEquivalent: {
                    return "!~";
                }
                case Greater: {
                    return ">";
                }
                case LessThen: {
                    return "<";
                }
                case GreaterOrEqual: {
                    return ">=";
                }
                case LessOrEqual: {
                    return "<=";
                }
                case Union: {
                    return "|";
                }
                case Or: {
                    return "or";
                }
                case And: {
                    return "and";
                }
                case Xor: {
                    return "xor";
                }
                case Times: {
                    return "*";
                }
                case DivideBy: {
                    return "/";
                }
                case Plus: {
                    return "+";
                }
                case Minus: {
                    return "-";
                }
                case Concatenate: {
                    return "&";
                }
                case Implies: {
                    return "implies";
                }
                case Is: {
                    return "is";
                }
                case As: {
                    return "as";
                }
                case Div: {
                    return "div";
                }
                case Mod: {
                    return "mod";
                }
                case In: {
                    return "in";
                }
                case Contains: {
                    return "contains";
                }
                case MemberOf: {
                    return "memberOf";
                }
            }
            return "??";
        }
    }

    public static enum Function {
        Custom,
        Empty,
        Not,
        Exists,
        SubsetOf,
        SupersetOf,
        IsDistinct,
        Distinct,
        Count,
        Where,
        Select,
        All,
        Repeat,
        Item,
        As,
        Is,
        Single,
        First,
        Last,
        Tail,
        Skip,
        Take,
        Iif,
        ToInteger,
        ToDecimal,
        ToString,
        Substring,
        StartsWith,
        EndsWith,
        Matches,
        ReplaceMatches,
        Contains,
        Replace,
        Length,
        Children,
        Descendants,
        MemberOf,
        Trace,
        Today,
        Now,
        Resolve,
        Extension,
        HasValue,
        AliasAs,
        Alias;


        public static Function fromCode(String name) {
            if (name.equals("empty")) {
                return Empty;
            }
            if (name.equals("not")) {
                return Not;
            }
            if (name.equals("exists")) {
                return Exists;
            }
            if (name.equals("subsetOf")) {
                return SubsetOf;
            }
            if (name.equals("supersetOf")) {
                return SupersetOf;
            }
            if (name.equals("isDistinct")) {
                return IsDistinct;
            }
            if (name.equals("distinct")) {
                return Distinct;
            }
            if (name.equals("count")) {
                return Count;
            }
            if (name.equals("where")) {
                return Where;
            }
            if (name.equals("select")) {
                return Select;
            }
            if (name.equals("all")) {
                return All;
            }
            if (name.equals("repeat")) {
                return Repeat;
            }
            if (name.equals("item")) {
                return Item;
            }
            if (name.equals("as")) {
                return As;
            }
            if (name.equals("is")) {
                return Is;
            }
            if (name.equals("single")) {
                return Single;
            }
            if (name.equals("first")) {
                return First;
            }
            if (name.equals("last")) {
                return Last;
            }
            if (name.equals("tail")) {
                return Tail;
            }
            if (name.equals("skip")) {
                return Skip;
            }
            if (name.equals("take")) {
                return Take;
            }
            if (name.equals("iif")) {
                return Iif;
            }
            if (name.equals("toInteger")) {
                return ToInteger;
            }
            if (name.equals("toDecimal")) {
                return ToDecimal;
            }
            if (name.equals("toString")) {
                return ToString;
            }
            if (name.equals("substring")) {
                return Substring;
            }
            if (name.equals("startsWith")) {
                return StartsWith;
            }
            if (name.equals("endsWith")) {
                return EndsWith;
            }
            if (name.equals("matches")) {
                return Matches;
            }
            if (name.equals("replaceMatches")) {
                return ReplaceMatches;
            }
            if (name.equals("contains")) {
                return Contains;
            }
            if (name.equals("replace")) {
                return Replace;
            }
            if (name.equals("length")) {
                return Length;
            }
            if (name.equals("children")) {
                return Children;
            }
            if (name.equals("descendants")) {
                return Descendants;
            }
            if (name.equals("memberOf")) {
                return MemberOf;
            }
            if (name.equals("trace")) {
                return Trace;
            }
            if (name.equals("today")) {
                return Today;
            }
            if (name.equals("now")) {
                return Now;
            }
            if (name.equals("resolve")) {
                return Resolve;
            }
            if (name.equals("extension")) {
                return Extension;
            }
            if (name.equals("hasValue")) {
                return HasValue;
            }
            if (name.equals("alias")) {
                return Alias;
            }
            if (name.equals("aliasAs")) {
                return AliasAs;
            }
            return null;
        }

        public String toCode() {
            switch (this) {
                case Empty: {
                    return "empty";
                }
                case Not: {
                    return "not";
                }
                case Exists: {
                    return "exists";
                }
                case SubsetOf: {
                    return "subsetOf";
                }
                case SupersetOf: {
                    return "supersetOf";
                }
                case IsDistinct: {
                    return "isDistinct";
                }
                case Distinct: {
                    return "distinct";
                }
                case Count: {
                    return "count";
                }
                case Where: {
                    return "where";
                }
                case Select: {
                    return "select";
                }
                case All: {
                    return "all";
                }
                case Repeat: {
                    return "repeat";
                }
                case Item: {
                    return "item";
                }
                case As: {
                    return "as";
                }
                case Is: {
                    return "is";
                }
                case Single: {
                    return "single";
                }
                case First: {
                    return "first";
                }
                case Last: {
                    return "last";
                }
                case Tail: {
                    return "tail";
                }
                case Skip: {
                    return "skip";
                }
                case Take: {
                    return "take";
                }
                case Iif: {
                    return "iif";
                }
                case ToInteger: {
                    return "toInteger";
                }
                case ToDecimal: {
                    return "toDecimal";
                }
                case ToString: {
                    return "toString";
                }
                case Substring: {
                    return "substring";
                }
                case StartsWith: {
                    return "startsWith";
                }
                case EndsWith: {
                    return "endsWith";
                }
                case Matches: {
                    return "matches";
                }
                case ReplaceMatches: {
                    return "replaceMatches";
                }
                case Contains: {
                    return "contains";
                }
                case Replace: {
                    return "replace";
                }
                case Length: {
                    return "length";
                }
                case Children: {
                    return "children";
                }
                case Descendants: {
                    return "descendants";
                }
                case MemberOf: {
                    return "memberOf";
                }
                case Trace: {
                    return "trace";
                }
                case Today: {
                    return "today";
                }
                case Now: {
                    return "now";
                }
                case Resolve: {
                    return "resolve";
                }
                case Extension: {
                    return "extension";
                }
                case HasValue: {
                    return "hasValue";
                }
                case Alias: {
                    return "alias";
                }
                case AliasAs: {
                    return "aliasAs";
                }
            }
            return "??";
        }
    }

    public static class SourceLocation {
        private int line;
        private int column;

        public SourceLocation(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public String toString() {
            return Integer.toString(this.line) + ", " + Integer.toString(this.column);
        }
    }

    public static enum Kind {
        Name,
        Function,
        Constant,
        Group;

    }
}

