/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.ServiceDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="GuidanceResponse", profile="http://hl7.org/fhir/Profile/GuidanceResponse")
public class GuidanceResponse
extends DomainResource {
    @Child(name="requestId", type={IdType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The id of the request associated with this response, if any", formalDefinition="The id of the request associated with this response. If an id was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.")
    protected IdType requestId;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Allows a service to provide a unique, business identifier for the response.")
    protected Identifier identifier;
    @Child(name="module", type={ServiceDefinition.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A reference to a knowledge module", formalDefinition="A reference to the knowledge module that was invoked.")
    protected Reference module;
    protected ServiceDefinition moduleTarget;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="success | data-requested | data-required | in-progress | failure | entered-in-error", formalDefinition="The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/guidance-response-status")
    protected Enumeration<GuidanceResponseStatus> status;
    @Child(name="subject", type={Patient.class, Group.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient the request was performed for", formalDefinition="The patient for which the request was processed.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter or Episode during which the response was returned", formalDefinition="Allows the context of the guidance response to be provided if available. In a service context, this would likely be unavailable.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="occurrenceDateTime", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the guidance response was processed", formalDefinition="Indicates when the guidance response was processed.")
    protected DateTimeType occurrenceDateTime;
    @Child(name="performer", type={Device.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Device returning the guidance", formalDefinition="Provides a reference to the device that performed the guidance.")
    protected Reference performer;
    protected Device performerTarget;
    @Child(name="reason", type={CodeableConcept.class, Reference.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for the response", formalDefinition="Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.")
    protected Type reason;
    @Child(name="note", type={Annotation.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional notes about the response", formalDefinition="Provides a mechanism to communicate additional information about the response.")
    protected List<Annotation> note;
    @Child(name="evaluationMessage", type={OperationOutcome.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Messages resulting from the evaluation of the artifact or artifacts", formalDefinition="Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.")
    protected List<Reference> evaluationMessage;
    protected List<OperationOutcome> evaluationMessageTarget;
    @Child(name="outputParameters", type={Parameters.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The output parameters of the evaluation, if any", formalDefinition="The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.")
    protected Reference outputParameters;
    protected Parameters outputParametersTarget;
    @Child(name="result", type={CarePlan.class, RequestGroup.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Proposed actions, if any", formalDefinition="The actions, if any, produced by the evaluation of the artifact.")
    protected Reference result;
    protected Resource resultTarget;
    @Child(name="dataRequirement", type={DataRequirement.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional required data", formalDefinition="If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.")
    protected List<DataRequirement> dataRequirement;
    private static final long serialVersionUID = -2107029772L;
    @SearchParamDefinition(name="request", path="GuidanceResponse.requestId", description="The identifier of the request associated with the response", type="token")
    public static final String SP_REQUEST = "request";
    public static final TokenClientParam REQUEST = new TokenClientParam("request");
    @SearchParamDefinition(name="identifier", path="GuidanceResponse.identifier", description="The identifier of the guidance response", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="GuidanceResponse.subject", description="The identity of a patient to search for guidance response results", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("GuidanceResponse:patient").toLocked();
    @SearchParamDefinition(name="subject", path="GuidanceResponse.subject", description="The subject that the guidance response is about", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("GuidanceResponse:subject").toLocked();

    public GuidanceResponse() {
    }

    public GuidanceResponse(Reference module, Enumeration<GuidanceResponseStatus> status) {
        this.module = module;
        this.status = status;
    }

    public IdType getRequestIdElement() {
        if (this.requestId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.requestId");
            }
            if (Configuration.doAutoCreate()) {
                this.requestId = new IdType();
            }
        }
        return this.requestId;
    }

    public boolean hasRequestIdElement() {
        return this.requestId != null && !this.requestId.isEmpty();
    }

    public boolean hasRequestId() {
        return this.requestId != null && !this.requestId.isEmpty();
    }

    public GuidanceResponse setRequestIdElement(IdType value) {
        this.requestId = value;
        return this;
    }

    public String getRequestId() {
        return this.requestId == null ? null : this.requestId.getValue();
    }

    public GuidanceResponse setRequestId(String value) {
        if (Utilities.noString((String)value)) {
            this.requestId = null;
        } else {
            if (this.requestId == null) {
                this.requestId = new IdType();
            }
            this.requestId.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public GuidanceResponse setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Reference getModule() {
        if (this.module == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.module");
            }
            if (Configuration.doAutoCreate()) {
                this.module = new Reference();
            }
        }
        return this.module;
    }

    public boolean hasModule() {
        return this.module != null && !this.module.isEmpty();
    }

    public GuidanceResponse setModule(Reference value) {
        this.module = value;
        return this;
    }

    public ServiceDefinition getModuleTarget() {
        if (this.moduleTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.module");
            }
            if (Configuration.doAutoCreate()) {
                this.moduleTarget = new ServiceDefinition();
            }
        }
        return this.moduleTarget;
    }

    public GuidanceResponse setModuleTarget(ServiceDefinition value) {
        this.moduleTarget = value;
        return this;
    }

    public Enumeration<GuidanceResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<GuidanceResponseStatus>(new GuidanceResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public GuidanceResponse setStatusElement(Enumeration<GuidanceResponseStatus> value) {
        this.status = value;
        return this;
    }

    public GuidanceResponseStatus getStatus() {
        return this.status == null ? null : (GuidanceResponseStatus)((Object)this.status.getValue());
    }

    public GuidanceResponse setStatus(GuidanceResponseStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<GuidanceResponseStatus>(new GuidanceResponseStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public GuidanceResponse setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public GuidanceResponse setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public GuidanceResponse setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public GuidanceResponse setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public DateTimeType getOccurrenceDateTimeElement() {
        if (this.occurrenceDateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.occurrenceDateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.occurrenceDateTime = new DateTimeType();
            }
        }
        return this.occurrenceDateTime;
    }

    public boolean hasOccurrenceDateTimeElement() {
        return this.occurrenceDateTime != null && !this.occurrenceDateTime.isEmpty();
    }

    public boolean hasOccurrenceDateTime() {
        return this.occurrenceDateTime != null && !this.occurrenceDateTime.isEmpty();
    }

    public GuidanceResponse setOccurrenceDateTimeElement(DateTimeType value) {
        this.occurrenceDateTime = value;
        return this;
    }

    public Date getOccurrenceDateTime() {
        return this.occurrenceDateTime == null ? null : (Date)this.occurrenceDateTime.getValue();
    }

    public GuidanceResponse setOccurrenceDateTime(Date value) {
        if (value == null) {
            this.occurrenceDateTime = null;
        } else {
            if (this.occurrenceDateTime == null) {
                this.occurrenceDateTime = new DateTimeType();
            }
            this.occurrenceDateTime.setValue(value);
        }
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public GuidanceResponse setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Device getPerformerTarget() {
        if (this.performerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performerTarget = new Device();
            }
        }
        return this.performerTarget;
    }

    public GuidanceResponse setPerformerTarget(Device value) {
        this.performerTarget = value;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public GuidanceResponse setReason(Type value) {
        this.reason = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public GuidanceResponse setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public GuidanceResponse addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getEvaluationMessage() {
        if (this.evaluationMessage == null) {
            this.evaluationMessage = new ArrayList<Reference>();
        }
        return this.evaluationMessage;
    }

    public GuidanceResponse setEvaluationMessage(List<Reference> theEvaluationMessage) {
        this.evaluationMessage = theEvaluationMessage;
        return this;
    }

    public boolean hasEvaluationMessage() {
        if (this.evaluationMessage == null) {
            return false;
        }
        for (Reference item : this.evaluationMessage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEvaluationMessage() {
        Reference t = new Reference();
        if (this.evaluationMessage == null) {
            this.evaluationMessage = new ArrayList<Reference>();
        }
        this.evaluationMessage.add(t);
        return t;
    }

    public GuidanceResponse addEvaluationMessage(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.evaluationMessage == null) {
            this.evaluationMessage = new ArrayList<Reference>();
        }
        this.evaluationMessage.add(t);
        return this;
    }

    public Reference getEvaluationMessageFirstRep() {
        if (this.getEvaluationMessage().isEmpty()) {
            this.addEvaluationMessage();
        }
        return this.getEvaluationMessage().get(0);
    }

    @Deprecated
    public List<OperationOutcome> getEvaluationMessageTarget() {
        if (this.evaluationMessageTarget == null) {
            this.evaluationMessageTarget = new ArrayList<OperationOutcome>();
        }
        return this.evaluationMessageTarget;
    }

    @Deprecated
    public OperationOutcome addEvaluationMessageTarget() {
        OperationOutcome r = new OperationOutcome();
        if (this.evaluationMessageTarget == null) {
            this.evaluationMessageTarget = new ArrayList<OperationOutcome>();
        }
        this.evaluationMessageTarget.add(r);
        return r;
    }

    public Reference getOutputParameters() {
        if (this.outputParameters == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.outputParameters");
            }
            if (Configuration.doAutoCreate()) {
                this.outputParameters = new Reference();
            }
        }
        return this.outputParameters;
    }

    public boolean hasOutputParameters() {
        return this.outputParameters != null && !this.outputParameters.isEmpty();
    }

    public GuidanceResponse setOutputParameters(Reference value) {
        this.outputParameters = value;
        return this;
    }

    public Parameters getOutputParametersTarget() {
        if (this.outputParametersTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.outputParameters");
            }
            if (Configuration.doAutoCreate()) {
                this.outputParametersTarget = new Parameters();
            }
        }
        return this.outputParametersTarget;
    }

    public GuidanceResponse setOutputParametersTarget(Parameters value) {
        this.outputParametersTarget = value;
        return this;
    }

    public Reference getResult() {
        if (this.result == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.result");
            }
            if (Configuration.doAutoCreate()) {
                this.result = new Reference();
            }
        }
        return this.result;
    }

    public boolean hasResult() {
        return this.result != null && !this.result.isEmpty();
    }

    public GuidanceResponse setResult(Reference value) {
        this.result = value;
        return this;
    }

    public Resource getResultTarget() {
        return this.resultTarget;
    }

    public GuidanceResponse setResultTarget(Resource value) {
        this.resultTarget = value;
        return this;
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public GuidanceResponse setDataRequirement(List<DataRequirement> theDataRequirement) {
        this.dataRequirement = theDataRequirement;
        return this;
    }

    public boolean hasDataRequirement() {
        if (this.dataRequirement == null) {
            return false;
        }
        for (DataRequirement item : this.dataRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirement addDataRequirement() {
        DataRequirement t = new DataRequirement();
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return t;
    }

    public GuidanceResponse addDataRequirement(DataRequirement t) {
        if (t == null) {
            return this;
        }
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return this;
    }

    public DataRequirement getDataRequirementFirstRep() {
        if (this.getDataRequirement().isEmpty()) {
            this.addDataRequirement();
        }
        return this.getDataRequirement().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("requestId", "id", "The id of the request associated with this response. If an id was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.", 0, 1, this.requestId));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the response.", 0, 1, this.identifier));
        children.add(new Property("module", "Reference(ServiceDefinition)", "A reference to the knowledge module that was invoked.", 0, 1, this.module));
        children.add(new Property("status", "code", "The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.", 0, 1, this.status));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient for which the request was processed.", 0, 1, this.subject));
        children.add(new Property("context", "Reference(Encounter|EpisodeOfCare)", "Allows the context of the guidance response to be provided if available. In a service context, this would likely be unavailable.", 0, 1, this.context));
        children.add(new Property("occurrenceDateTime", "dateTime", "Indicates when the guidance response was processed.", 0, 1, this.occurrenceDateTime));
        children.add(new Property("performer", "Reference(Device)", "Provides a reference to the device that performed the guidance.", 0, 1, this.performer));
        children.add(new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason));
        children.add(new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("evaluationMessage", "Reference(OperationOutcome)", "Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.", 0, Integer.MAX_VALUE, this.evaluationMessage));
        children.add(new Property("outputParameters", "Reference(Parameters)", "The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.", 0, 1, this.outputParameters));
        children.add(new Property("result", "Reference(CarePlan|RequestGroup)", "The actions, if any, produced by the evaluation of the artifact.", 0, 1, this.result));
        children.add(new Property("dataRequirement", "DataRequirement", "If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.", 0, Integer.MAX_VALUE, this.dataRequirement));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 693933066: {
                return new Property("requestId", "id", "The id of the request associated with this response. If an id was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.", 0, 1, this.requestId);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the response.", 0, 1, this.identifier);
            }
            case -1068784020: {
                return new Property("module", "Reference(ServiceDefinition)", "A reference to the knowledge module that was invoked.", 0, 1, this.module);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.", 0, 1, this.status);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient for which the request was processed.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property("context", "Reference(Encounter|EpisodeOfCare)", "Allows the context of the guidance response to be provided if available. In a service context, this would likely be unavailable.", 0, 1, this.context);
            }
            case -298443636: {
                return new Property("occurrenceDateTime", "dateTime", "Indicates when the guidance response was processed.", 0, 1, this.occurrenceDateTime);
            }
            case 481140686: {
                return new Property("performer", "Reference(Device)", "Provides a reference to the device that performed the guidance.", 0, 1, this.performer);
            }
            case -669418564: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case -934964668: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case -610155331: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case -1146218137: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1081619755: {
                return new Property("evaluationMessage", "Reference(OperationOutcome)", "Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.", 0, Integer.MAX_VALUE, this.evaluationMessage);
            }
            case 525609419: {
                return new Property("outputParameters", "Reference(Parameters)", "The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.", 0, 1, this.outputParameters);
            }
            case -934426595: {
                return new Property("result", "Reference(CarePlan|RequestGroup)", "The actions, if any, produced by the evaluation of the artifact.", 0, 1, this.result);
            }
            case 629147193: {
                return new Property("dataRequirement", "DataRequirement", "If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.", 0, Integer.MAX_VALUE, this.dataRequirement);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 693933066: {
                Base[] baseArray;
                if (this.requestId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.requestId;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case -1068784020: {
                Base[] baseArray;
                if (this.module == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.module;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.context;
                }
                return baseArray;
            }
            case -298443636: {
                Base[] baseArray;
                if (this.occurrenceDateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.occurrenceDateTime;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.performer;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.reason;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1081619755: {
                return this.evaluationMessage == null ? new Base[]{} : this.evaluationMessage.toArray(new Base[this.evaluationMessage.size()]);
            }
            case 525609419: {
                Base[] baseArray;
                if (this.outputParameters == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.outputParameters;
                }
                return baseArray;
            }
            case -934426595: {
                Base[] baseArray;
                if (this.result == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.result;
                }
                return baseArray;
            }
            case 629147193: {
                return this.dataRequirement == null ? new Base[]{} : this.dataRequirement.toArray(new Base[this.dataRequirement.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 693933066: {
                this.requestId = this.castToId(value);
                return value;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -1068784020: {
                this.module = this.castToReference(value);
                return value;
            }
            case -892481550: {
                value = new GuidanceResponseStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -298443636: {
                this.occurrenceDateTime = this.castToDateTime(value);
                return value;
            }
            case 481140686: {
                this.performer = this.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = this.castToType(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 1081619755: {
                this.getEvaluationMessage().add(this.castToReference(value));
                return value;
            }
            case 525609419: {
                this.outputParameters = this.castToReference(value);
                return value;
            }
            case -934426595: {
                this.result = this.castToReference(value);
                return value;
            }
            case 629147193: {
                this.getDataRequirement().add(this.castToDataRequirement(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("requestId")) {
            this.requestId = this.castToId(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("module")) {
            this.module = this.castToReference(value);
        } else if (name.equals("status")) {
            value = new GuidanceResponseStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("context")) {
            this.context = this.castToReference(value);
        } else if (name.equals("occurrenceDateTime")) {
            this.occurrenceDateTime = this.castToDateTime(value);
        } else if (name.equals("performer")) {
            this.performer = this.castToReference(value);
        } else if (name.equals("reason[x]")) {
            this.reason = this.castToType(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("evaluationMessage")) {
            this.getEvaluationMessage().add(this.castToReference(value));
        } else if (name.equals("outputParameters")) {
            this.outputParameters = this.castToReference(value);
        } else if (name.equals("result")) {
            this.result = this.castToReference(value);
        } else if (name.equals("dataRequirement")) {
            this.getDataRequirement().add(this.castToDataRequirement(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 693933066: {
                return this.getRequestIdElement();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case -1068784020: {
                return this.getModule();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -298443636: {
                return this.getOccurrenceDateTimeElement();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -669418564: {
                return this.getReason();
            }
            case -934964668: {
                return this.getReason();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1081619755: {
                return this.addEvaluationMessage();
            }
            case 525609419: {
                return this.getOutputParameters();
            }
            case -934426595: {
                return this.getResult();
            }
            case 629147193: {
                return this.addDataRequirement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 693933066: {
                return new String[]{"id"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1068784020: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -298443636: {
                return new String[]{"dateTime"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1081619755: {
                return new String[]{"Reference"};
            }
            case 525609419: {
                return new String[]{"Reference"};
            }
            case -934426595: {
                return new String[]{"Reference"};
            }
            case 629147193: {
                return new String[]{"DataRequirement"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("requestId")) {
            throw new FHIRException("Cannot call addChild on a primitive type GuidanceResponse.requestId");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("module")) {
            this.module = new Reference();
            return this.module;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type GuidanceResponse.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("context")) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("occurrenceDateTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type GuidanceResponse.occurrenceDateTime");
        }
        if (name.equals("performer")) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("evaluationMessage")) {
            return this.addEvaluationMessage();
        }
        if (name.equals("outputParameters")) {
            this.outputParameters = new Reference();
            return this.outputParameters;
        }
        if (name.equals("result")) {
            this.result = new Reference();
            return this.result;
        }
        if (name.equals("dataRequirement")) {
            return this.addDataRequirement();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "GuidanceResponse";
    }

    @Override
    public GuidanceResponse copy() {
        GuidanceResponse dst = new GuidanceResponse();
        this.copyValues(dst);
        dst.requestId = this.requestId == null ? null : this.requestId.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.module = this.module == null ? null : this.module.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.occurrenceDateTime = this.occurrenceDateTime == null ? null : this.occurrenceDateTime.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        Type type = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.evaluationMessage != null) {
            dst.evaluationMessage = new ArrayList<Reference>();
            for (Reference reference : this.evaluationMessage) {
                dst.evaluationMessage.add(reference.copy());
            }
        }
        dst.outputParameters = this.outputParameters == null ? null : this.outputParameters.copy();
        Reference reference = dst.result = this.result == null ? null : this.result.copy();
        if (this.dataRequirement != null) {
            dst.dataRequirement = new ArrayList<DataRequirement>();
            for (DataRequirement dataRequirement : this.dataRequirement) {
                dst.dataRequirement.add(dataRequirement.copy());
            }
        }
        return dst;
    }

    protected GuidanceResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof GuidanceResponse)) {
            return false;
        }
        GuidanceResponse o = (GuidanceResponse)other;
        return GuidanceResponse.compareDeep(this.requestId, o.requestId, true) && GuidanceResponse.compareDeep(this.identifier, o.identifier, true) && GuidanceResponse.compareDeep(this.module, o.module, true) && GuidanceResponse.compareDeep(this.status, o.status, true) && GuidanceResponse.compareDeep(this.subject, o.subject, true) && GuidanceResponse.compareDeep(this.context, o.context, true) && GuidanceResponse.compareDeep(this.occurrenceDateTime, o.occurrenceDateTime, true) && GuidanceResponse.compareDeep(this.performer, o.performer, true) && GuidanceResponse.compareDeep(this.reason, o.reason, true) && GuidanceResponse.compareDeep(this.note, o.note, true) && GuidanceResponse.compareDeep(this.evaluationMessage, o.evaluationMessage, true) && GuidanceResponse.compareDeep(this.outputParameters, o.outputParameters, true) && GuidanceResponse.compareDeep(this.result, o.result, true) && GuidanceResponse.compareDeep(this.dataRequirement, o.dataRequirement, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof GuidanceResponse)) {
            return false;
        }
        GuidanceResponse o = (GuidanceResponse)other;
        return GuidanceResponse.compareValues(this.requestId, o.requestId, true) && GuidanceResponse.compareValues(this.status, o.status, true) && GuidanceResponse.compareValues(this.occurrenceDateTime, o.occurrenceDateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.requestId, this.identifier, this.module, this.status, this.subject, this.context, this.occurrenceDateTime, this.performer, this.reason, this.note, this.evaluationMessage, this.outputParameters, this.result, this.dataRequirement});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.GuidanceResponse;
    }

    public static class GuidanceResponseStatusEnumFactory
    implements EnumFactory<GuidanceResponseStatus> {
        @Override
        public GuidanceResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("success".equals(codeString)) {
                return GuidanceResponseStatus.SUCCESS;
            }
            if ("data-requested".equals(codeString)) {
                return GuidanceResponseStatus.DATAREQUESTED;
            }
            if ("data-required".equals(codeString)) {
                return GuidanceResponseStatus.DATAREQUIRED;
            }
            if ("in-progress".equals(codeString)) {
                return GuidanceResponseStatus.INPROGRESS;
            }
            if ("failure".equals(codeString)) {
                return GuidanceResponseStatus.FAILURE;
            }
            if ("entered-in-error".equals(codeString)) {
                return GuidanceResponseStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        public Enumeration<GuidanceResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuidanceResponseStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("success".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.SUCCESS);
            }
            if ("data-requested".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.DATAREQUESTED);
            }
            if ("data-required".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.DATAREQUIRED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.INPROGRESS);
            }
            if ("failure".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.FAILURE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(GuidanceResponseStatus code) {
            if (code == GuidanceResponseStatus.SUCCESS) {
                return "success";
            }
            if (code == GuidanceResponseStatus.DATAREQUESTED) {
                return "data-requested";
            }
            if (code == GuidanceResponseStatus.DATAREQUIRED) {
                return "data-required";
            }
            if (code == GuidanceResponseStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == GuidanceResponseStatus.FAILURE) {
                return "failure";
            }
            if (code == GuidanceResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(GuidanceResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum GuidanceResponseStatus {
        SUCCESS,
        DATAREQUESTED,
        DATAREQUIRED,
        INPROGRESS,
        FAILURE,
        ENTEREDINERROR,
        NULL;


        public static GuidanceResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("success".equals(codeString)) {
                return SUCCESS;
            }
            if ("data-requested".equals(codeString)) {
                return DATAREQUESTED;
            }
            if ("data-required".equals(codeString)) {
                return DATAREQUIRED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("failure".equals(codeString)) {
                return FAILURE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SUCCESS: {
                    return "success";
                }
                case DATAREQUESTED: {
                    return "data-requested";
                }
                case DATAREQUIRED: {
                    return "data-required";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case FAILURE: {
                    return "failure";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SUCCESS: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case DATAREQUESTED: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case DATAREQUIRED: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case FAILURE: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SUCCESS: {
                    return "The request was processed successfully";
                }
                case DATAREQUESTED: {
                    return "The request was processed successfully, but more data may result in a more complete evaluation";
                }
                case DATAREQUIRED: {
                    return "The request was processed, but more data is required to complete the evaluation";
                }
                case INPROGRESS: {
                    return "The request is currently being processed";
                }
                case FAILURE: {
                    return "The request was not processed successfully";
                }
                case ENTEREDINERROR: {
                    return "The response was entered in error";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SUCCESS: {
                    return "Success";
                }
                case DATAREQUESTED: {
                    return "Data Requested";
                }
                case DATAREQUIRED: {
                    return "Data Required";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case FAILURE: {
                    return "Failure";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
            }
            return "?";
        }
    }
}

