/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;

@ResourceDef(name="Parameters", profile="http://hl7.org/fhir/Profile/Parameters")
public class Parameters
extends Resource
implements IBaseParameters {
    @Child(name="parameter", type={}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Operation Parameter", formalDefinition="A parameter passed to or received from the operation.")
    protected List<ParametersParameterComponent> parameter;
    private static final long serialVersionUID = -1495940293L;

    public List<ParametersParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        return this.parameter;
    }

    public Parameters setParameter(List<ParametersParameterComponent> theParameter) {
        this.parameter = theParameter;
        return this;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (ParametersParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParametersParameterComponent addParameter() {
        ParametersParameterComponent t = new ParametersParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public Parameters addParameter(ParametersParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public ParametersParameterComponent getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            this.addParameter();
        }
        return this.getParameter().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("parameter", "", "A parameter passed to or received from the operation.", 0, Integer.MAX_VALUE, this.parameter));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1954460585: {
                return new Property("parameter", "", "A parameter passed to or received from the operation.", 0, Integer.MAX_VALUE, this.parameter);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                this.getParameter().add((ParametersParameterComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("parameter")) {
            return super.setProperty(name, value);
        }
        this.getParameter().add((ParametersParameterComponent)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                return this.addParameter();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Parameters";
    }

    @Override
    public Parameters copy() {
        Parameters dst = new Parameters();
        this.copyValues(dst);
        if (this.parameter != null) {
            dst.parameter = new ArrayList<ParametersParameterComponent>();
            for (ParametersParameterComponent i : this.parameter) {
                dst.parameter.add(i.copy());
            }
        }
        return dst;
    }

    protected Parameters typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Parameters)) {
            return false;
        }
        Parameters o = (Parameters)other;
        return Parameters.compareDeep(this.parameter, o.parameter, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Parameters)) {
            return false;
        }
        Parameters o = (Parameters)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.parameter);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Parameters;
    }

    @Block
    public static class ParametersParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name from the definition", formalDefinition="The name of the parameter (reference to the operation definition).")
        protected StringType name;
        @Child(name="value", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If parameter is a data type", formalDefinition="If the parameter is a data type.")
        protected Type value;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If parameter is a whole resource", formalDefinition="If the parameter is a whole resource.")
        protected Resource resource;
        @Child(name="part", type={ParametersParameterComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Named part of a multi-part parameter", formalDefinition="A named part of a multi-part parameter.")
        protected List<ParametersParameterComponent> part;
        private static final long serialVersionUID = -1265707999L;

        public ParametersParameterComponent() {
        }

        public ParametersParameterComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ParametersParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ParametersParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ParametersParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ParametersParameterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public ParametersParameterComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public List<ParametersParameterComponent> getPart() {
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            return this.part;
        }

        public ParametersParameterComponent setPart(List<ParametersParameterComponent> thePart) {
            this.part = thePart;
            return this;
        }

        public boolean hasPart() {
            if (this.part == null) {
                return false;
            }
            for (ParametersParameterComponent item : this.part) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ParametersParameterComponent addPart() {
            ParametersParameterComponent t = new ParametersParameterComponent();
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            this.part.add(t);
            return t;
        }

        public ParametersParameterComponent addPart(ParametersParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            this.part.add(t);
            return this;
        }

        public ParametersParameterComponent getPartFirstRep() {
            if (this.getPart().isEmpty()) {
                this.addPart();
            }
            return this.getPart().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name of the parameter (reference to the operation definition).", 0, 1, this.name));
            children.add(new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value));
            children.add(new Property("resource", "Resource", "If the parameter is a whole resource.", 0, 1, this.resource));
            children.add(new Property("part", "@Parameters.parameter", "A named part of a multi-part parameter.", 0, Integer.MAX_VALUE, this.part));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name of the parameter (reference to the operation definition).", 0, 1, this.name);
                }
                case -1410166417: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -765920490: {
                    return new Property("value[x]", "*", "If the parameter is a data type.", 0, 1, this.value);
                }
                case -341064690: {
                    return new Property("resource", "Resource", "If the parameter is a whole resource.", 0, 1, this.resource);
                }
                case 3433459: {
                    return new Property("part", "@Parameters.parameter", "A named part of a multi-part parameter.", 0, Integer.MAX_VALUE, this.part);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
                case 3433459: {
                    return this.part == null ? new Base[]{} : this.part.toArray(new Base[this.part.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
                case -341064690: {
                    this.resource = this.castToResource(value);
                    return value;
                }
                case 3433459: {
                    this.getPart().add((ParametersParameterComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToResource(value);
            } else if (name.equals("part")) {
                this.getPart().add((ParametersParameterComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case 3433459: {
                    return this.addPart();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"*"};
                }
                case -341064690: {
                    return new String[]{"Resource"};
                }
                case 3433459: {
                    return new String[]{"@Parameters.parameter"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Parameters.name");
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type Parameters.resource");
            }
            if (name.equals("part")) {
                return this.addPart();
            }
            return super.addChild(name);
        }

        @Override
        public ParametersParameterComponent copy() {
            ParametersParameterComponent dst = new ParametersParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            Resource resource = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.part != null) {
                dst.part = new ArrayList<ParametersParameterComponent>();
                for (ParametersParameterComponent i : this.part) {
                    dst.part.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ParametersParameterComponent)) {
                return false;
            }
            ParametersParameterComponent o = (ParametersParameterComponent)other;
            return ParametersParameterComponent.compareDeep(this.name, o.name, true) && ParametersParameterComponent.compareDeep(this.value, o.value, true) && ParametersParameterComponent.compareDeep(this.resource, o.resource, true) && ParametersParameterComponent.compareDeep(this.part, o.part, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ParametersParameterComponent)) {
                return false;
            }
            ParametersParameterComponent o = (ParametersParameterComponent)other;
            return ParametersParameterComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.value, this.resource, this.part});
        }

        @Override
        public String fhirType() {
            return "Parameters.parameter";
        }
    }
}

